/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.artifacts.migrator;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.migrator.IArtifactFixStrategy;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.services.validation.validators.ArtifactValidator;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactFixStrategy
implements IArtifactFixStrategy {
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.artifact.fix_strategy");

    @Override
    public boolean fixArtifact(EnrichedArtifact enrichedArtifact) {
        boolean hasStatusChanged = this.fixWorkflow(enrichedArtifact);
        boolean hasFieldsChanged = this.fixFields(enrichedArtifact);
        return hasStatusChanged || hasFieldsChanged;
    }

    private boolean fixWorkflow(EnrichedArtifact ea) {
        boolean hasChanged = false;
        ArtifactValidator artifactValidator = new ArtifactValidator(ea, ea, this.artifactWorkflowService);
        try {
            artifactValidator.visit(ea.artifact.workflow);
        }
        catch (ValidationException validationException) {
            ea.artifact.workflow = this.artifactWorkflowService.resetWorkflow(ea);
            hasChanged = true;
        }
        return hasChanged;
    }

    private boolean fixFields(EnrichedArtifact ea) {
        boolean hasChanged = false;
        Set<String> fieldIds = ea.blueprintVersion.fieldDefinitions.keySet();
        Iterator<String> fieldIte = ea.artifact.fields.keySet().iterator();
        while (fieldIte.hasNext()) {
            String fi = fieldIte.next();
            if (!fieldIds.contains(fi)) {
                fieldIte.remove();
                hasChanged = true;
                continue;
            }
            FieldDefinition fieldDefinition = ea.blueprintVersion.fieldDefinitions.get(fi);
            try {
                ArtifactValidator validator = new ArtifactValidator(ea, ea, this.artifactWorkflowService);
                fieldDefinition.accept(validator, fi);
            }
            catch (IllegalArgumentException e) {
                fieldIte.remove();
                hasChanged = true;
                logger.debug((Object)("Removed Artifact " + ea.artifact.id + "'s field " + fi + " because it is not valid anymore"), (Throwable)e);
            }
        }
        return hasChanged;
    }
}

