/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.sync;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetrics;
import com.dataiku.dss_gh.api.models.sync.DSSAPIDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSDeployerItems;
import com.dataiku.dss_gh.api.models.sync.DSSProject;
import com.dataiku.dss_gh.api.models.sync.DSSProjectDeployerDeployment;
import com.dataiku.dss_gh.api.models.sync.DSSProjectList;
import com.dataiku.gh.core.context.GovernActionContext;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectIdentifierWithId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.time_series.TimeSeriesDatapoint;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.dss.govern.IDSSIntegrationService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationArtifactsSearchQueryBuilder;
import com.dataiku.gh.core.services.dss.search_artifacts.IDSSIntegrationSearchArtifactsService;
import com.dataiku.gh.core.services.dss.sync.DSSArtifactsDiffSolverService;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.dss.sync.IDSSArtifactsDiffSolverService;
import com.dataiku.gh.core.services.dss.sync.IDSSIntegrationSyncService;
import com.dataiku.gh.core.services.dss.sync.IDSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.governance.IGovernanceQueueExecutorService;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.ISystemProvidedBlueprintVersionsCacheService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.time_series.ITimeSeriesDataService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.FunctionUtils;
import com.dataiku.gh.security.IPermissionsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSIntegrationSyncService
implements IDSSIntegrationSyncService {
    @Autowired
    private IDSSIntegrationSearchArtifactsService dssIntegrationSearchArtifactsService;
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private ITimeSeriesDataService timeSeriesDataService;
    @Autowired
    private IDSSIntegrationService dssIntegrationService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IDSSObjectsToArtifactMapperService dssObjectsToArtifactMapperService;
    @Autowired
    private IDSSArtifactsDiffSolverService dssArtifactsDiffSolverService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ISystemProvidedBlueprintVersionsCacheService systemProvidedCacheService;
    @Autowired
    private IGovernanceQueueExecutorService automaticGovernanceQueueService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.dss-integration-sync");

    @Override
    @GHWriteTransaction
    public void projectListDeleteDiff(AuthCtx authCtx, DSSProjectList dssProjectList) throws IOException, UnauthorizedException {
        this.permissionsService.checkAdmin(authCtx);
        List existingProjectsInDSS = dssProjectList.projects;
        List<DSSProjectIdentifierWithId> existingProjectsInGH = this.findAllProjectsProjectKeyAndId(dssProjectList.nodeId);
        logger.infoV("Starting projectListDeleteDiff sync: %s projects received from DSS. %s projects present in Govern.", new Object[]{existingProjectsInDSS.size(), existingProjectsInGH.size()});
        DSSArtifactsDiffSolverService.ProjectListDiffResult diffResult = this.dssArtifactsDiffSolverService.diffProjectListForDeletion(existingProjectsInDSS, existingProjectsInGH);
        this.deleteDSSItems(diffResult.projectsToDeleteInGH.stream().map(project -> project).collect(Collectors.toList()));
        logger.infoV("projectListDeleteDiff sync, changes by ID:" + System.lineSeparator() + String.valueOf((Object)ModificationType.NO_CHANGES) + ": %s" + System.lineSeparator() + String.valueOf((Object)ModificationType.DELETE) + ": %s", new Object[]{!diffResult.projectsToKeepInGH.isEmpty() ? diffResult.projectsToKeepInGH.stream().map(project -> project.artifactId).collect(Collectors.joining(" ; ")) : "None", !diffResult.projectsToDeleteInGH.isEmpty() ? diffResult.projectsToDeleteInGH.stream().map(project -> project.artifactId).collect(Collectors.joining(" ; ")) : "None"});
    }

    @Override
    public DSSProjectArtifactsContainer partialSync(AuthCtx authCtx, DSSProject dssProject) throws IOException, UnauthorizedException {
        DSSProjectArtifactsContainer synced;
        this.permissionsService.checkAdmin(authCtx);
        try (AutoCloseableLock ignored = NamedLock.acquire((String)DSSIntegrationSyncService.getLockKey(dssProject.dssProjectIdentifier));
             ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
            synced = this.syncDSSProject(dssProject, false);
            ts.commit();
        }
        try {
            this.automaticGovernanceQueueService.addToGovernanceQueue(DSSIntegrationSyncService.containerToGovernableArtifactIds(synced));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add artifacts to the auto-governance queue", (Throwable)e);
        }
        return synced;
    }

    @Override
    public DSSProjectArtifactsContainer fullSync(AuthCtx authCtx, DSSProject dssProject) throws IOException, UnauthorizedException {
        DSSProjectArtifactsContainer synced;
        this.permissionsService.checkAdmin(authCtx);
        try (AutoCloseableLock ignored = NamedLock.acquire((String)DSSIntegrationSyncService.getLockKey(dssProject.dssProjectIdentifier));
             ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
            synced = this.syncDSSProject(dssProject, true);
            ts.commit();
        }
        try {
            this.automaticGovernanceQueueService.addToGovernanceQueue(DSSIntegrationSyncService.containerToGovernableArtifactIds(synced));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to add artifacts to the auto-governance queue", (Throwable)e);
        }
        return synced;
    }

    @Override
    @GHWriteTransaction
    public DSSDeployerArtifactsContainer deployerFullSync(AuthCtx authCtx, DSSDeployerItems dssDeployerItems) throws UnauthorizedException, IOException {
        this.permissionsService.checkAdmin(authCtx);
        return this.syncDSSDeployerItems(dssDeployerItems, true);
    }

    @Override
    @GHWriteTransaction
    public void deployerPartialSync(AuthCtx authCtx, DSSDeployerItems dssDeployerItems) throws UnauthorizedException, IOException {
        this.permissionsService.checkAdmin(authCtx);
        this.syncDSSDeployerItems(dssDeployerItems, false);
    }

    @Override
    @GHWriteTransaction
    public void deleteDSSItem(AuthCtx authCtx, DSSItemIdentifier dssItemIdentifier) throws IOException, UnauthorizedException {
        this.permissionsService.checkAdmin(authCtx);
        this.deleteDSSItems(Collections.singletonList(dssItemIdentifier));
    }

    @Override
    @GHWriteTransaction
    public void deleteDeployerItem(AuthCtx authCtx, DSSItemIdentifier deployerItemIdentifier) throws UnauthorizedException, IOException {
        this.permissionsService.checkAdmin(authCtx);
        List artifactsIds = this.dssIntegrationSearchArtifactsService.findDeployerItemArtifacts(deployerItemIdentifier).stream().map(artifact -> artifact.id).collect(Collectors.toList());
        for (String id : artifactsIds) {
            this.archiveDSSArtifact(id);
        }
        logger.info((Object)("Deployer item sync, changes by ID:" + System.lineSeparator() + String.valueOf((Object)ModificationType.DELETE) + ": " + String.join((CharSequence)" ; ", artifactsIds)));
    }

    @Override
    @GHWriteTransaction
    public void partialSync(AuthCtx authCtx, DSSSavedModelVersionEvaluationMetrics dssSavedModelVersionEvaluationMetrics) throws IOException, UnauthorizedException {
        this.permissionsService.checkAdmin(authCtx);
        Artifact dssSavedModelVersionArtifact = this.dssIntegrationSearchArtifactsService.findDSSSavedModelVersionArtifact(dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier);
        if (dssSavedModelVersionArtifact == null) {
            throw new ValidationException("Can't find an artifact corresponding to the savedModelIdentifier " + String.valueOf(dssSavedModelVersionEvaluationMetrics.dssSavedModelVersionIdentifier));
        }
        DSSArtifactContainer.DSSSavedModelVersionArtifactContainer modelVersionContainer = DSSArtifactContainer.buildSavedModelVersion(dssSavedModelVersionArtifact, dssSavedModelVersionEvaluationMetrics.evaluationMetrics);
        if (modelVersionContainer.isTimeseriesEnabled()) {
            boolean artifactChanged = this.syncTimeseries(modelVersionContainer, false);
            if (artifactChanged |= this.syncCustomMetricsTimesSeries(modelVersionContainer, false)) {
                this.systemArtifactService.updateSystemArtifact(dssSavedModelVersionArtifact);
            }
        }
    }

    private static String getLockKey(DSSProjectIdentifier dssProjectIdentifier) {
        return "dss-sync:" + dssProjectIdentifier.nodeId + "#" + dssProjectIdentifier.projectKey;
    }

    private void deleteDSSItems(List<DSSItemIdentifier> dssItemIdentifiers) throws IOException {
        ArrayList<String> archivedProjectIds = new ArrayList<String>();
        for (DSSItemIdentifier dssItemIdentifier : dssItemIdentifiers) {
            DSSProjectArtifactsContainer projectArtifactsContainer = this.dssIntegrationSearchArtifactsService.findDSSItemWithSubItems(dssItemIdentifier);
            this.archiveArtifacts(projectArtifactsContainer);
            if (projectArtifactsContainer.getDSSProject() == null || projectArtifactsContainer.getDSSProject().artifact == null) continue;
            archivedProjectIds.add(projectArtifactsContainer.getDSSProject().artifact.id);
        }
        this.removeTemplateReferenceFromRelatedProjects(archivedProjectIds);
    }

    private void removeTemplateReferenceFromRelatedProjects(List<String> projectArtifactIds) throws IOException {
        if (projectArtifactIds.isEmpty()) {
            return;
        }
        List<String> relatedProjectApplicationInstanceIds = this.dssIntegrationSearchArtifactsService.findRelatedProjectsApplicationInstanceArtifactIds(projectArtifactIds);
        for (String id : relatedProjectApplicationInstanceIds) {
            this.systemArtifactService.updateSystemArtifact(id, ea -> ea.artifact.fields.remove("project_application_template"));
        }
    }

    private DSSProjectArtifactsContainer syncDSSProject(DSSProject dssProject, boolean withDeletion) throws IOException {
        DSSProjectArtifactsContainer newArtifacts = this.dssObjectsToArtifactMapperService.mapDSSProjectItemsToArtifacts(dssProject);
        this.generateLogOfSyncedObjects(newArtifacts, "elements sent to Sync");
        DSSProjectArtifactsContainer existingArtifacts = this.dssIntegrationSearchArtifactsService.findDSSProjectArtifacts(dssProject.dssProjectIdentifier);
        this.generateLogOfSyncedObjects(existingArtifacts, "already existing elements found in Govern");
        DSSArtifactsDiffSolverService.DiffResult<DSSProjectArtifactsContainer> result = this.dssArtifactsDiffSolverService.diffOldAndNewProjectItemsArtifacts(existingArtifacts, newArtifacts);
        String applicationProjectTemplateArtifactId = this.findProjectTemplateArtifactIdOrNull(dssProject);
        DSSProjectArtifactsContainer storedArtifacts = new DSSProjectArtifactsContainer();
        this.upsertDSSProject(result, storedArtifacts, this.linkProjectInstanceToProjectTemplate(applicationProjectTemplateArtifactId));
        Map<ModificationType, List<String>> modifiedBundlesFromUpsert = this.upsertDSSObjects(() -> ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSBundles().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSBundles().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSBundles().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToDelete).getDSSBundles().values(), storedArtifacts::getDSSBundles, this.linkBundleToParent(storedArtifacts), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedBundlesFromUpsert, "Bundles");
        Map<ModificationType, List<String>> modifiedDatasetsFromUpsert = this.upsertDSSObjects(() -> ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSDatasets().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSDatasets().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSDatasets().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToDelete).getDSSDatasets().values(), storedArtifacts::getDSSDatasets, this.linkDatasetToParent(storedArtifacts), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedDatasetsFromUpsert, "Datasets");
        Map<ModificationType, List<String>> modifiedSavedModelsFromUpsert = this.upsertDSSObjects(() -> ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSSavedModels().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSSavedModels().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSSavedModels().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToDelete).getDSSSavedModels().values(), storedArtifacts::getDSSSavedModels, this.linkSavedModelToParent(storedArtifacts), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedSavedModelsFromUpsert, "Saved models");
        Map<ModificationType, List<String>> modifiedRetrievableKnowledgesFromUpsert = this.upsertDSSObjects(() -> ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSRetrievableKnowledges().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSRetrievableKnowledges().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSRetrievableKnowledges().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToDelete).getDSSRetrievableKnowledges().values(), storedArtifacts::getDSSRetrievableKnowledges, this.linkRetrievableKnowledgeToParent(storedArtifacts), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedRetrievableKnowledgesFromUpsert, "Retrievable knowledges");
        Map<ModificationType, List<String>> modifiedSavedModelVersionsFromUpsert = this.upsertDSSObjects(() -> ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSSavedModelVersions().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSSavedModelVersions().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSSavedModelVersions().values(), () -> ((DSSProjectArtifactsContainer)result.artifactsToDelete).getDSSSavedModelVersions().values(), storedArtifacts::getDSSSavedModelVersions, this.linkSavedModelVersionToParentAndFillTimeSeries(storedArtifacts, withDeletion), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedSavedModelVersionsFromUpsert, "Saved model versions");
        if (withDeletion && CollectionUtils.isNotEmpty(existingArtifacts.duplicatedArtifacts)) {
            List<String> duplicatedArtifactIds = existingArtifacts.duplicatedArtifacts.stream().map(duplicatedArtifact -> duplicatedArtifact.getArtifact().id).toList();
            for (String id : duplicatedArtifactIds) {
                this.archiveDSSArtifact(id);
            }
            logger.info((Object)("Duplicated artifacts found, applying " + String.valueOf((Object)ModificationType.DELETE) + "to: " + String.join((CharSequence)" ; ", duplicatedArtifactIds)));
        }
        return storedArtifacts;
    }

    private void generateLogOfSyncedObjects(@Nullable DSSProjectArtifactsContainer result, String postCountDescription) {
        if (result == null) {
            logger.info((Object)("No " + postCountDescription));
            return;
        }
        int projectsCount = result.getDSSProject() != null ? 1 : 0;
        int bundlesCount = result.getDSSBundles().size();
        int datasetsCount = result.getDSSDatasets().size();
        int savedModelsCount = result.getDSSSavedModels().size();
        int retrievableKnowledgesCount = result.getDSSRetrievableKnowledges().size();
        int savedModelVersionsCount = result.getDSSSavedModelVersions().size();
        int totalCount = projectsCount + bundlesCount + datasetsCount + savedModelsCount + retrievableKnowledgesCount + savedModelVersionsCount;
        logger.infoV("%s %s: %s project, %s bundles, %s datasets, %s saved models, %s retrievable knowledges, %s saved model versions.", new Object[]{totalCount, postCountDescription, projectsCount, bundlesCount, datasetsCount, savedModelsCount, retrievableKnowledgesCount, savedModelVersionsCount});
    }

    private void generateIdsLogOfModifiedObjects(Map<ModificationType, List<String>> modifiedObjectsFromUpsert, String blueprintName) {
        StringBuilder fullLogMessage = new StringBuilder(blueprintName);
        fullLogMessage.append(" sync, changes by ID: ");
        boolean noModificationYet = true;
        for (ModificationType modificationType : ModificationType.values()) {
            if (!modifiedObjectsFromUpsert.containsKey((Object)modificationType) || modifiedObjectsFromUpsert.get((Object)modificationType).isEmpty()) continue;
            fullLogMessage.append(System.lineSeparator());
            fullLogMessage.append(modificationType.toString());
            fullLogMessage.append(": ");
            fullLogMessage.append(String.join((CharSequence)" ; ", (Iterable<? extends CharSequence>)modifiedObjectsFromUpsert.get((Object)modificationType)));
            noModificationYet = false;
        }
        if (noModificationYet) {
            fullLogMessage.append("None");
        }
        logger.info((Object)fullLogMessage);
    }

    private DSSDeployerArtifactsContainer syncDSSDeployerItems(DSSDeployerItems dssDeployerItems, boolean withDeletion) throws IOException {
        DSSDeployerArtifactsContainer newArtifacts = this.dssObjectsToArtifactMapperService.mapDSSDeployerItemsToArtifacts(dssDeployerItems);
        this.generateLogOfSyncedDeployerObjects(newArtifacts, "elements sent to Sync from deployer");
        DSSDeployerArtifactsContainer existingArtifacts = this.dssIntegrationSearchArtifactsService.findDSSDeployerArtifacts(dssDeployerItems.nodeId);
        this.generateLogOfSyncedDeployerObjects(newArtifacts, "already existing deployer elements found in Govern");
        DSSArtifactsDiffSolverService.DiffResult<DSSDeployerArtifactsContainer> result = this.dssArtifactsDiffSolverService.diffOldAndNewDeployerArtifacts(existingArtifacts, newArtifacts);
        Map<String, Optional<String>> bundlesMap = this.getDeploymentsToBundleArtifactsIdsMap(dssDeployerItems.projectDeployments);
        Map<String, Set<String>> smvMap = this.getDeploymentsToSavedModelVersionArtifactIds(dssDeployerItems.apiDeployments);
        DSSDeployerArtifactsContainer storedArtifacts = new DSSDeployerArtifactsContainer();
        Map<ModificationType, List<String>> modifiedAPIInfrasFromUpsert = this.upsertDSSObjects(() -> ((DSSDeployerArtifactsContainer)result.artifactsToCreate).getAPIInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToUpdate).getAPIInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsUpToDate).getAPIInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToDelete).getAPIInfras().values(), storedArtifacts::getAPIInfras, this.doNothing(), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedAPIInfrasFromUpsert, "API Infras");
        Map<ModificationType, List<String>> modifiedProjectInfrasFromUpsert = this.upsertDSSObjects(() -> ((DSSDeployerArtifactsContainer)result.artifactsToCreate).getProjectInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToUpdate).getProjectInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsUpToDate).getProjectInfras().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToDelete).getProjectInfras().values(), storedArtifacts::getProjectInfras, this.doNothing(), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedProjectInfrasFromUpsert, "Project Infras");
        Map<ModificationType, List<String>> modifiedAPIDeploymentsFromUpsert = this.upsertDSSObjects(() -> ((DSSDeployerArtifactsContainer)result.artifactsToCreate).getAPIDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToUpdate).getAPIDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsUpToDate).getAPIDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToDelete).getAPIDeployments().values(), storedArtifacts::getAPIDeployments, this.linkAPIDeploymentToInfraAndSavedModelsVersions(storedArtifacts, smvMap), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedAPIDeploymentsFromUpsert, "API Deployments");
        Map<ModificationType, List<String>> modifiedProjectDeploymentsFromUpsert = this.upsertDSSObjects(() -> ((DSSDeployerArtifactsContainer)result.artifactsToCreate).getProjectDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToUpdate).getProjectDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsUpToDate).getProjectDeployments().values(), () -> ((DSSDeployerArtifactsContainer)result.artifactsToDelete).getProjectDeployments().values(), storedArtifacts::getProjectDeployments, this.linkProjectDeploymentToInfraAndBundle(storedArtifacts, bundlesMap), this::archiveDSSArtifact, withDeletion);
        this.generateIdsLogOfModifiedObjects(modifiedProjectDeploymentsFromUpsert, "Project Deployments");
        if (withDeletion && CollectionUtils.isNotEmpty(existingArtifacts.duplicatedArtifacts)) {
            List<String> duplicatedArtifactIds = existingArtifacts.duplicatedArtifacts.stream().map(duplicatedArtifact -> duplicatedArtifact.getArtifact().id).toList();
            for (String id : duplicatedArtifactIds) {
                this.archiveDSSArtifact(id);
            }
            logger.info((Object)("Duplicated artifacts found, applying " + String.valueOf((Object)ModificationType.DELETE) + "to: " + String.join((CharSequence)" ; ", duplicatedArtifactIds)));
        }
        return storedArtifacts;
    }

    private void generateLogOfSyncedDeployerObjects(@Nullable DSSDeployerArtifactsContainer result, String postCountDescription) {
        if (result == null) {
            logger.info((Object)("No " + postCountDescription));
            return;
        }
        int apiInfraCount = result.getAPIInfras().size();
        int projectsInfraCount = result.getProjectInfras().size();
        int apiDeploymentsCount = result.getAPIDeployments().size();
        int projectDeploymentsCount = result.getProjectDeployments().size();
        int totalCount = apiInfraCount + projectsInfraCount + apiDeploymentsCount + projectDeploymentsCount;
        logger.infoV("%s %s: %s API infras, %s project infras, %s API deployments, %s project deployments.", new Object[]{totalCount, postCountDescription, apiInfraCount, projectsInfraCount, apiDeploymentsCount, projectDeploymentsCount});
    }

    private <T extends DSSArtifactContainer<T>> Map<ModificationType, List<String>> upsertDSSObjects(Supplier<Collection<T>> toCreateSupplier, Supplier<Collection<T>> toUpdateSupplier, Supplier<Collection<T>> toUpToDateSupplier, Supplier<Collection<T>> toDeleteSupplier, Supplier<Map<String, T>> storedArtifactsSupplier, FunctionUtils.FunctionCanThrowsException<T, Boolean, IOException> addRelativeLinks, FunctionUtils.ConsumerCanThrowsException<String, IOException> archiveArtifact, boolean withDeletion) throws IOException {
        EnumMap<ModificationType, List<String>> actionToIds = new EnumMap<ModificationType, List<String>>(ModificationType.class);
        for (ModificationType modificationType : ModificationType.values()) {
            actionToIds.put(modificationType, new ArrayList());
        }
        for (DSSArtifactContainer toCreate : toCreateSupplier.get()) {
            addRelativeLinks.apply(toCreate);
            Object storedContainer = toCreate.cloneWith(this.systemArtifactService.createSystemArtifact((BlueprintVersionId)toCreate.artifact.blueprintVersionId, (Artifact)toCreate.artifact).artifact);
            ((DSSArtifactContainer)storedContainer).isCreation = true;
            storedArtifactsSupplier.get().put(((DSSArtifactContainer)storedContainer).getIdentifier(), storedContainer);
            ((List)actionToIds.get((Object)ModificationType.CREATE)).add(((DSSArtifactContainer)storedContainer).artifact.id);
        }
        for (DSSArtifactContainer toUpdate : toUpdateSupplier.get()) {
            addRelativeLinks.apply(toUpdate);
            Object storedContainer = toUpdate.cloneWith(this.systemArtifactService.updateSystemArtifact((Artifact)toUpdate.artifact).artifact);
            storedArtifactsSupplier.get().put(((DSSArtifactContainer)storedContainer).getIdentifier(), storedContainer);
            ((List)actionToIds.get((Object)ModificationType.UPDATE)).add(((DSSArtifactContainer)storedContainer).artifact.id);
        }
        for (DSSArtifactContainer upToDate : toUpToDateSupplier.get()) {
            boolean artifactModified = addRelativeLinks.apply(upToDate);
            if (artifactModified) {
                upToDate = upToDate.cloneWith(this.systemArtifactService.updateSystemArtifact((Artifact)upToDate.artifact).artifact);
            }
            storedArtifactsSupplier.get().put(upToDate.getIdentifier(), upToDate);
            ((List)actionToIds.get((Object)ModificationType.NO_CHANGES)).add(upToDate.artifact.id);
        }
        if (withDeletion) {
            for (DSSArtifactContainer toDelete : toDeleteSupplier.get()) {
                archiveArtifact.accept(toDelete.artifact.id);
                ((List)actionToIds.get((Object)ModificationType.DELETE)).add(toDelete.artifact.id);
            }
        }
        return actionToIds;
    }

    private String findProjectTemplateArtifactIdOrNull(DSSProject dssProject) throws IOException {
        List resultArtifactIds;
        if (StringUtils.isBlank((CharSequence)dssProject.templateProjectKey)) {
            return null;
        }
        List<ArtifactFilter> projectFilter = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(dssProject.dssProjectIdentifier.nodeId, Collections.singletonList(SystemProvidedConstants.DATAIKU_PROJECT), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_key", dssProject.templateProjectKey, false, false), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)}));
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), projectFilter, null, null);){
            resultArtifactIds = searchResults.map(enrichedArtifact -> enrichedArtifact.artifact.id).collect(Collectors.toList());
        }
        if (resultArtifactIds.isEmpty()) {
            logger.warn((Object)("Cannot find the artifact for the project template: " + dssProject.templateProjectKey));
            return null;
        }
        if (resultArtifactIds.size() > 1) {
            logger.warn((Object)("Found more than one artifact for the project template: " + dssProject.templateProjectKey));
        }
        return (String)resultArtifactIds.get(0);
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer<DSSArtifactContainer.DSSProjectArtifactContainer>, Boolean, IOException> linkProjectInstanceToProjectTemplate(String projectTemplateArtifactId) {
        return project -> this.setArtifactKeyIsModified(project.artifact, "project_application_template", StringUtils.isNotBlank((CharSequence)projectTemplateArtifactId) ? projectTemplateArtifactId : null);
    }

    private void upsertDSSProject(DSSArtifactsDiffSolverService.DiffResult<DSSProjectArtifactsContainer> result, DSSProjectArtifactsContainer storedArtifacts, FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer<DSSArtifactContainer.DSSProjectArtifactContainer>, Boolean, IOException> addRelativeLinks) throws IOException {
        if (((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSProject() != null) {
            addRelativeLinks.apply(((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSProject());
            EnrichedArtifact createdEnrichedArtifact = this.systemArtifactService.createSystemArtifact(((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSProject().artifact.blueprintVersionId, ((DSSProjectArtifactsContainer)result.artifactsToCreate).getDSSProject().artifact);
            storedArtifacts.setProject(createdEnrichedArtifact.artifact, true);
            logger.infoV("Created project with ID: %s", new Object[]{createdEnrichedArtifact.artifact.id});
        } else if (((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSProject() != null) {
            addRelativeLinks.apply(((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSProject());
            EnrichedArtifact updatedEnrichedArtifact = this.systemArtifactService.updateSystemArtifact(((DSSProjectArtifactsContainer)result.artifactsToUpdate).getDSSProject().artifact);
            storedArtifacts.setProject(updatedEnrichedArtifact.artifact, false);
            logger.infoV("Updated project with ID: %s", new Object[]{updatedEnrichedArtifact.artifact.id});
        } else if (((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSProject() != null) {
            if (addRelativeLinks.apply(((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSProject()).booleanValue()) {
                EnrichedArtifact updatedEnrichedArtifact = this.systemArtifactService.updateSystemArtifact(((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSProject().artifact);
                storedArtifacts.setProject(updatedEnrichedArtifact.artifact, false);
            } else {
                storedArtifacts.setProject(((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSProject());
            }
            logger.infoV("Project with ID: %s was already up to date", new Object[]{((DSSProjectArtifactsContainer)result.artifactsUpToDate).getDSSProject().artifact.id});
        }
    }

    private Map<String, Set<String>> getDeploymentsToSavedModelVersionArtifactIds(List<DSSAPIDeployerDeployment> apiDeployments) throws IOException {
        HashMap candidateSMVIdsForEachUniquePairOfNodeIdAndProjectKey = new HashMap();
        apiDeployments.forEach(deployment -> deployment.savedModelVersionIdentifiers.forEach(savedModelVersion -> candidateSMVIdsForEachUniquePairOfNodeIdAndProjectKey.computeIfAbsent(Pair.of((Object)savedModelVersion.nodeId, (Object)savedModelVersion.projectKey), key -> new ArrayList()).add(savedModelVersion.fullModelVersionId)));
        HashMap candidatesArtifactsForEachPair = new HashMap();
        for (Map.Entry uniqueProjectAndRelatedSMVs : candidateSMVIdsForEachUniquePairOfNodeIdAndProjectKey.entrySet()) {
            List<ArtifactFilter> smvFilter = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((String)((Pair)uniqueProjectAndRelatedSMVs.getKey()).getLeft(), Collections.singletonList(SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_key", (String)((Pair)uniqueProjectAndRelatedSMVs.getKey()).getRight(), false, false), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)}));
            Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), smvFilter, null, null);
            try {
                searchResults.filter(enrichedArtifact -> enrichedArtifact.artifact.fields.get("full_model_version_id") instanceof String).filter(enrichedArtifact -> ((List)uniqueProjectAndRelatedSMVs.getValue()).contains((String)enrichedArtifact.artifact.fields.get("full_model_version_id"))).forEach(enrichedArtifact -> candidatesArtifactsForEachPair.computeIfAbsent((Pair)uniqueProjectAndRelatedSMVs.getKey(), key -> new ArrayList()).add(Pair.of((Object)enrichedArtifact.artifact.id, (Object)((String)enrichedArtifact.artifact.fields.get("full_model_version_id")))));
            }
            finally {
                if (searchResults == null) continue;
                searchResults.close();
            }
        }
        HashMap<String, Set<String>> deploymentsMapToModelVersionArtifacts = new HashMap<String, Set<String>>();
        for (DSSAPIDeployerDeployment apiDeployment : apiDeployments) {
            for (DSSSavedModelVersionIdentifier savedModelVersionIdentifier : apiDeployment.savedModelVersionIdentifiers) {
                List candidateSavedModelVersions = (List)candidatesArtifactsForEachPair.get(Pair.of((Object)savedModelVersionIdentifier.nodeId, (Object)savedModelVersionIdentifier.projectKey));
                if (candidateSavedModelVersions == null) {
                    logger.warnV("Cannot find the associated dataiku saved model version for deployment: %s of saved model: %s", new Object[]{apiDeployment, savedModelVersionIdentifier});
                    continue;
                }
                Set savedModelVersionIds = candidateSavedModelVersions.stream().filter(modelVersion -> Objects.equals(modelVersion.getRight(), savedModelVersionIdentifier.fullModelVersionId)).map(Pair::getLeft).collect(Collectors.toSet());
                Iterator iterator = savedModelVersionIds.iterator();
                if (!iterator.hasNext()) {
                    logger.warnV("Cannot find the associated dataiku saved model version for deployment: %s of saved model: %s", new Object[]{apiDeployment, savedModelVersionIdentifier});
                    continue;
                }
                String artifactId = (String)iterator.next();
                if (iterator.hasNext()) {
                    logger.warnV("Found more than one associated dataiku saved model version for deployment: %s of saved model: %s", new Object[]{apiDeployment, savedModelVersionIdentifier});
                }
                deploymentsMapToModelVersionArtifacts.computeIfAbsent(apiDeployment.dssAPIDeployerDeploymentIdentifier.deploymentId, key -> new HashSet()).add(artifactId);
            }
        }
        return deploymentsMapToModelVersionArtifacts;
    }

    private Map<String, Optional<String>> getDeploymentsToBundleArtifactsIdsMap(List<DSSProjectDeployerDeployment> projectDeployments) throws IOException {
        HashMap candidateBundleIdsForEachUniquePairOfNodeIdAndProjectKey = new HashMap();
        projectDeployments.forEach(deployment -> {
            if (deployment.bundleIdentifier != null) {
                candidateBundleIdsForEachUniquePairOfNodeIdAndProjectKey.computeIfAbsent(ImmutablePair.of((Object)deployment.bundleIdentifier.nodeId, (Object)deployment.bundleIdentifier.projectKey), key -> new ArrayList()).add(deployment.bundleIdentifier.bundleId);
            }
        });
        HashMap candidatesArtifactsForEachPair = new HashMap();
        for (Map.Entry uniqueProjectAndRelatedBundles : candidateBundleIdsForEachUniquePairOfNodeIdAndProjectKey.entrySet()) {
            List<ArtifactFilter> bundlesFilter = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((String)((Pair)uniqueProjectAndRelatedBundles.getKey()).getLeft(), Collections.singletonList(SystemProvidedConstants.DATAIKU_BUNDLE), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_key", (String)((Pair)uniqueProjectAndRelatedBundles.getKey()).getRight(), false, false), ArtifactFilter.ArchivedStatusArtifactFilter.build(false)}));
            Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), bundlesFilter, null, null);
            try {
                searchResults.filter(enrichedArtifact -> enrichedArtifact.artifact.fields.get("bundle_id") instanceof String).filter(enrichedArtifact -> ((List)uniqueProjectAndRelatedBundles.getValue()).contains((String)enrichedArtifact.artifact.fields.get("bundle_id"))).forEach(enrichedArtifact -> candidatesArtifactsForEachPair.computeIfAbsent((Pair)uniqueProjectAndRelatedBundles.getKey(), key -> new ArrayList()).add(Pair.of((Object)enrichedArtifact.artifact.id, (Object)((String)enrichedArtifact.artifact.fields.get("bundle_id")))));
            }
            finally {
                if (searchResults == null) continue;
                searchResults.close();
            }
        }
        HashMap<String, Optional<String>> deploymentsMapToArtifactBundles = new HashMap<String, Optional<String>>();
        for (DSSProjectDeployerDeployment projectDeployment : projectDeployments) {
            if (projectDeployment.bundleIdentifier == null) {
                logger.warnV("Cannot find the associated dataiku bundle because of missing information for deployment: %s", new Object[]{projectDeployment});
                deploymentsMapToArtifactBundles.put(projectDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId, Optional.empty());
                continue;
            }
            List candidateBundles = (List)candidatesArtifactsForEachPair.get(Pair.of((Object)projectDeployment.bundleIdentifier.nodeId, (Object)projectDeployment.bundleIdentifier.projectKey));
            if (candidateBundles == null) {
                logger.warnV("Cannot find the associated dataiku bundle for deployment: %s", new Object[]{projectDeployment});
                deploymentsMapToArtifactBundles.put(projectDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId, Optional.empty());
                continue;
            }
            Set artifactIds = candidateBundles.stream().filter(bundle -> Objects.equals(bundle.getRight(), projectDeployment.bundleIdentifier.bundleId)).map(Pair::getLeft).collect(Collectors.toSet());
            Iterator iterator = artifactIds.iterator();
            if (!iterator.hasNext()) {
                logger.warnV("Cannot find the associated dataiku bundle for deployment: %s", new Object[]{projectDeployment});
                deploymentsMapToArtifactBundles.put(projectDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId, Optional.empty());
                continue;
            }
            String artifactId = (String)iterator.next();
            if (iterator.hasNext()) {
                logger.warnV("Found more than one associated dataiku bundle for deployment: %s", new Object[]{projectDeployment});
            }
            deploymentsMapToArtifactBundles.put(projectDeployment.dssProjectDeployerDeploymentIdentifier.deploymentId, Optional.of(artifactId));
        }
        return deploymentsMapToArtifactBundles;
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSBundleArtifactContainer, Boolean, IOException> linkBundleToParent(DSSProjectArtifactsContainer storedArtifacts) {
        return bundle -> this.setArtifactKeyIsModified(bundle.artifact, "dataiku_project", storedArtifacts.getDSSProject().artifact.id);
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSDatasetArtifactContainer, Boolean, IOException> linkDatasetToParent(DSSProjectArtifactsContainer storedArtifacts) {
        return dataset -> this.setArtifactKeyIsModified(dataset.artifact, "dataiku_project", storedArtifacts.getDSSProject().artifact.id);
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSSavedModelArtifactContainer, Boolean, IOException> linkSavedModelToParent(DSSProjectArtifactsContainer storedArtifacts) {
        return savedModel -> this.setArtifactKeyIsModified(savedModel.artifact, "dataiku_project", storedArtifacts.getDSSProject().artifact.id);
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer, Boolean, IOException> linkRetrievableKnowledgeToParent(DSSProjectArtifactsContainer storedArtifacts) {
        return retrievableKnowledge -> this.setArtifactKeyIsModified(retrievableKnowledge.artifact, "dataiku_project", storedArtifacts.getDSSProject().artifact.id);
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer, Boolean, IOException> linkSavedModelVersionToParentAndFillTimeSeries(DSSProjectArtifactsContainer storedArtifacts, boolean withDeletion) {
        return savedModelVersion -> {
            boolean parentModified = this.linkSavedModelVersionToParent(storedArtifacts, savedModelVersion.artifact);
            boolean tsUpdated = false;
            if (savedModelVersion.isTimeseriesEnabled()) {
                tsUpdated = this.syncTimeseries((DSSArtifactContainer.DSSSavedModelVersionArtifactContainer)savedModelVersion, withDeletion);
                tsUpdated |= this.syncCustomMetricsTimesSeries((DSSArtifactContainer.DSSSavedModelVersionArtifactContainer)savedModelVersion, withDeletion);
            }
            return parentModified || tsUpdated;
        };
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSProjectDeployerDeploymentArtifactContainer, Boolean, IOException> linkProjectDeploymentToInfraAndBundle(DSSDeployerArtifactsContainer storedArtifacts, Map<String, Optional<String>> bundleMap) {
        return deployment -> {
            String searchedInfra = (String)deployment.artifact.fields.get("infrastructure_id");
            Artifact infra = Optional.ofNullable(storedArtifacts.getProjectInfras().get(searchedInfra)).map(DSSArtifactContainer::getArtifact).orElseThrow(() -> new ValidationException("Can't find associated infra " + searchedInfra));
            boolean infraModified = this.setArtifactKeyIsModified(deployment.artifact, "infrastructure", infra.id);
            if (((Optional)bundleMap.get((String)deployment.artifact.fields.get("deployment_id"))).isPresent()) {
                boolean bundleModified = this.setArtifactKeyIsModified(deployment.artifact, "dataiku_bundle", (String)((Optional)bundleMap.get((String)deployment.artifact.fields.get("deployment_id"))).get());
                return bundleModified || infraModified;
            }
            return infraModified;
        };
    }

    private FunctionUtils.FunctionCanThrowsException<DSSArtifactContainer.DSSAPIDeployerDeploymentArtifactContainer, Boolean, IOException> linkAPIDeploymentToInfraAndSavedModelsVersions(DSSDeployerArtifactsContainer storedArtifacts, Map<String, Set<String>> smvMap) {
        return deployment -> {
            String searchedInfra = (String)deployment.artifact.fields.get("infrastructure_id");
            Artifact infra = Optional.ofNullable(storedArtifacts.getAPIInfras().get(searchedInfra)).map(DSSArtifactContainer::getArtifact).orElseThrow(() -> new ValidationException("Can't find associated infra " + searchedInfra));
            boolean infraModified = this.setArtifactKeyIsModified(deployment.artifact, "infrastructure", infra.id);
            if (smvMap.get((String)deployment.artifact.fields.get("deployment_id")) != null) {
                boolean bundleModified = this.setArtifactUnsortedListIsModified(deployment.artifact, "dataiku_saved_model_versions", (Set)smvMap.get((String)deployment.artifact.fields.get("deployment_id")));
                return bundleModified || infraModified;
            }
            return infraModified;
        };
    }

    private <T extends DSSArtifactContainer<T>> FunctionUtils.FunctionCanThrowsException<T, Boolean, IOException> doNothing() {
        return deployment -> false;
    }

    private boolean linkSavedModelVersionToParent(DSSProjectArtifactsContainer storedArtifacts, Artifact savedModelVersion) {
        String searchedSavedModelId = (String)savedModelVersion.fields.get("saved_model_id");
        Artifact parent = Optional.ofNullable(storedArtifacts.getDSSSavedModels().get(searchedSavedModelId)).map(DSSArtifactContainer::getArtifact).orElseThrow(() -> new ValidationException("Can't find saved model parent for saved_model_version " + searchedSavedModelId));
        return this.setArtifactKeyIsModified(savedModelVersion, "dataiku_saved_model", parent.id);
    }

    private boolean setArtifactKeyIsModified(Artifact artifact, String key, String value) {
        Object oldValue = artifact.fields.put(key, value);
        return !Objects.equals(oldValue, value);
    }

    private boolean setArtifactUnsortedListIsModified(Artifact artifact, String key, Set<String> newValue) {
        boolean modified;
        List oldValue = (List)artifact.fields.getOrDefault(key, Lists.newArrayList());
        boolean bl = modified = oldValue.size() != newValue.size();
        if (!modified) {
            modified = !SetUtils.isEqualSet((Collection)Sets.newHashSet((Iterable)oldValue), newValue);
        }
        artifact.fields.put(key, Lists.newArrayList(newValue));
        return modified;
    }

    private void archiveArtifacts(DSSProjectArtifactsContainer artifactsToArchive) throws IOException {
        if (artifactsToArchive.getDSSProject() != null && artifactsToArchive.getDSSProject().artifact != null) {
            this.archiveDSSArtifact(artifactsToArchive.getDSSProject().artifact.id);
            logger.infoV("Deleted project with ID: %s", new Object[]{artifactsToArchive.getDSSProject().artifact.id});
        }
        if (!artifactsToArchive.getDSSBundles().values().isEmpty()) {
            this.archiveProjectChildrenArtifact("Archiving bundles", artifactsToArchive.getDSSBundles().values().stream().map(artifact -> artifact.artifact.id).toList());
        }
        if (!artifactsToArchive.getDSSDatasets().values().isEmpty()) {
            this.archiveProjectChildrenArtifact("Archiving datasets", artifactsToArchive.getDSSDatasets().values().stream().map(artifact -> artifact.artifact.id).toList());
        }
        if (!artifactsToArchive.getDSSSavedModels().values().isEmpty()) {
            this.archiveProjectChildrenArtifact("Archiving saved models", artifactsToArchive.getDSSSavedModels().values().stream().map(artifact -> artifact.artifact.id).toList());
        }
        if (!artifactsToArchive.getDSSSavedModelVersions().values().isEmpty()) {
            this.archiveProjectChildrenArtifact("Archiving saved model versions", artifactsToArchive.getDSSSavedModelVersions().values().stream().map(artifact -> artifact.artifact.id).toList());
        }
        if (!artifactsToArchive.getDSSRetrievableKnowledges().values().isEmpty()) {
            this.archiveProjectChildrenArtifact("Archiving retrievable knowledges", artifactsToArchive.getDSSRetrievableKnowledges().values().stream().map(artifact -> artifact.artifact.id).toList());
        }
    }

    private void archiveProjectChildrenArtifact(String bpName, List<String> artifactIds) throws IOException {
        HashMap<ModificationType, List<String>> deletedElements = new HashMap<ModificationType, List<String>>();
        deletedElements.put(ModificationType.DELETE, new ArrayList());
        for (String id : artifactIds) {
            this.archiveDSSArtifact(id);
            ((List)deletedElements.get((Object)ModificationType.DELETE)).add(id);
        }
        this.generateIdsLogOfModifiedObjects(deletedElements, bpName);
    }

    private void archiveDSSArtifact(String id) throws IOException {
        String[] governedBy = new String[]{null};
        this.systemArtifactService.updateSystemArtifact(id, ea -> {
            governedBy[0] = (String)ea.artifact.fields.remove("governed_by");
            this.archiveArtifactsAndRemoveReferenceFields((EnrichedArtifact)ea);
        });
        if (StringUtils.isNotBlank((CharSequence)governedBy[0])) {
            this.dssIntegrationService.archiveGovernArtifact(governedBy[0]);
        }
    }

    private void archiveArtifactsAndRemoveReferenceFields(EnrichedArtifact enrichedArtifact) {
        enrichedArtifact.artifact.status.archived = true;
        enrichedArtifact.blueprintVersion.fieldDefinitions.entrySet().stream().filter(es -> ((FieldDefinition)es.getValue()).fieldType == FieldType.REFERENCE).map(Map.Entry::getKey).forEach(key -> enrichedArtifact.artifact.fields.remove(key));
    }

    private List<DSSProjectIdentifierWithId> findAllProjectsProjectKeyAndId(String nodeId) throws IOException {
        List<ArtifactFilter> filters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(nodeId, Collections.singletonList(SystemProvidedConstants.DATAIKU_PROJECT));
        try (Stream<EnrichedArtifact> searchResults = this.artifactsDataService.searchArtifactsStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), filters, null, null);){
            List<DSSProjectIdentifierWithId> list = searchResults.map(enrichedArtifact -> new DSSProjectIdentifierWithId(DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(enrichedArtifact.artifact), enrichedArtifact.artifact.id)).collect(Collectors.toList());
            return list;
        }
    }

    private boolean syncTimeseries(DSSArtifactContainer.DSSSavedModelVersionArtifactContainer artifactContainer, boolean withDeletion) throws IOException {
        boolean artifactChanged = false;
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(artifactContainer.artifact.blueprintVersionId);
        Set metricsIds = enrichedBlueprintVersion.blueprintVersion.fieldDefinitions.entrySet().stream().filter(es -> ((FieldDefinition)es.getValue()).fieldType == FieldType.TIME_SERIES).filter(es -> !Objects.equals(es.getKey(), "custom_metric_evaluation_values")).map(Map.Entry::getKey).collect(Collectors.toSet());
        artifactContainer.metricPointsList.stream().filter(p -> !p.isCustom).map(p -> p.metricId).filter(metricId -> !metricsIds.contains(metricId)).forEach(metricId -> logger.error((Object)("Drift metric error: field ID " + metricId + " does not exist in BlueprintVersion " + String.valueOf(artifactContainer.artifact.blueprintVersionId) + " or its type is not TIMESERIES")));
        HashSet allDatapoints = Sets.newHashSet();
        for (String metricId2 : metricsIds) {
            List datapoints;
            String timeseriesId = (String)artifactContainer.artifact.fields.get(metricId2);
            if (StringUtils.isNotBlank((CharSequence)timeseriesId) && withDeletion) {
                this.timeSeriesDataService.delete(timeseriesId, null, null);
            }
            if (!CollectionUtils.isNotEmpty(datapoints = artifactContainer.metricPointsList.stream().filter(mpl -> !mpl.isCustom && StringUtils.equals((CharSequence)mpl.metricId, (CharSequence)metricId2)).flatMap(mpl -> mpl.datapoints.stream()).collect(Collectors.toList()))) continue;
            if (StringUtils.isBlank((CharSequence)timeseriesId)) {
                timeseriesId = this.timeSeriesDataService.create(GovernActionContext.getAuthCtxIdentifier(), Sets.newHashSet());
                artifactContainer.artifact.fields.put(metricId2, timeseriesId);
                artifactChanged = true;
            }
            String finalTimeseriesId = timeseriesId;
            Set timeseriesDatapoints = datapoints.stream().map(datapoint -> {
                TimeSeriesDatapoint timeseriesDatapoint = new TimeSeriesDatapoint();
                timeseriesDatapoint.timeSeriesId = finalTimeseriesId;
                timeseriesDatapoint.timestamp = datapoint.timestamp;
                timeseriesDatapoint.value = datapoint.value;
                return timeseriesDatapoint;
            }).collect(Collectors.toSet());
            allDatapoints.addAll(timeseriesDatapoints);
        }
        if (CollectionUtils.isNotEmpty((Collection)allDatapoints)) {
            this.timeSeriesDataService.push(allDatapoints, true);
        }
        return artifactChanged;
    }

    private boolean syncCustomMetricsTimesSeries(DSSArtifactContainer.DSSSavedModelVersionArtifactContainer artifactContainer, boolean withDeletion) throws IOException {
        int i;
        boolean artifactChanged = false;
        List<String> customMetricNames = DSSIntegrationSyncService.getFieldAsListOfStringDefaultEmpty(artifactContainer.artifact.fields.get("custom_metric_names"));
        List<String> timesSeriesIds = DSSIntegrationSyncService.getFieldAsListOfStringDefaultEmpty(artifactContainer.artifact.fields.get("custom_metric_evaluation_values"));
        HashSet<String> createdTimeSeriesIds = new HashSet<String>();
        for (i = 0; i < customMetricNames.size(); ++i) {
            String timeSeriesId;
            String customMetricName = customMetricNames.get(i);
            String string = timeSeriesId = i < timesSeriesIds.size() ? timesSeriesIds.get(i) : null;
            if (!StringUtils.isNotBlank((CharSequence)customMetricName) || !StringUtils.isBlank((CharSequence)timeSeriesId)) continue;
            String newTimeSeriesId = this.timeSeriesDataService.create(GovernActionContext.getAuthCtxIdentifier(), Sets.newHashSet());
            createdTimeSeriesIds.add(newTimeSeriesId);
            if (i < timesSeriesIds.size()) {
                timesSeriesIds.set(i, newTimeSeriesId);
            } else {
                timesSeriesIds.add(newTimeSeriesId);
            }
            artifactChanged = true;
        }
        if (withDeletion && customMetricNames.size() < timesSeriesIds.size()) {
            for (i = customMetricNames.size(); i < timesSeriesIds.size(); ++i) {
                String timeSeriesId = timesSeriesIds.get(i);
                if (!StringUtils.isNotBlank((CharSequence)timeSeriesId)) continue;
                this.timeSeriesDataService.delete(timeSeriesId, null, null);
            }
            while (customMetricNames.size() < timesSeriesIds.size()) {
                timesSeriesIds.remove(customMetricNames.size());
                artifactChanged = true;
            }
        }
        artifactContainer.artifact.fields.put("custom_metric_evaluation_values", timesSeriesIds);
        HashSet allDatapoints = Sets.newHashSet();
        for (int i2 = 0; i2 < customMetricNames.size(); ++i2) {
            List customMetricDatapoints;
            String timeSeriesId;
            String customMetricName = customMetricNames.get(i2);
            String string = timeSeriesId = i2 < timesSeriesIds.size() ? timesSeriesIds.get(i2) : null;
            if (withDeletion && StringUtils.isNotBlank((CharSequence)timeSeriesId) && !createdTimeSeriesIds.contains(timeSeriesId)) {
                this.timeSeriesDataService.delete(timeSeriesId, null, null);
            }
            if (!StringUtils.isNotBlank((CharSequence)customMetricName) || !StringUtils.isNotBlank((CharSequence)timeSeriesId) || !CollectionUtils.isNotEmpty(customMetricDatapoints = artifactContainer.metricPointsList.stream().filter(mpl -> mpl.isCustom && StringUtils.equals((CharSequence)mpl.metricId, (CharSequence)customMetricName)).flatMap(mpl -> mpl.datapoints.stream()).collect(Collectors.toList()))) continue;
            Set timeseriesDatapoints = customMetricDatapoints.stream().map(datapoint -> {
                TimeSeriesDatapoint timeseriesDatapoint = new TimeSeriesDatapoint();
                timeseriesDatapoint.timeSeriesId = timeSeriesId;
                timeseriesDatapoint.timestamp = datapoint.timestamp;
                timeseriesDatapoint.value = datapoint.value;
                return timeseriesDatapoint;
            }).collect(Collectors.toSet());
            allDatapoints.addAll(timeseriesDatapoints);
        }
        if (CollectionUtils.isNotEmpty((Collection)allDatapoints)) {
            this.timeSeriesDataService.push(allDatapoints, true);
        }
        return artifactChanged;
    }

    private static List<String> getFieldAsListOfStringDefaultEmpty(Object fieldValue) {
        if (!(fieldValue instanceof List)) {
            return Lists.newArrayList();
        }
        return ((List)fieldValue).stream().map(v -> v instanceof String ? (String)v : null).collect(Collectors.toList());
    }

    private static List<String> containerToGovernableArtifactIds(DSSProjectArtifactsContainer dssProjectArtifactsContainer) {
        ArrayList<String> artifactIds = new ArrayList<String>();
        if (dssProjectArtifactsContainer.getDSSProject() != null && dssProjectArtifactsContainer.getDSSProject().artifact != null) {
            artifactIds.add(dssProjectArtifactsContainer.getDSSProject().artifact.id);
        }
        dssProjectArtifactsContainer.getDSSBundles().values().forEach(item -> artifactIds.add(item.artifact.id));
        dssProjectArtifactsContainer.getDSSSavedModels().values().forEach(item -> artifactIds.add(item.artifact.id));
        dssProjectArtifactsContainer.getDSSSavedModelVersions().values().forEach(item -> artifactIds.add(item.artifact.id));
        return artifactIds;
    }

    private static enum ModificationType {
        CREATE,
        UPDATE,
        NO_CHANGES,
        DELETE;

    }
}

