/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.permissions;

import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IBlueprintPermissionsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.storage.roles.permissions.IBlueprintPermissionsDAO;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintPermissionsDataService
implements IBlueprintPermissionsDataService {
    @Autowired
    private IBlueprintPermissionsDAO blueprintPermissionsDAO;
    @Autowired
    private IRoleDAO roleDAO;
    @Autowired
    private IBlueprintDAO blueprintDAO;

    @Override
    @GHMandatoryTransaction
    public BlueprintPermissions getBlueprintPermissions(String blueprintId) throws IOException {
        return (BlueprintPermissions)this.blueprintPermissionsDAO.getMandatory(blueprintId);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintPermissions getBlueprintPermissionsOrNull(String blueprintId) throws IOException {
        return (BlueprintPermissions)this.blueprintPermissionsDAO.getOrNull(blueprintId);
    }

    @Override
    @GHMandatoryTransaction
    public List<BlueprintPermissions> listBlueprintPermissions() throws IOException {
        return this.blueprintPermissionsDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintPermissions createBlueprintPermissions(BlueprintPermissions blueprintPermissions) throws IOException {
        return this.validateAndSave(blueprintPermissions, true);
    }

    @Override
    @GHMandatoryTransaction
    public BlueprintPermissions saveBlueprintPermissions(BlueprintPermissions blueprintPermissions) throws IOException {
        return this.validateAndSave(blueprintPermissions, false);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteBlueprintPermissions(String blueprintId) throws IOException {
        if (!this.blueprintPermissionsDAO.exists(blueprintId)) {
            throw new ValidationException("Blueprint permissions for blueprint ID: " + blueprintId + " doesn't exist");
        }
        BlueprintPermissions blueprintPermissions = (BlueprintPermissions)this.blueprintPermissionsDAO.getMandatory(blueprintId);
        this.blueprintPermissionsDAO.lock(blueprintPermissions.blueprintId);
        this.blueprintDAO.lock(blueprintPermissions.blueprintId);
        for (String roleId : blueprintPermissions.rolePermissions.keySet()) {
            this.roleDAO.lock(roleId);
        }
        this.blueprintPermissionsDAO.delete(blueprintId);
    }

    private BlueprintPermissions validateAndSave(BlueprintPermissions blueprintPermissions, boolean creation) throws IOException {
        if (creation == this.blueprintPermissionsDAO.exists(blueprintPermissions.blueprintId)) {
            throw new ValidationException("Blueprint permission for blueprint ID: " + blueprintPermissions.blueprintId + (creation ? " already exists" : " doesn't exist"));
        }
        this.blueprintPermissionsDAO.lock(blueprintPermissions.blueprintId);
        this.blueprintDAO.lock(blueprintPermissions.blueprintId);
        for (String roleId : blueprintPermissions.rolePermissions.keySet()) {
            this.roleDAO.lock(roleId);
        }
        if (creation) {
            this.blueprintPermissionsDAO.create(blueprintPermissions);
        } else {
            this.blueprintPermissionsDAO.save(blueprintPermissions);
        }
        return (BlueprintPermissions)this.blueprintPermissionsDAO.getMandatory(blueprintPermissions.blueprintId);
    }
}

