/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.search;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.storage.search.IArtifactAtTimestampSearchDAO;
import com.dataiku.gh.core.storage.sql.history.EnrichedArtifactWithoutPermissionsAtTimestampRowMapper;
import com.dataiku.gh.core.storage.sql.model.QArtifactsAtTimestamp;
import com.dataiku.gh.core.storage.sql.search.AbstractArtifactSearchDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class ArtifactAtTimestampSearchDAO
extends AbstractArtifactSearchDAO
implements IArtifactAtTimestampSearchDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-search-timestamp");

    @Override
    protected RelationalPathBase<?> getRelationalPathBase() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp;
    }

    protected StringPath getArtifactIdPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.artifactId;
    }

    @Override
    protected StringExpression getArtifactBlueprintIdPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.artifactBlueprintId;
    }

    @Override
    protected StringExpression getArtifactVersionIdPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.artifactVersionId;
    }

    @Override
    protected Expression<Object> getArtifactJsonWithoutRelationshipsPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.artifactJsonWithoutRelationships;
    }

    @Override
    protected Expression<Object> getArtifactJsonWithRelationshipsPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.artifactJsonWithRelationships;
    }

    @Override
    protected Expression<Object> getBlueprintVersionJsonPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.blueprintVersionJson;
    }

    @Override
    protected Expression<Object> getSignoffsPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.signoffs;
    }

    protected StringPath getUserMappingUserLoginPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.userMappingUserLogin;
    }

    protected StringPath getGroupMappingGroupNamePath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.groupMappingGroupName;
    }

    protected StringPath getGlobalApiKeyMappingApiKeyIdPath() {
        return QArtifactsAtTimestamp.artifactsAtTimestamp.globalApiKeyMappingApiKeyId;
    }

    @Override
    protected Expression<?> getFromExpressionClause(@Nullable Long timestamp) {
        if (timestamp == null) {
            throw ErrorContext.iae((String)"Cannot query history without a timestamp");
        }
        return QArtifactsAtTimestamp.asFunctionExpression(timestamp, null);
    }

    @Override
    public List<EnrichedArtifactWithoutPermissions> listAtTimestamp(long timestamp, List<String> artifactIds) throws IOException {
        EnrichedArtifactWithoutPermissionsAtTimestampRowMapper rowMapper = new EnrichedArtifactWithoutPermissionsAtTimestampRowMapper();
        SQLQuery sqlQuery = (SQLQuery)this.sqlQueryFactory.select(rowMapper.columns).from(QArtifactsAtTimestamp.asFunctionExpression(timestamp, artifactIds));
        try {
            return this.querydslJdbcTemplate.query(sqlQuery, rowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

