/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.pipelines.uncertainty.Interval;
import java.util.Optional;

public class RegressionResult
extends Result<Double> {
    @Nullable
    public final Interval interval;

    public boolean hasPredictionIntervals() {
        return this.interval != null;
    }

    public RegressionResult withNewPrediction(Double newPrediction) {
        return new RegressionResult(newPrediction, this.interval);
    }

    public Optional<Interval> getPredictionInterval() {
        return Optional.ofNullable(this.interval);
    }

    public static RegressionResult declined() {
        return new RegressionResult(null, null);
    }

    public RegressionResult(Double prediction) {
        this(prediction, null);
    }

    public RegressionResult(Double prediction, @Nullable Interval interval) {
        super(prediction);
        this.interval = interval;
    }

    public static class RawResult
    extends Result.RawResult {
        @Nullable
        private final Double predictionIntervalLower;
        @Nullable
        private final Double predictionIntervalUpper;

        public RawResult(RegressionResult result) {
            super(result);
            this.predictionIntervalLower = result.getPredictionInterval().map(i -> i.lower).orElse(null);
            this.predictionIntervalUpper = result.getPredictionInterval().map(i -> i.upper).orElse(null);
        }
    }
}

