/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.spark.HDFSDatasetRDD$;
import com.dataiku.dip.spark.NativeFormatWriter;
import com.dataiku.dip.spark.package$;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ParquetWriter$
extends NativeFormatWriter {
    public static ParquetWriter$ MODULE$;
    private final Logger logger;

    static {
        new ParquetWriter$();
    }

    public Map<String, String> prepareSaveParquetDataset(DatasetHandler handler, org.apache.spark.sql.Dataset<Row> df) {
        block10: {
            String string;
            Dataset dataset = handler.getDataset();
            ParquetFormatConfig parquetFormatConfig = (ParquetFormatConfig)dataset.getFormatParamsAs(ParquetFormatConfig.class);
            ParquetFormatConfig.CompressionMethod compressionMethod = parquetFormatConfig.parquetCompressionMethod;
            if (ParquetFormatConfig.CompressionMethod.UNCOMPRESSED.equals(compressionMethod)) {
                string = "uncompressed";
            } else if (ParquetFormatConfig.CompressionMethod.SNAPPY.equals(compressionMethod)) {
                string = "snappy";
            } else if (ParquetFormatConfig.CompressionMethod.GZIP.equals(compressionMethod)) {
                string = "gzip";
            } else if (ParquetFormatConfig.CompressionMethod.LZO.equals(compressionMethod)) {
                string = "lzo";
            } else if (ParquetFormatConfig.CompressionMethod.ZSTD.equals(compressionMethod)) {
                string = "zstd";
            } else {
                throw new MatchError((Object)compressionMethod);
            }
            String codec = string;
            df.sqlContext().setConf("spark.sql.parquet.compression.codec", codec);
            long blockSize = (long)parquetFormatConfig.parquetBlockSizeMB * 1024L * 1024L;
            df.sqlContext().sparkContext().hadoopConfiguration().setLong("parquet.block.size", blockSize);
            if (!(handler instanceof HDFSableDatasetHandler)) break block10;
            HDFSableDatasetHandler hdfsable = (HDFSableDatasetHandler)handler;
            hdfsable.addExtraConf(df.sqlContext().sparkContext().hadoopConfiguration(), true);
            hdfsable.addExtraConf(package$.MODULE$.getSparkHadoopUtilConf(), true);
        }
        return Predef$.MODULE$.Map().empty();
    }

    public void saveParquetDataset(HDFSableDatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, String partition, Enumeration.Value writeMode, String apiTicket) {
        Dataset dataset = handler.getDataset();
        Partition dssPartition = partition != null ? PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition) : null;
        SaveMode saveMode = HDFSDatasetRDD$.MODULE$.clearDataset(dataset, dssPartition, writeMode, apiTicket);
        String path = partition != null ? handler.getFullyQualifiedPartitionPath(dssPartition) : handler.getFullyQualifiedRootPath();
        Map<String, String> options = this.prepareSaveParquetDataset((DatasetHandler)handler, df);
        org.apache.spark.sql.Dataset<Row> dssDataframe = this.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        this.logger().info((Object)new StringBuilder(31).append("Saving dataframe as parquet to ").append(path).toString());
        DataFrameWriter dfwWriter = dssDataframe.write().mode(saveMode);
        dfwWriter.options(options);
        dfwWriter.parquet(path);
    }

    public org.apache.spark.sql.Dataset<Row> adaptDataFrame(org.apache.spark.sql.Dataset<Row> df, Schema dssSchema, boolean isManaged) {
        ObjectRef dssDataframe = ObjectRef.create(df);
        df.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            dssDataframe.elem = ParquetWriter$.MODULE$.adaptDataFrameColumn((org.apache.spark.sql.Dataset<Row>)((org.apache.spark.sql.Dataset)dssDataframe.elem), field, dssSchema, isManaged);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)dssDataframe.elem;
    }

    private Logger logger() {
        return this.logger;
    }

    private ParquetWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.parquet");
    }
}

