/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.compat;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.spark.CsvWriter$;
import com.dataiku.dip.spark.HadoopFormatsSupport$;
import com.dataiku.dip.spark.JsonWriter$;
import com.dataiku.dip.spark.ORCWriter$;
import com.dataiku.dip.spark.ParquetWriter$;
import com.dataiku.dip.spark.StdDataikuSparkContext$;
import com.dataiku.dip.spark.StorageBackendsSupport$;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class StructuredStreamingDatasetWriter$ {
    public static StructuredStreamingDatasetWriter$ MODULE$;
    private final Logger logger;

    static {
        new StructuredStreamingDatasetWriter$();
    }

    public org.apache.spark.sql.Dataset<Row> addTimePartitionFormattedColumn(org.apache.spark.sql.Dataset<Row> df, Dataset dataset) {
        ObjectRef partitionedDF = ObjectRef.create(df);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dataset.getPartitioningSchema().getDimensionNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)dn -> {
            StructuredStreamingDatasetWriter$.$anonfun$addTimePartitionFormattedColumn$1(dataset, partitionedDF, df, dn);
            return BoxedUnit.UNIT;
        });
        return (org.apache.spark.sql.Dataset)partitionedDF.elem;
    }

    public org.apache.spark.sql.Dataset<Row> adaptForFormat(org.apache.spark.sql.Dataset<Row> df, Dataset dataset) {
        String formatType = dataset.getFormatType();
        String string = formatType;
        if ("parquet".equals(string)) {
            return ParquetWriter$.MODULE$.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        }
        if ("orcfile".equals(string)) {
            return ORCWriter$.MODULE$.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        }
        if ("json".equals(string)) {
            return JsonWriter$.MODULE$.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged());
        }
        if ("csv".equals(string)) {
            return CsvWriter$.MODULE$.adaptDataFrame(df, dataset.getSchema(), dataset.isManaged(), (CSVFormatConfig)dataset.getFormatParamsAs(CSVFormatConfig.class));
        }
        return df;
    }

    public DataStreamWriter<Row> setFormat(DatasetHandler handler, org.apache.spark.sql.Dataset<Row> df, DataStreamWriter<Row> dsw, Dataset dataset) {
        String formatType = dataset.getFormatType();
        String string = formatType;
        if ("parquet".equals(string)) {
            Map<String, String> options = ParquetWriter$.MODULE$.prepareSaveParquetDataset(handler, df);
            return dsw.format("parquet").options(options);
        }
        if ("orcfile".equals(string)) {
            Map<String, String> options = ORCWriter$.MODULE$.prepareSaveORCDataset(handler, df);
            return dsw.format("orc").options(options);
        }
        if ("json".equals(string)) {
            Map<String, String> options = JsonWriter$.MODULE$.prepareSaveJsonDataset(handler, df);
            return dsw.format("json").options(options);
        }
        if ("csv".equals(string)) {
            Map<String, String> options = CsvWriter$.MODULE$.prepareSaveCsvDataset(handler, df);
            return dsw.format("csv").options(options);
        }
        throw new UnsupportedOperationException(new StringBuilder(35).append("Output format ").append(formatType).append(" not supported for SS").toString());
    }

    public StreamingQuery saveStreaming(Dataset dataset, org.apache.spark.sql.Dataset<Row> df, String outputMode, String apiTicket) {
        String rootPath;
        DataStreamWriter dataStreamWriter;
        DataStreamWriter dataStreamWriter2;
        String logPrefix = new StringBuilder(16).append("saveStreaming ").append(dataset.getFullName()).append(": ").toString();
        DatasetHandler dsh = null;
        org.apache.spark.sql.Dataset<Row> dfWithTimeCols = dataset.getPartitioningSchema().isPartitioned() ? this.addTimePartitionFormattedColumn(df, dataset) : df;
        String string = dataset.getType();
        if ("Filesystem".equals(string)) {
            Tuple2<Object, String> fsAccessibility = StorageBackendsSupport$.MODULE$.isFilesystemDatasetCompatible(dataset, df.sqlContext());
            if (!fsAccessibility._1$mcZ$sp()) {
                dataStreamWriter2 = this.saveStreamingToRemote(df, dataset, apiTicket);
            } else {
                dsh = DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                dataStreamWriter2 = this.saveStreamingToFS((AbstractFSDatasetHandler)((FilesystemDatasetHandler)dsh), df, dataset, apiTicket);
            }
        } else if ("HDFS".equals(string)) {
            Tuple2<Object, String> hdfsAccessibility = StorageBackendsSupport$.MODULE$.isHDFSDatasetCompatible(dataset);
            if (!hdfsAccessibility._1$mcZ$sp()) {
                this.logger().info((Object)new StringBuilder(59).append("Not using fast path for stream write with ").append(dataset.getType()).append(" dataset because ").append(hdfsAccessibility._2()).toString());
                dataStreamWriter2 = this.saveStreamingToRemote(df, dataset, apiTicket);
            } else {
                dsh = DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                dataStreamWriter2 = this.saveStreamingToFS((AbstractFSDatasetHandler)((HDFSDatasetHandler)dsh), df, dataset, apiTicket);
            }
        } else if ("S3".equals(string)) {
            Tuple2<Object, String> s3Accessibility = StorageBackendsSupport$.MODULE$.isS3DatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), true);
            if (!s3Accessibility._1$mcZ$sp()) {
                this.logger().info((Object)new StringBuilder(59).append("Not using fast path for stream write with ").append(dataset.getType()).append(" dataset because ").append(s3Accessibility._2()).toString());
                dataStreamWriter2 = this.saveStreamingToRemote(df, dataset, apiTicket);
            } else {
                dsh = DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                dataStreamWriter2 = this.saveStreamingToFS((AbstractFSDatasetHandler)((S3DatasetHandler)dsh), df, dataset, apiTicket);
            }
        } else if ("GCS".equals(string)) {
            Tuple2<Object, String> gcsAccessibility = StorageBackendsSupport$.MODULE$.isGCSDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), true);
            if (!gcsAccessibility._1$mcZ$sp()) {
                this.logger().info((Object)new StringBuilder(59).append("Not using fast path for stream write with ").append(dataset.getType()).append(" dataset because ").append(gcsAccessibility._2()).toString());
                dataStreamWriter2 = this.saveStreamingToRemote(df, dataset, apiTicket);
            } else {
                dsh = DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                dataStreamWriter2 = this.saveStreamingToFS((AbstractFSDatasetHandler)((GCSDatasetHandler)dsh), df, dataset, apiTicket);
            }
        } else if ("Azure".equals(string)) {
            Tuple2<Object, String> azureAccessibility = StorageBackendsSupport$.MODULE$.isAzureDatasetCompatible(dataset, (AuthCtx)DSSAuthCtx.newNone(), true);
            if (!azureAccessibility._1$mcZ$sp()) {
                this.logger().info((Object)new StringBuilder(59).append("Not using fast path for stream write with ").append(dataset.getType()).append(" dataset because ").append(azureAccessibility._2()).toString());
                dataStreamWriter2 = this.saveStreamingToRemote(df, dataset, apiTicket);
            } else {
                dsh = DatasetHandlerFactory.build((AuthCtx)DSSAuthCtx.newNone(), (Dataset)dataset);
                dataStreamWriter2 = this.saveStreamingToFS((AbstractFSDatasetHandler)((AzureBlobDatasetHandler)dsh), df, dataset, apiTicket);
            }
        } else {
            throw new UnsupportedOperationException("Output not supported in structured streaming");
        }
        DataStreamWriter dsw = dataStreamWriter2;
        if (dataset.getPartitioningSchema().isPartitioned()) {
            Buffer partitionColumnNames = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dataset.getPartitioningSchema().getDimensionNames()).asScala()).map((Function1 & Serializable & scala.Serializable)dn -> dataset.getPartitioningSchema().getDimension(dn).getName(), Buffer$.MODULE$.canBuildFrom());
            dataStreamWriter = dsw.partitionBy((Seq)partitionColumnNames);
        } else {
            dataStreamWriter = dsw;
        }
        DataStreamWriter dswPartitioned = dataStreamWriter;
        DatasetHandler datasetHandler = dsh;
        String string2 = datasetHandler instanceof HDFSableDatasetHandler ? ((HDFSableDatasetHandler)dsh).getFullyQualifiedRootPath() : (rootPath = datasetHandler instanceof AbstractFSDatasetHandler ? ((AbstractFSDatasetHandler)dsh).getInformationalRootPath() : null);
        DataStreamWriter dswCheckpointed = rootPath != null ? dswPartitioned.option("checkpointLocation", new StringBuilder(18).append(rootPath).append("/_spark_checkpoint").toString()) : (df.sqlContext().getConf("spark.sql.streaming.checkpointLocation", "").length() == 0 ? dswPartitioned.option("checkpointLocation", new StringBuilder(7).append("file://").append(new File(".", "_spark_checkpoint").getAbsolutePath()).toString()) : dswPartitioned);
        return dswCheckpointed.queryName(new StringBuilder(11).append("streamToDs.").append(dataset.getFullName()).toString()).outputMode(outputMode).trigger(Trigger.ProcessingTime((String)"20 seconds")).start();
    }

    public DataStreamWriter<Row> saveStreamingToFS(AbstractFSDatasetHandler dsh, org.apache.spark.sql.Dataset<Row> df, Dataset dataset, String apiTicket) {
        Tuple2<Object, String> orcUsability;
        Tuple2<Object, String> parquetUsability;
        Tuple2<Object, String> jsonUsability;
        Tuple2<Object, String> csvUsability;
        if (StdDataikuSparkContext$.MODULE$.isCsvDataset(dataset) && !(csvUsability = HadoopFormatsSupport$.MODULE$.getCsvWriteUsability(dataset, df))._1$mcZ$sp()) {
            this.logger().info((Object)new StringBuilder(60).append("Not using fast path for stream write with ").append(dataset.getType()).append("-").append(dataset.getFormatType()).append(" dataset because ").append(csvUsability._2()).toString());
            return this.saveStreamingToRemote(df, dataset, apiTicket);
        }
        if (StdDataikuSparkContext$.MODULE$.isJsonDataset(dataset) && !(jsonUsability = HadoopFormatsSupport$.MODULE$.getJsonWriteUsability(dataset, df))._1$mcZ$sp()) {
            this.logger().info((Object)new StringBuilder(60).append("Not using fast path for stream write with ").append(dataset.getType()).append("-").append(dataset.getFormatType()).append(" dataset because ").append(jsonUsability._2()).toString());
            return this.saveStreamingToRemote(df, dataset, apiTicket);
        }
        if (StdDataikuSparkContext$.MODULE$.isParquetDataset(dataset) && !(parquetUsability = HadoopFormatsSupport$.MODULE$.getParquetWriteUsability(dataset, df))._1$mcZ$sp()) {
            this.logger().info((Object)new StringBuilder(60).append("Not using fast path for stream write with ").append(dataset.getType()).append("-").append(dataset.getFormatType()).append(" dataset because ").append(parquetUsability._2()).toString());
            return this.saveStreamingToRemote(df, dataset, apiTicket);
        }
        if (StdDataikuSparkContext$.MODULE$.isORCDataset(dataset) && !(orcUsability = HadoopFormatsSupport$.MODULE$.getORCWriteUsability(dataset, df))._1$mcZ$sp()) {
            this.logger().info((Object)new StringBuilder(60).append("Not using fast path for stream write with ").append(dataset.getType()).append("-").append(dataset.getFormatType()).append(" dataset because ").append(orcUsability._2()).toString());
            return this.saveStreamingToRemote(df, dataset, apiTicket);
        }
        this.logger().info((Object)new StringBuilder(45).append("Use fast path for stream write with ").append(dataset.getType()).append("-").append(dataset.getFormatType()).append(" dataset").toString());
        AbstractFSDatasetHandler abstractFSDatasetHandler = dsh;
        String rootPath = abstractFSDatasetHandler instanceof HDFSableDatasetHandler ? ((HDFSableDatasetHandler)dsh).getFullyQualifiedRootPath() : (abstractFSDatasetHandler != null ? dsh.getInformationalRootPath() : null);
        org.apache.spark.sql.Dataset<Row> finalDF = this.adaptForFormat(df, dataset);
        DataStreamWriter dsw = finalDF.writeStream();
        return this.setFormat((DatasetHandler)dsh, finalDF, (DataStreamWriter<Row>)dsw, dataset).option("path", rootPath);
    }

    public DataStreamWriter<Row> saveStreamingToRemote(org.apache.spark.sql.Dataset<Row> df, Dataset dataset, String apiTicket) {
        String dsFullName = dataset.getFullName();
        Schema dsSchema = dataset.getSchema();
        return df.writeStream().format("com.dataiku.dip.spark.compat.RemoteDatasetSinkProvider").option("apiTicket", apiTicket).option("datasetFullName", dsFullName).option("datasetSchema", JSON.json((Object)dsSchema));
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ void $anonfun$addTimePartitionFormattedColumn$1(Dataset dataset$1, ObjectRef partitionedDF$1, org.apache.spark.sql.Dataset df$1, String dn) {
        Dimension dimension = dataset$1.getPartitioningSchema().getDimension(dn);
        Dimension dimension2 = dimension;
        if (dimension2 instanceof TimeDimension) {
            TimeDimension timeDimension = (TimeDimension)dimension2;
            TimeDimension.Period period = timeDimension.mappedPeriod;
            if (TimeDimension.Period.YEAR.equals(period)) {
                partitionedDF$1.elem = ((org.apache.spark.sql.Dataset)partitionedDF$1.elem).withColumn(timeDimension.getName(), functions$.MODULE$.year(df$1.col("time")));
            } else if (TimeDimension.Period.MONTH.equals(period)) {
                partitionedDF$1.elem = ((org.apache.spark.sql.Dataset)partitionedDF$1.elem).withColumn(timeDimension.getName(), functions$.MODULE$.date_format(df$1.col("time"), "yyyy-MM"));
            } else if (TimeDimension.Period.DAY.equals(period)) {
                partitionedDF$1.elem = ((org.apache.spark.sql.Dataset)partitionedDF$1.elem).withColumn(timeDimension.getName(), functions$.MODULE$.date_format(df$1.col("time"), "yyyy-MM-dd"));
            } else if (TimeDimension.Period.HOUR.equals(period)) {
                partitionedDF$1.elem = ((org.apache.spark.sql.Dataset)partitionedDF$1.elem).withColumn(timeDimension.getName(), functions$.MODULE$.date_format(df$1.col("time"), "yyyy-MM-dd-HH"));
            } else {
                throw new MatchError((Object)period);
            }
            return;
        }
        throw new MatchError((Object)dimension2);
    }

    private StructuredStreamingDatasetWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.stream.dataset");
    }
}

