/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CloudWatchLogOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.IKEVersionsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1DHGroupNumbersRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1EncryptionAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase1IntegrityAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2DHGroupNumbersRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2EncryptionAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VpnTunnelLogOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.VpnTunnelOptionsSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVpnConnectionRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {
    @Override
    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {
        SdkInternalList createVpnConnectionRequestTagSpecificationsList;
        VpnConnectionOptionsSpecification options;
        if (createVpnConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVpnConnectionRequest> request = new DefaultRequest<CreateVpnConnectionRequest>(createVpnConnectionRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRequest.getCustomerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString(createVpnConnectionRequest.getCustomerGatewayId()));
        }
        if (createVpnConnectionRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(createVpnConnectionRequest.getType()));
        }
        if (createVpnConnectionRequest.getVpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString(createVpnConnectionRequest.getVpnGatewayId()));
        }
        if (createVpnConnectionRequest.getTransitGatewayId() != null) {
            request.addParameter("TransitGatewayId", StringUtils.fromString(createVpnConnectionRequest.getTransitGatewayId()));
        }
        if ((options = createVpnConnectionRequest.getOptions()) != null) {
            SdkInternalList vpnConnectionOptionsSpecificationTunnelOptionsList;
            if (options.getEnableAcceleration() != null) {
                request.addParameter("Options.EnableAcceleration", StringUtils.fromBoolean(options.getEnableAcceleration()));
            }
            if (options.getStaticRoutesOnly() != null) {
                request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean(options.getStaticRoutesOnly()));
            }
            if (options.getTunnelInsideIpVersion() != null) {
                request.addParameter("Options.TunnelInsideIpVersion", StringUtils.fromString(options.getTunnelInsideIpVersion()));
            }
            if (!(vpnConnectionOptionsSpecificationTunnelOptionsList = (SdkInternalList)options.getTunnelOptions()).isEmpty() || !vpnConnectionOptionsSpecificationTunnelOptionsList.isAutoConstruct()) {
                int tunnelOptionsListIndex = 1;
                for (VpnTunnelOptionsSpecification vpnConnectionOptionsSpecificationTunnelOptionsListValue : vpnConnectionOptionsSpecificationTunnelOptionsList) {
                    CloudWatchLogOptionsSpecification cloudWatchLogOptions;
                    VpnTunnelLogOptionsSpecification logOptions;
                    SdkInternalList vpnTunnelOptionsSpecificationIKEVersionsList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase2DHGroupNumbersList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase1DHGroupNumbersList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList;
                    SdkInternalList vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList;
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getTunnelInsideCidr() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".TunnelInsideCidr", StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getTunnelInsideCidr()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getTunnelInsideIpv6Cidr() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".TunnelInsideIpv6Cidr", StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getTunnelInsideIpv6Cidr()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPreSharedKey() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".PreSharedKey", StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPreSharedKey()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase1LifetimeSeconds() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase1LifetimeSeconds", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase1LifetimeSeconds()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase2LifetimeSeconds() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase2LifetimeSeconds", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase2LifetimeSeconds()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getRekeyMarginTimeSeconds() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".RekeyMarginTimeSeconds", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getRekeyMarginTimeSeconds()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getRekeyFuzzPercentage() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".RekeyFuzzPercentage", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getRekeyFuzzPercentage()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getReplayWindowSize() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".ReplayWindowSize", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getReplayWindowSize()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getDPDTimeoutSeconds() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".DPDTimeoutSeconds", StringUtils.fromInteger(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getDPDTimeoutSeconds()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getDPDTimeoutAction() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".DPDTimeoutAction", StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getDPDTimeoutAction()));
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase1EncryptionAlgorithms()).isEmpty() || !vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList.isAutoConstruct()) {
                        int phase1EncryptionAlgorithmsListIndex = 1;
                        for (Object vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue : vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsList) {
                            if (((Phase1EncryptionAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase1EncryptionAlgorithm." + phase1EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase1EncryptionAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue).getValue()));
                            }
                            ++phase1EncryptionAlgorithmsListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase2EncryptionAlgorithms()).isEmpty() || !vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList.isAutoConstruct()) {
                        Object vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue;
                        int phase2EncryptionAlgorithmsListIndex = 1;
                        vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue = vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsList.iterator();
                        while (vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue.hasNext()) {
                            Phase2EncryptionAlgorithmsRequestListValue vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue = (Phase2EncryptionAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1EncryptionAlgorithmsListValue.next();
                            if (vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue.getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase2EncryptionAlgorithm." + phase2EncryptionAlgorithmsListIndex + ".Value", StringUtils.fromString(vpnTunnelOptionsSpecificationPhase2EncryptionAlgorithmsListValue.getValue()));
                            }
                            ++phase2EncryptionAlgorithmsListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase1IntegrityAlgorithms()).isEmpty() || !vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList.isAutoConstruct()) {
                        int phase1IntegrityAlgorithmsListIndex = 1;
                        for (Object vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue : vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsList) {
                            if (((Phase1IntegrityAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase1IntegrityAlgorithm." + phase1IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString(((Phase1IntegrityAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue).getValue()));
                            }
                            ++phase1IntegrityAlgorithmsListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase2IntegrityAlgorithms()).isEmpty() || !vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList.isAutoConstruct()) {
                        Object vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue;
                        int phase2IntegrityAlgorithmsListIndex = 1;
                        vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue = vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsList.iterator();
                        while (vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue.hasNext()) {
                            Phase2IntegrityAlgorithmsRequestListValue vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue = (Phase2IntegrityAlgorithmsRequestListValue)vpnTunnelOptionsSpecificationPhase1IntegrityAlgorithmsListValue.next();
                            if (vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue.getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase2IntegrityAlgorithm." + phase2IntegrityAlgorithmsListIndex + ".Value", StringUtils.fromString(vpnTunnelOptionsSpecificationPhase2IntegrityAlgorithmsListValue.getValue()));
                            }
                            ++phase2IntegrityAlgorithmsListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase1DHGroupNumbersList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase1DHGroupNumbers()).isEmpty() || !vpnTunnelOptionsSpecificationPhase1DHGroupNumbersList.isAutoConstruct()) {
                        int phase1DHGroupNumbersListIndex = 1;
                        for (Object vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue : vpnTunnelOptionsSpecificationPhase1DHGroupNumbersList) {
                            if (((Phase1DHGroupNumbersRequestListValue)vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase1DHGroupNumber." + phase1DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger(((Phase1DHGroupNumbersRequestListValue)vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue).getValue()));
                            }
                            ++phase1DHGroupNumbersListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationPhase2DHGroupNumbersList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getPhase2DHGroupNumbers()).isEmpty() || !vpnTunnelOptionsSpecificationPhase2DHGroupNumbersList.isAutoConstruct()) {
                        Object vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue;
                        int phase2DHGroupNumbersListIndex = 1;
                        vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue = vpnTunnelOptionsSpecificationPhase2DHGroupNumbersList.iterator();
                        while (vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue.hasNext()) {
                            Phase2DHGroupNumbersRequestListValue vpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue = (Phase2DHGroupNumbersRequestListValue)vpnTunnelOptionsSpecificationPhase1DHGroupNumbersListValue.next();
                            if (vpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue.getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".Phase2DHGroupNumber." + phase2DHGroupNumbersListIndex + ".Value", StringUtils.fromInteger(vpnTunnelOptionsSpecificationPhase2DHGroupNumbersListValue.getValue()));
                            }
                            ++phase2DHGroupNumbersListIndex;
                        }
                    }
                    if (!(vpnTunnelOptionsSpecificationIKEVersionsList = (SdkInternalList)vpnConnectionOptionsSpecificationTunnelOptionsListValue.getIKEVersions()).isEmpty() || !vpnTunnelOptionsSpecificationIKEVersionsList.isAutoConstruct()) {
                        int iKEVersionsListIndex = 1;
                        for (IKEVersionsRequestListValue vpnTunnelOptionsSpecificationIKEVersionsListValue : vpnTunnelOptionsSpecificationIKEVersionsList) {
                            if (vpnTunnelOptionsSpecificationIKEVersionsListValue.getValue() != null) {
                                request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".IKEVersion." + iKEVersionsListIndex + ".Value", StringUtils.fromString(vpnTunnelOptionsSpecificationIKEVersionsListValue.getValue()));
                            }
                            ++iKEVersionsListIndex;
                        }
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getStartupAction() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".StartupAction", StringUtils.fromString(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getStartupAction()));
                    }
                    if ((logOptions = vpnConnectionOptionsSpecificationTunnelOptionsListValue.getLogOptions()) != null && (cloudWatchLogOptions = logOptions.getCloudWatchLogOptions()) != null) {
                        if (cloudWatchLogOptions.getLogEnabled() != null) {
                            request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".LogOptions.CloudWatchLogOptions.LogEnabled", StringUtils.fromBoolean(cloudWatchLogOptions.getLogEnabled()));
                        }
                        if (cloudWatchLogOptions.getLogGroupArn() != null) {
                            request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".LogOptions.CloudWatchLogOptions.LogGroupArn", StringUtils.fromString(cloudWatchLogOptions.getLogGroupArn()));
                        }
                        if (cloudWatchLogOptions.getLogOutputFormat() != null) {
                            request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".LogOptions.CloudWatchLogOptions.LogOutputFormat", StringUtils.fromString(cloudWatchLogOptions.getLogOutputFormat()));
                        }
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.getEnableTunnelLifecycleControl() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".EnableTunnelLifecycleControl", StringUtils.fromBoolean(vpnConnectionOptionsSpecificationTunnelOptionsListValue.getEnableTunnelLifecycleControl()));
                    }
                    ++tunnelOptionsListIndex;
                }
            }
            if (options.getLocalIpv4NetworkCidr() != null) {
                request.addParameter("Options.LocalIpv4NetworkCidr", StringUtils.fromString(options.getLocalIpv4NetworkCidr()));
            }
            if (options.getRemoteIpv4NetworkCidr() != null) {
                request.addParameter("Options.RemoteIpv4NetworkCidr", StringUtils.fromString(options.getRemoteIpv4NetworkCidr()));
            }
            if (options.getLocalIpv6NetworkCidr() != null) {
                request.addParameter("Options.LocalIpv6NetworkCidr", StringUtils.fromString(options.getLocalIpv6NetworkCidr()));
            }
            if (options.getRemoteIpv6NetworkCidr() != null) {
                request.addParameter("Options.RemoteIpv6NetworkCidr", StringUtils.fromString(options.getRemoteIpv6NetworkCidr()));
            }
            if (options.getOutsideIpAddressType() != null) {
                request.addParameter("Options.OutsideIpAddressType", StringUtils.fromString(options.getOutsideIpAddressType()));
            }
            if (options.getTransportTransitGatewayAttachmentId() != null) {
                request.addParameter("Options.TransportTransitGatewayAttachmentId", StringUtils.fromString(options.getTransportTransitGatewayAttachmentId()));
            }
        }
        if (!(createVpnConnectionRequestTagSpecificationsList = (SdkInternalList)createVpnConnectionRequest.getTagSpecifications()).isEmpty() || !createVpnConnectionRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVpnConnectionRequestTagSpecificationsListValue : createVpnConnectionRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVpnConnectionRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVpnConnectionRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVpnConnectionRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

