/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeCoipPoolsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeCoipPoolsRequestMarshaller
implements Marshaller<Request<DescribeCoipPoolsRequest>, DescribeCoipPoolsRequest> {
    @Override
    public Request<DescribeCoipPoolsRequest> marshall(DescribeCoipPoolsRequest describeCoipPoolsRequest) {
        SdkInternalList describeCoipPoolsRequestFiltersList;
        if (describeCoipPoolsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCoipPoolsRequest> request = new DefaultRequest<DescribeCoipPoolsRequest>(describeCoipPoolsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeCoipPools");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeCoipPoolsRequestPoolIdsList = (SdkInternalList)describeCoipPoolsRequest.getPoolIds();
        if (!describeCoipPoolsRequestPoolIdsList.isEmpty() || !describeCoipPoolsRequestPoolIdsList.isAutoConstruct()) {
            int poolIdsListIndex = 1;
            for (String describeCoipPoolsRequestPoolIdsListValue : describeCoipPoolsRequestPoolIdsList) {
                if (describeCoipPoolsRequestPoolIdsListValue != null) {
                    request.addParameter("PoolId." + poolIdsListIndex, StringUtils.fromString(describeCoipPoolsRequestPoolIdsListValue));
                }
                ++poolIdsListIndex;
            }
        }
        if (!(describeCoipPoolsRequestFiltersList = (SdkInternalList)describeCoipPoolsRequest.getFilters()).isEmpty() || !describeCoipPoolsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeCoipPoolsRequestFiltersListValue : describeCoipPoolsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeCoipPoolsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeCoipPoolsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeCoipPoolsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeCoipPoolsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeCoipPoolsRequest.getMaxResults()));
        }
        if (describeCoipPoolsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeCoipPoolsRequest.getNextToken()));
        }
        return request;
    }
}

