/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.RunScheduledInstancesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesEbs;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesIpv6Address;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesPlacement;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    @Override
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification launchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunScheduledInstancesRequest> request = new DefaultRequest<RunScheduledInstancesRequest>(runScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString(runScheduledInstancesRequest.getClientToken()));
        if (runScheduledInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(runScheduledInstancesRequest.getInstanceCount()));
        }
        if ((launchSpecification = runScheduledInstancesRequest.getLaunchSpecification()) != null) {
            SdkInternalList scheduledInstancesLaunchSpecificationSecurityGroupIdsList;
            ScheduledInstancesPlacement placement;
            SdkInternalList scheduledInstancesLaunchSpecificationNetworkInterfacesList;
            ScheduledInstancesMonitoring monitoring;
            ScheduledInstancesIamInstanceProfile iamInstanceProfile;
            SdkInternalList scheduledInstancesLaunchSpecificationBlockDeviceMappingsList = (SdkInternalList)launchSpecification.getBlockDeviceMappings();
            if (!scheduledInstancesLaunchSpecificationBlockDeviceMappingsList.isEmpty() || !scheduledInstancesLaunchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (ScheduledInstancesBlockDeviceMapping scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue : scheduledInstancesLaunchSpecificationBlockDeviceMappingsList) {
                    ScheduledInstancesEbs ebs;
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                    }
                    if ((ebs = scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                        }
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.getEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean(launchSpecification.getEbsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString(iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString(iamInstanceProfile.getName()));
                }
            }
            if (launchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString(launchSpecification.getImageId()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString(launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString(launchSpecification.getKernelId()));
            }
            if (launchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString(launchSpecification.getKeyName()));
            }
            if ((monitoring = launchSpecification.getMonitoring()) != null && monitoring.getEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean(monitoring.getEnabled()));
            }
            if (!(scheduledInstancesLaunchSpecificationNetworkInterfacesList = (SdkInternalList)launchSpecification.getNetworkInterfaces()).isEmpty() || !scheduledInstancesLaunchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (ScheduledInstancesNetworkInterface scheduledInstancesLaunchSpecificationNetworkInterfacesListValue : scheduledInstancesLaunchSpecificationNetworkInterfacesList) {
                    SdkInternalList scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList;
                    SdkInternalList scheduledInstancesNetworkInterfaceIpv6AddressesList;
                    SdkInternalList scheduledInstancesNetworkInterfaceGroupsList;
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDescription()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceGroupsList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !scheduledInstancesNetworkInterfaceGroupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        for (Object scheduledInstancesNetworkInterfaceGroupsListValue : scheduledInstancesNetworkInterfaceGroupsList) {
                            if (scheduledInstancesNetworkInterfaceGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringUtils.fromString((String)scheduledInstancesNetworkInterfaceGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceIpv6AddressesList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !scheduledInstancesNetworkInterfaceIpv6AddressesList.isAutoConstruct()) {
                        Object scheduledInstancesNetworkInterfaceGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        scheduledInstancesNetworkInterfaceGroupsListValue = scheduledInstancesNetworkInterfaceIpv6AddressesList.iterator();
                        while (scheduledInstancesNetworkInterfaceGroupsListValue.hasNext()) {
                            ScheduledInstancesIpv6Address scheduledInstancesNetworkInterfaceIpv6AddressesListValue = (ScheduledInstancesIpv6Address)scheduledInstancesNetworkInterfaceGroupsListValue.next();
                            if (scheduledInstancesNetworkInterfaceIpv6AddressesListValue.getIpv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString(scheduledInstancesNetworkInterfaceIpv6AddressesListValue.getIpv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList = (SdkInternalList)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getPrivateIpAddressConfigs()).isEmpty() || !scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList.isAutoConstruct()) {
                        int privateIpAddressConfigsListIndex = 1;
                        for (ScheduledInstancesPrivateIpAddressConfig scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue : scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList) {
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.getPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringUtils.fromBoolean(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.getPrimary()));
                            }
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringUtils.fromString(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.getPrivateIpAddress()));
                            }
                            ++privateIpAddressConfigsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString(scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.getSubnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString(placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString(placement.getGroupName()));
                }
            }
            if (launchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString(launchSpecification.getRamdiskId()));
            }
            if (!(scheduledInstancesLaunchSpecificationSecurityGroupIdsList = (SdkInternalList)launchSpecification.getSecurityGroupIds()).isEmpty() || !scheduledInstancesLaunchSpecificationSecurityGroupIdsList.isAutoConstruct()) {
                int securityGroupIdsListIndex = 1;
                for (String scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue : scheduledInstancesLaunchSpecificationSecurityGroupIdsList) {
                    if (scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString(launchSpecification.getSubnetId()));
            }
            if (launchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString(launchSpecification.getUserData()));
            }
        }
        if (runScheduledInstancesRequest.getScheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringUtils.fromString(runScheduledInstancesRequest.getScheduledInstanceId()));
        }
        return request;
    }
}

