/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.agents.tools.AgentToolsCRUDService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIKnowledgeBankController
extends PublicAPIControllerBase {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private AgentToolsCRUDService agentToolsCRUDService;

    @AuditedCall(value={"msgType", "llm-mesh-knowledge-banks-search", "projectKey", "${projectKey}", "knowledgeBankId", "${knowledgeBankId}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/knowledge-banks/{knowledgeBankId}/search"}, method={RequestMethod.POST})
    @ResponseBody
    public KnowledgeBankSearchResponse searchKnowledgeBank(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String knowledgeBankId, @RequestParam String query, @RequestParam JsonObject params) throws Exception {
        RetrievableKnowledge rk;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            AnyLoc loc = AnyLoc.resolveSmart((String)projectKey, (String)knowledgeBankId);
            this.projectsService.failIfNoRetrievableKnowledgeReadUseAccess(authCtx, loc, projectKey);
            rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatoryUnsafe(loc);
        }
        AgentToolsCRUDService.ToolQuickTestResponse toolResponse = this.agentToolsCRUDService.searchKnowledgeBank(authCtx, rk, query, params);
        KnowledgeBankSearchResponse response = new KnowledgeBankSearchResponse();
        if (toolResponse.error != null) {
            response.error = toolResponse.error;
        } else {
            JsonArray documentsArray = toolResponse.response.output.getAsJsonObject().getAsJsonArray("documents");
            Type listType = new TypeToken<List<KnowledgeBankSearchResultDocument>>(){}.getType();
            response.documents = (List)JSON.gson().fromJson((JsonElement)documentsArray, listType);
        }
        return response;
    }

    public static class KnowledgeBankSearchResponse {
        SerializedError error;
        List<KnowledgeBankSearchResultDocument> documents;
    }

    public static class KnowledgeBankSearchResultDocument {
        String text;
        Float score;
        JsonObject metadata;
    }
}

