/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}"})
public class PublicAPIUsagesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private PluginsLoadService pluginsLoadService;
    @Autowired
    private PluginUsagesInspector pluginUsagesInspector;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.api.usages");

    @AuditedCall(value={"msgType", "lineage-inspect", "fromType", "DATASET", "projectKey", "${projectKey}", "objectId", "${datasetName}"})
    @RequestMapping(value={"/datasets/{datasetName}/usages"}, method={RequestMethod.GET})
    public void getDatasetUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        ArrayList usages = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_DATA});
            this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
            ProjectFlowGraph flow = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            FlowDataset flowDataset = flow.getDataset(projectKey, datasetName);
            if (flowDataset == null) {
                logger.info((Object)"Dataset is an orphan, and not used");
            } else {
                for (GraphNode successor : flowDataset.getSuccessors()) {
                    Dataset successorDataset;
                    if (successor instanceof FlowRecipe) {
                        usages.add(Usage.fromRecipe((FlowRecipe)successor, true));
                        continue;
                    }
                    if (!(successor instanceof FlowDataset) || !(successorDataset = ((FlowDataset)successor).getMandatory(this.datasetsDAO)).getType().equals(JobsdbDatasetHandler.META.getType())) continue;
                    usages.add(Usage.fromDataset(successorDataset));
                }
                for (GraphNode ancestor : flowDataset.getPredecessors()) {
                    if (!(ancestor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)ancestor, false));
                }
            }
            for (AnalysisCoreParams.AnalysisListItem analysis : this.analysisCRUDService.listHeadsUnsafe(projectKey, datasetName)) {
                usages.add(Usage.fromAnalysis(analysis));
            }
        }
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, (Object)usages);
    }

    @AuditedCall(value={"msgType", "lineage-inspect", "fromType", "SAVED_MODEL", "projectKey", "${projectKey}", "objectId", "${smId}"})
    @RequestMapping(value={"/savedmodels/{smId}/usages"}, method={RequestMethod.GET})
    public void getModelUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String smId) throws Exception {
        ArrayList usages = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.savedModelsDAO.getMandatoryUnsafe(projectKey, smId);
            ProjectFlowGraph flow = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            FlowSavedModel flowSavedModel = flow.getModel(projectKey, smId);
            if (flowSavedModel == null) {
                logger.info((Object)"Model is an orphan, and not used");
            } else {
                for (GraphNode successor : flowSavedModel.getSuccessors()) {
                    Dataset successorDataset;
                    if (successor instanceof FlowRecipe) {
                        usages.add(Usage.fromRecipe((FlowRecipe)successor, true));
                        continue;
                    }
                    if (!(successor instanceof FlowDataset) || !(successorDataset = ((FlowDataset)successor).getMandatory(this.datasetsDAO)).getType().equals(JobsdbDatasetHandler.META.getType())) continue;
                    usages.add(Usage.fromDataset(successorDataset));
                }
                for (GraphNode ancestor : flowSavedModel.getPredecessors()) {
                    if (!(ancestor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)ancestor, false));
                }
            }
        }
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, (Object)usages);
    }

    @AuditedCall(value={"msgType", "lineage-inspect", "fromType", "MODEL_EVALUATION_STORE", "projectKey", "${projectKey}", "objectId", "${mesId}"})
    @RequestMapping(value={"/modelevaluationstores/{mesId}/usages"}, method={RequestMethod.GET})
    public void getEvaluationStoreUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        ArrayList usages = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
            ProjectFlowGraph flow = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            FlowModelEvaluationStore flowModelEvaluationStore = flow.getEvaluationStore(projectKey, mesId);
            if (flowModelEvaluationStore == null) {
                logger.info((Object)"Evaluation store is an orphan, and not used");
            } else {
                for (GraphNode successor : flowModelEvaluationStore.getSuccessors()) {
                    Dataset successorDataset;
                    if (successor instanceof FlowRecipe) {
                        usages.add(Usage.fromRecipe((FlowRecipe)successor, true));
                        continue;
                    }
                    if (!(successor instanceof FlowDataset) || !(successorDataset = ((FlowDataset)successor).getMandatory(this.datasetsDAO)).getType().equals(JobsdbDatasetHandler.META.getType())) continue;
                    usages.add(Usage.fromDataset(successorDataset));
                }
                for (GraphNode ancestor : flowModelEvaluationStore.getPredecessors()) {
                    if (!(ancestor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)ancestor, false));
                }
            }
        }
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, (Object)usages);
    }

    @AuditedCall(value={"msgType", "lineage-inspect", "fromType", "MANAGED_FOLDER", "projectKey", "${projectKey}", "objectId", "${odbId}"})
    @RequestMapping(value={"/managedfolders/{odbId}/usages"}, method={RequestMethod.GET})
    public void getFolderUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String odbId) throws Exception {
        ArrayList usages = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.managedFolderDAO.getMandatory(projectKey, odbId);
            ProjectFlowGraph flow = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            FlowManagedFolder flowManagedFolder = flow.getFolder(projectKey, odbId);
            if (flowManagedFolder == null) {
                logger.info((Object)"Folder is an orphan, and not used");
            } else {
                for (GraphNode successor : flowManagedFolder.getSuccessors()) {
                    Dataset successorDataset;
                    if (successor instanceof FlowRecipe) {
                        usages.add(Usage.fromRecipe((FlowRecipe)successor, true));
                        continue;
                    }
                    if (!(successor instanceof FlowDataset) || !(successorDataset = ((FlowDataset)successor).getMandatory(this.datasetsDAO)).getType().equals(JobsdbDatasetHandler.META.getType())) continue;
                    usages.add(Usage.fromDataset(successorDataset));
                }
                for (GraphNode ancestor : flowManagedFolder.getPredecessors()) {
                    if (!(ancestor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)ancestor, false));
                }
            }
        }
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, (Object)usages);
    }

    @AuditedCall(value={"msgType", "lineage-inspect", "fromType", "STREAMING_ENDPOINT", "projectKey", "${projectKey}", "objectId", "${streamingEndpointId}"})
    @RequestMapping(value={"/streamingendpoints/{streamingEndpointId}/usages"}, method={RequestMethod.GET})
    public void getStreamingEndpointUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        ArrayList usages = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            ProjectFlowGraph flow = this.flowGraphService.getProjectGraphUnsafe(projectKey);
            FlowStreamingEndpoint flowStreamingEndpoint = flow.getStreamingEndpoint(projectKey, streamingEndpointId);
            if (flowStreamingEndpoint == null) {
                logger.info((Object)"Streaming endpoint is an orphan, and not used");
            } else {
                for (GraphNode successor : flowStreamingEndpoint.getSuccessors()) {
                    if (!(successor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)successor, true));
                }
                for (GraphNode ancestor : flowStreamingEndpoint.getPredecessors()) {
                    if (!(ancestor instanceof FlowRecipe)) continue;
                    usages.add(Usage.fromRecipe((FlowRecipe)ancestor, false));
                }
            }
        }
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, (Object)usages);
    }

    @AuditedCall(value={"msgType", "project-plugin-usages", "projectId", "${projectId}"})
    @RequestMapping(value={"/plugins/usages"}, method={RequestMethod.GET})
    public void getPluginsUsages(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        Collection loadedPlugins;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            loadedPlugins = this.pluginsLoadService.getLoadedPlugins();
        }
        List<PluginUsagesForProject> usages = loadedPlugins.stream().map(loadedPlugin -> new PluginUsagesForProject(loadedPlugin.desc.id, this.pluginUsagesInspector.getUsages(projectKey, loadedPlugin.desc.id))).filter(PluginUsagesForProject::isUsed).toList();
        PublicAPIUsagesController.writeJSON((HttpServletResponse)resp, usages);
    }

    public static class Usage {
        UsageType type;
        String objectProjectKey;
        String objectId;

        static Usage fromRecipe(FlowRecipe recipe, boolean asInput) {
            Usage ret = new Usage();
            ret.type = asInput ? UsageType.RECIPE_INPUT : UsageType.RECIPE_OUTPUT;
            ret.objectProjectKey = recipe.getProjectKey();
            ret.objectId = recipe.getName();
            return ret;
        }

        static Usage fromDataset(Dataset dataset) {
            Usage ret = new Usage();
            ret.type = UsageType.METRICS_SOURCE;
            ret.objectProjectKey = dataset.getProjectKey();
            ret.objectId = dataset.getName();
            return ret;
        }

        static Usage fromAnalysis(AnalysisCoreParams.AnalysisListItem analysis) {
            Usage ret = new Usage();
            ret.type = UsageType.ANALYSIS;
            ret.objectProjectKey = analysis.projectKey;
            ret.objectId = analysis.id;
            return ret;
        }
    }

    private static class PluginUsagesForProject {
        String pluginId;
        PluginUsagesInspector.PluginUsages pluginUsages;

        public PluginUsagesForProject(String pluginId, PluginUsagesInspector.PluginUsages pluginUsages) {
            this.pluginId = pluginId;
            this.pluginUsages = pluginUsages;
        }

        public boolean isUsed() {
            return !this.pluginUsages.usages.isEmpty() || !this.pluginUsages.missingTypes.isEmpty();
        }
    }

    public static enum UsageType {
        RECIPE_INPUT,
        RECIPE_OUTPUT,
        METRICS_SOURCE,
        ANALYSIS;

    }
}

