/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.catalog;

import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.connections.ConnectionsIndexingService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/catalog"})
public class PublicAPIExternalCatalogController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ConnectionsIndexingService indexingService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ConnectionMetadataDAO connectionMetadataDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.metrics.api");

    @AuditedCall(value={"msgType", "index"})
    @RequestMapping(value={"/index"}, method={RequestMethod.POST})
    public void indexConnections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx user;
        IndexRequest request = (IndexRequest)this.getRequestBodyAs(req, IndexRequest.class);
        if (!request.indexAllConnections && request.connectionNames == null) {
            throw new IllegalArgumentException("Either indexAllConnections should be true or connectionNames parameter should be specified");
        }
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(user);
        }
        Set<String> conns = null;
        if (request.indexingMode == IndexingMode.FULL) {
            conns = this.scanConnections(user, request.indexAllConnections ? null : request.connectionNames);
        } else if (request.indexingMode == IndexingMode.LIGHT) {
            conns = this.indexConnections(user, request.indexAllConnections ? null : request.connectionNames);
        }
        if (conns != null) {
            PublicAPIExternalCatalogController.writeJSON((HttpServletResponse)resp, this.getConnectionMetadata(conns));
        }
    }

    private Set<String> indexConnections(AuthCtx user, Set<String> connections) throws Exception {
        ConnectionsIndexingService.ListIndexableConnectionsResponse ret = this.indexingService.getIndexableConnections_NT(user);
        Sets.SetView conns = connections == null ? ret.indexableConnections : Sets.intersection(connections, ret.indexableConnections);
        logger.info((Object)String.format("Starting to index %d connections: %s", conns.size(), StringUtils.join((Collection)conns, (String)", ")));
        FutureResponse fr = this.indexingService.startIndex((Set<String>)conns, user);
        fr = this.futureService.waitForFinalResponse(fr);
        return conns;
    }

    private Set<String> scanConnections(AuthCtx user, Set<String> connections) throws Exception {
        ConnectionsIndexingService.ListIndexableConnectionsResponse ret = this.indexingService.getIndexableConnections_NT(user);
        Sets.SetView conns = connections == null ? ret.scannableConnections : Sets.intersection(connections, ret.scannableConnections);
        logger.info((Object)String.format("Starting to scan %d connections: %s", conns.size(), StringUtils.join((Collection)conns, (String)", ")));
        FutureResponse fr = this.indexingService.startScanAndIndex((Set<String>)conns, user);
        fr = this.futureService.waitForFinalResponse(fr);
        return conns;
    }

    private List<ConnectionMetadataDAO.ConnectionMetadata> getConnectionMetadata(Set<String> conns) throws IOException {
        Map allConnectionsMetadata = this.connectionMetadataDAO.getAll();
        ArrayList<ConnectionMetadataDAO.ConnectionMetadata> result = new ArrayList<ConnectionMetadataDAO.ConnectionMetadata>();
        for (String indexableConnection : conns) {
            if (!allConnectionsMetadata.containsKey(indexableConnection)) continue;
            result.add((ConnectionMetadataDAO.ConnectionMetadata)allConnectionsMetadata.get(indexableConnection));
        }
        return result;
    }

    public static class IndexRequest {
        public IndexingMode indexingMode = IndexingMode.FULL;
        public Set<String> connectionNames;
        public boolean indexAllConnections;
    }

    static enum IndexingMode {
        FULL,
        LIGHT;

    }
}

