/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import java.util.Objects;

@Evolving
public class ArrayType
extends DataType {
    private final StructField elementField;

    public ArrayType(DataType dataType, boolean bl) {
        this.elementField = new StructField("element", dataType, bl);
    }

    public ArrayType(StructField structField) {
        this.elementField = structField;
    }

    public StructField getElementField() {
        return this.elementField;
    }

    public DataType getElementType() {
        return this.elementField.getDataType();
    }

    public boolean containsNull() {
        return this.elementField.isNullable();
    }

    @Override
    public boolean equivalent(DataType dataType) {
        return dataType instanceof ArrayType && ((ArrayType)dataType).getElementType().equivalent(this.getElementType());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return Objects.equals(this.elementField, arrayType.elementField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elementField);
    }

    @Override
    public String toString() {
        return "array[" + this.getElementType() + "]";
    }
}

