/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.servlets;

import com.dataiku.hproxy.model.hive.ValidationQuery;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.hive.checker.Checker;
import com.dataiku.hproxy.server.servlets.BaseServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class HiveExecutorServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private ClassLoader checkerClassLoader;

    public HiveExecutorServlet(Context ctx) {
        super(ctx);
        this.checkerClassLoader = ctx.getClassLoaderPool().requirePooled("sandbox", "hive", "hive-additional");
    }

    @Override
    public void serviceCall(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        try {
            switch (path) {
                case "/check": {
                    this.handleCheck(req, resp);
                    break;
                }
                default: {
                    this.sendError(resp, new Exception("Unknown command"));
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.sendError(resp, e);
        }
    }

    public void destroy() {
    }

    private void handleCheck(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        ValidationQuery query = this.getParameter(req, "query", ValidationQuery.class);
        this.writeJSON(resp, new Checker(this.checkerClassLoader, this.getContext().getHadoopFS()).check(query));
    }
}

