(function() {
'use strict';

const app = angular.module('dataiku.logs', []);

const simpleLogsLink = function($interval) {
    return function($scope, element, attrs) {
        $scope.uiState = {
                logsQuery : ''
            };

        $scope.currentLogName = null;
        $scope.currentLog = null;
        $scope.cancelFetch = null;

        $scope.fetchLog = function(logName) {
            $scope.getLog()(...$scope.objId, logName).success(function(data) {
                $scope.currentLogName = logName;
                $scope.currentLog = data;
            }).error(function(a, b, c) {
                $scope.stopPoll();
                setErrorInScope.bind($scope)(a, b, c);
            });
        }

        $scope.fetchLogRepeat = function(logName) {
            if ($scope.cancelFetch) {
                $interval.cancel($scope.cancelFetch);
            }
            $scope.fetchLog(logName);
            $scope.cancelFetch = $interval(function() {
                $scope.fetchLog(logName);
            }, 10*1000);
        };
        $scope.stopPoll = function() {
            if ($scope.cancelFetch) {
                $interval.cancel($scope.cancelFetch);
            }
            $scope.cancelFetch = null;
        }
        $scope.$on('$destroy', function () {
            $scope.stopPoll();
        });
        $scope.downloadLink = function(logName) {
            return $scope.downloadUrl()(...$scope.objId, logName);
        }

        $scope.downloadAllLink = function() {
            return $scope.downloadAllUrl()(...$scope.objId);
        }

        $scope.$watch("logs", function(nv,ov) {
            if (!$scope.logs) {
                $scope.currentLog = null;
                $scope.currentLogName = null;
            } else if ($scope.currentLogName && !$scope.logs.map(l => l.name).includes($scope.currentLogName)) {
                $scope.stopPoll();
                $scope.currentLogName = null;
                $scope.currentLog = null;
            } else if ($scope.logs.length == 1) {
                $scope.fetchLogRepeat($scope.logs[0].name);
            }
        });
    }
}

app.directive('simpleLogs', function($interval) {
    return {
        restrict : 'A',
        templateUrl : '/templates/simple-logs.html',
        replace : true,
        scope : {
                objId  : '=',
                logs : '=',
                getLog : '&',
                downloadLog : '&',
                downloadUrl : '&',
                downloadAllUrl : '&?'
        },
        link : simpleLogsLink($interval)
    };
});

app.directive('simpleLogsTwoPanes', function($interval) {
    return {
        restrict : 'A',
        templateUrl : '/templates/simple-logs-two-panes.html',
        replace : true,
        scope : {
                objId  : '=',
                logs : '=',
                getLog : '&',
                downloadLog : '&',
                downloadUrl : '&',
                downloadAllUrl : '&?'
        },
        link :  simpleLogsLink($interval)
    };
});



})();