(function() {
    'use strict';

    angular.module('dataiku.charts')
        .service('ChartContextualMenu', ChartContextualMenu);

    function ChartContextualMenu($rootScope, $stateParams, ChartFilters, ChartLabels, ContextualMenu, AnimatedChartsUtils, DashboardFilters, DashboardUtils) {

        const svc = {
            create: function(chartData, chartDef, chartStore, animation = {}) {
                const isInDashboard = DashboardUtils.isInDashboard();
                const contextualMenu = {
                    open: function(event, filteringOptions = { filterableElements: [] }, customActions = [], type = 'measure') {
                        let canFilter, newScope, menu;

                        switch (type) {
                            case 'measure':
                                canFilter = (!isInDashboard || DashboardFilters.canCrossFilter($stateParams.pageId)) && filteringOptions.filterableElements.length > 0;
                                if (canFilter || customActions.length) {
                                    menu = new ContextualMenu({
                                        contextual: false,
                                        template: '/templates/simple_report/contextual-menu/chart-contextual-menu.html'
                                    });
                                    const data = {
                                        canFilter,
                                        disableMultiDimensionalFiltering: filteringOptions.disableMultiDimensionalFiltering,
                                        filterableElements: filteringOptions.filterableElements,
                                        includeOnly: contextualMenu.includeOnly,
                                        exclude: contextualMenu.exclude
                                    };
                                    const newScope = $rootScope.$new();
                                    newScope.customActions = customActions;
                                    newScope.data = angular.copy(data);
                                    menu.scope = newScope;
                                    menu.openAtXY(event.pageX, event.pageY);
                                    menu.$menu.addClass('chart-contextual-menu');
                                }

                                break;

                            case 'pivotTableHeader':
                                newScope = $rootScope.$new();
                                newScope.customActions = customActions;
                                menu = new ContextualMenu({
                                    contextual: false,
                                    template: '/templates/simple_report/contextual-menu/pivot-table-header-contextual-menu.html'
                                });
                                menu.scope = newScope;
                                menu.openAtXY(event.pageX, event.pageY);
                                menu.$menu.addClass('chart-contextual-menu');
                                break;
                        }
                    },
                    includeOnly: (filterableElements) => {
                        if (isInDashboard) {
                            const filters = filterableElements.map((filterableElement) => {
                                const { dimension, axisElt, value } = filterableElement;
                                return ChartFilters.createFilter({
                                    column: dimension.column,
                                    columnType: dimension.type,
                                    isAGlobalFilter: true,
                                    excludeOtherValues: true,
                                    label: `ONLY ${dimension.column}: ${value}`,
                                    useMinimalUi: true,
                                    includeEmptyValues: false
                                }, {
                                    dimension,
                                    axisElt
                                });
                            });
                            $rootScope.$emit('crossFiltersAdded', {
                                filters,
                                wt1Args: {
                                    from: 'chart',
                                    action: 'contextual_menu',
                                    chartType: chartDef.type,
                                    filterType: 'include'
                                }
                            });
                        } else {
                            let filters = chartDef.filters;
                            filterableElements.forEach((filterableElement) => {
                                const { dimension, axisElt } = filterableElement;
                                const { oldFilter, newFilter } = ChartFilters.getIncludeOnly1DFilter(dimension, axisElt, filters);
                                if (!ChartFilters.areFiltersEqual(oldFilter, newFilter)) {
                                    filters = ChartFilters.updateOrAddFilter(filters, newFilter, oldFilter);
                                }
                            });
                            chartDef.filters = filters;
                        }
                    },
                    exclude: (filterableElements) => {
                        const filter = ChartFilters.getExcludeNDFilter(filterableElements);
                        if (isInDashboard) {
                            filter.isAGlobalFilter = true;
                            $rootScope.$emit('crossFiltersAdded', {
                                filters: [filter],
                                wt1Args: {
                                    from: 'chart',
                                    action: 'contextual_menu',
                                    chartType: chartDef.type,
                                    filterType: 'exclude'
                                }
                            });
                        } else if (!chartDef.filters.some(f => ChartFilters.areFiltersEqual(f, filter))){
                            chartDef.filters = ChartFilters.updateOrAddFilter(chartDef.filters, filter);
                        }
                    },
                    showForCoords: (coords, event, customActions, type) => {
                        const finalCoords = {
                            ...coords,
                            animation: AnimatedChartsUtils.getAnimationCoord(animation)
                        };
                        const filteringOptions = ChartFilters.getFilterableOptions(chartStore, chartData, finalCoords, chartDef);
                        contextualMenu.open(event, filteringOptions, customActions, type);
                    },
                    addContextualMenuHandler: (domElement, coords, customActions, type) => {
                        d3.select(domElement)
                            .on('contextmenu.contextualmenu', () => {
                                d3.event.preventDefault();
                                contextualMenu.showForCoords(coords, d3.event, customActions, type);
                            });
                    },
                    removeContextualMenuHandler: (el) => {
                        d3.select(el)
                            .on('contextmenu', null);
                    },
                    addChartContextualMenuHandler: (chart, getTargetElementProperties, customActions) => {
                        d3.select(chart).on('contextmenu.contextualmenu', function() {
                            const target = d3.event.target;
                            const properties = getTargetElementProperties(target);
                            if (properties != null) {
                                d3.event.preventDefault();
                                contextualMenu.showForCoords(properties.coords, d3.event, customActions);
                            }
                        });
                    },
                    removeChartContextualMenuHandler: (chart) => {
                        d3.select(chart).on('contextmenu', null);
                    },
                    getAnimationContext: function() {
                        return AnimatedChartsUtils.getAnimationContext(chartDef.animationDimension[0], animation);
                    }
                };
                return contextualMenu;
            }
        };
        return svc;
    }
})();
