from dataiku.eda.types import Literal

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.distributions.distribution import FittedDistribution
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import TestDistributionModel, TestDistributionResultModel


class TestDistribution(UnivariateComputation):
    def __init__(self, column: str, distribution: FittedDistribution):
        super(TestDistribution, self).__init__(column)
        self.distribution = distribution

    @staticmethod
    def get_type() -> Literal["test_distribution"]:
        return "test_distribution"

    @staticmethod
    def build(params: TestDistributionModel) -> 'TestDistribution':
        return TestDistribution(params['column'], FittedDistribution.build(params['distribution']))

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> TestDistributionResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()

        return {
            "type": self.get_type(),
            "test": self.distribution.test(series),
            "plot": self.distribution.plot(series)
        }
