from .artifact import Artifact
from .blueprint import Blueprint
from .blueprint_version import BlueprintVersion

class EnrichedArtifact:
    def __init__(self, json):
        """
        Instantiate a new enriched artifact.

        :param str json: A Python dict contained the artifact data.
            This class is actually mostly a wrapper around that json dict.
        """
        self.json = json

    @property
    def blueprint(self):
        """
        Return the blueprint of this artifact.

        :return: the :class:`govern.models.Blueprint` referenced by this enriched artifact
        """
        return Blueprint(self.json['blueprint'])

    @property
    def blueprintVersion(self):
        """
        Return the blueprint version of this artifact.

        :return: the :class:`govern.models.BlueprintVersion` referenced by this enriched artifact
        """
        return BlueprintVersion(self.json['blueprintVersion'])

    @property
    def artifact(self):
        """
        Return the underlying artifact.

        :return: the underlying :class:`govern.models.Artifact` referenced by this enriched artifact
        """
        return Artifact(self.json['artifact'])
    