import dataiku
from dataiku.llm.python import BaseLLM


class MyLLM(BaseLLM):
    def process(self, query, settings, trace):
        prompt = query["messages"][-1]["content"]
        with trace.subspan("Calling an LLM") as subspan:
            llm = dataiku.api_client().get_default_project().get_llm("openai:YOUR_OPENAI_CONNECTION_NAME:gpt-4o-mini")
            resp = llm.new_completion().with_message(prompt).execute()
            subspan.append_trace(resp.trace)
            subspan.attributes["custom_attribute"] = "value"
        return {"text": resp.text}
