import dataiku
import mlflow

client = dataiku.api_client()
project = client.get_project(dataiku.default_project_key())

# Setup mlflow integration, storing artefacts in managed folder. Managed folder must already exist.
mlflow_handle = project.setup_mlflow('A_MANAGED_FOLDER_ID')

# MLflow run and experiment will be sent to DSS backend.
mlflow.set_experiment("my_experiment")

with mlflow.start_run(run_name="my_run"):
    # ...your MLflow code...
    mlflow.log_param("a", 1)
    mlflow.log_metric("b", 2)

mlflow_handle.clear()
