<!-- html:true -->
<html lang="en">
<head>
    <meta charset="utf-8"> <!-- utf-8 works for most cases -->
    <meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
    <title>Welcome to Dataiku</title> <!-- the <title> tag shows on email notifications on Android 4.4. -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap');
    </style>
    <style type="text/css">
        /* ensure that clients don't add any padding or spaces around the email design and allow us to style emails for the entire width of the preview pane */
        body,
        #bodyTable {
            height: 100% !important;
            width: 100% !important;
            margin: 0;
            padding: 0;
            font-family: "Source Sans 3", Arial, sans-serif;
            background-color: #e0f7f6;
        }

        /* Ensures Webkit- and Windows-based clients don't automatically resize the email text. */
        body,
        table,
        td,
        p,
        a,
        li,
        blockquote {
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%;
        }

        /* Resolves webkit padding issue. */
        table {
            border-spacing: 0;
        }

        /* Resolves the Outlook 2007, 2010, and Gmail td padding issue, and removes spacing around tables that Outlook adds. */
        table,
        td {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        /* Corrects the way Internet Explorer renders resized images in emails. */
        img {
            -ms-interpolation-mode: bicubic;
        }

        /* Ensures images don't have borders or text-decorations applied to them by default. */
        img,
        a img {
            border: 0;
            outline: none;
            text-decoration: none;
        }

        /* Styles Yahoo's auto-sensing link color and border */
        .yshortcuts a {
            border-bottom: none !important;
        }

        /* Apple Mail doesn't support max-width, so we use media queries to constrain the email container width. */
        @media only screen and (min-width: 801px) {
            .email-container {
                width: 800px !important;
            }
        }

        /* Custom styles for content */
        ul {
            line-height: 1.6;
        }

        a {
            color: #00B2A9;
        }

        .logo-header {
            text-align: left;
            margin-bottom: 20px;
        }

        .logo {
            max-width: 120px;
            margin-bottom: 4px;
        }

        .banner {
            width: 100%;
            max-width: 550px;
            margin: 8px auto;
            display: block;
        }

        .container {
            background-color: #ffffff;
            padding: 16px 32px 24px 32px;
            border: 1px solid #00B2A9;
            border-radius: 8px;
        }

        .content {
            color: #333333;
            line-height: 1.5;
        }

        .button {
            display: inline-block;
            margin-top: 4px;
            margin-bottom: 12px;
            padding: 12px 20px;
            text-decoration: none;
            border-radius: 32px;
            font-weight: 500;
        }

        .btn-primary {
            background-color: #00B2A9;
            color: #ffffff;
        }

        .btn-secondary {
            background-color: #ffffff;
            color: #00B2A9;
            border: 1px solid #00B2A9;
        }

        .footer {
            text-align: center;
            color: #888888;
            font-size: 12px;
            padding: 40px 0;
        }
    </style>
</head>

<table id="bodyTable" border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
        <td align="center" valign="top">
            <!-- Email wrapper -->
            <table align="center" border="0" cellpadding="0" cellspacing="0" class="email-container"
                   style="max-width: 600px;">
                <tr>
                    <td height="20" style="font-size: 0; line-height: 0;">&nbsp;</td>
                </tr>
                <tr>
                    <td>
                        <!-- Logo -->
                        <div class="logo-header">
                            <a href="https://www.dataiku.com?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25">
                                <img src="https://dku-assets.s3.amazonaws.com/img/emailing/DataikuLogoTeal_2025.png" alt="Dataiku Logo" class="logo">
                            </a>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <!-- Content Box -->
                        <div class="container">
                            <div class="content">
                                <img src="https://dku-assets.s3.amazonaws.com/img/emailing/EmailBanner.png" class="banner" alt="Banner">
                                <h1>Welcome to ${productLongName}</h1>
                                <p>We’re happy you’re here. ${productLongName} is your go-to platform to transform the way you work with data.</p>
                                <!-- Primary button -->
                                <#if studioExternalUrl??>
                                    <a href="${studioExternalUrl}" class="button btn-primary" style="color: white">Your ${productLongName} Instance</a>
                                    <br>
                                </#if>
                                <h3>Getting started with ${productLongName}</h3>
                                <ul>
                                    <li>
                                        <a href="https://content.dataiku.com/welcome-to-dataiku-demos?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Start with a quick demo:</a> Get an overview of ${productLongName} in
                                        3-minutes
                                    </li>
                                    <li>
                                        <a href="https://content.dataiku.com/dataiku-launch-program/work-on-your-project?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Dataiku Launch Program:</a> Click through for an overview
                                        of key ${productLongName} features - 5 minutes top
                                    </li>
                                    <li>
                                        <a href="https://academy.dataiku.com/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Learn Dataiku with the Academy:</a> Start learning with a
                                        30-minute quick start guide and get fully certified
                                    </li>
                                </ul>
                                <h3>Your first project with a ready-to-use solution</h3>
                                <p>You don't need to start from scratch! Explore pre-built industry solutions and
                                    tutorials - you can find them in your instance or in the public gallery.</p>
                                <!-- Secondary button -->
                                <a href="https://gallery.dataiku.com/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                   class="button btn-secondary" style="color: #00B2A9">Explore the gallery</a>
                                <br>
                                <h3>Your ${productLongName} user resources</h3>
                                <ul>
                                    <li>
                                        <a href="https://pages.dataiku.com/dataiku-user-network?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Dataiku User Network:</a>
                                        Register for product tips, customer stories
                                        and local user event invitations
                                    </li>
                                    <li>
                                        <a href="https://knowledge.dataiku.com/latest/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Dataiku Knowledge Base:</a>
                                        Search to find articles to
                                        guide you through ${productLongName}</li>
                                    <li>
                                        <a href="https://community.dataiku.com/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Dataiku Community:</a>
                                        Ask questions about the product or search
                                        community answers
                                    </li>
                                    <li>
                                        <a href="https://developer.dataiku.com/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                           style="color: #00B2A9 !important;">Developer Guide:</a>
                                        Coding in ${productLongName}? Discover developer
                                        tutorials, learn how to create applications and use the Dataiku API
                                    </li>
                                </ul>
                                <br>
                                <p>Bookmark these links to help you throughout your journey with ${productLongName}! If you have any questions, you can reply to
                                    this email or post on the
                                    <a href="https://community.dataiku.com/?utm_source=product&utm_medium=email&utm_geo=GLO&utm_campaign=GLO%20Product%20Customer%20User%20Onboarding%20Q1FY25"
                                       style="color: #00B2A9 !important;"
                                    >
                                        Dataiku Community
                                    </a>.
                                </p>
                            </div>
                        </div>
                    </td>
                </tr>
                <!-- Footer : BEGIN -->
                <tr>
                    <td class="footer">
                        &copy; ${currentYear} Dataiku | All rights reserved.<br>902 Broadway, New York City, New York 10010,
                        United States
                    </td>
                </tr>
                <tr>
                    <td>
                        <div style="width: fit-content; margin: auto; padding-bottom: 20px;">
                            <a href="https://www.facebook.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/facebook.png" /></a>
                            <a href="https://www.linkedin.com/company/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/linkedin.png" /></a>
                            <a href="https://twitter.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/twitter.png" /></a>
                            <a href="https://www.instagram.com/dataiku" ><img style="padding: 10px" src="https://dku-assets.s3.amazonaws.com/img/emailing/icons/instagram.png" /></a>
                        </div>
                    </td>
                </tr>
                <!-- Footer : END -->
            </table>
        </td>
    </tr>
</table>

</html>