function bkdl_load_env_files() {
    if (Test-Path("$BINDIR/env-hadoop.ps1")) {
        & $BINDIR/env-hadoop.ps1
    }
    
    if (Test-Path("$BINDIR/env-spark.ps1")) {
        & $BINDIR/env-spark.ps1
    }
    
    if (Test-Path("$BINDIR/env-site.ps1")) {
        & $BINDIR/env-site.ps1
    }
}

function bkdl_get_cp() {
    # Load our log4j.properties first so that it does not get overriden by Hadoop,
    # and first the user's one
    $_CP="$env:DIP_HOME/bin"
    $_CP+=";$env:DKUINSTALLDIR/dist"
    # Load our code
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-core.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-scoring.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-dss-core.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-hproxy-client.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-app-platform.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-prepare-core.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-dip.jar"
    $_CP+=";$env:DKUINSTALLDIR/dist/dataiku-server.jar"
    # Load our dependencies
    $_CP+=";$env:DKUINSTALLDIR/lib/ivy/backend-run/*"
    $_CP+=";$env:DKUINSTALLDIR/lib/ivy/common-run/*"
    $_CP+=";$env:DKUINSTALLDIR/lib/shadelib/*"
    $_CP+=";$env:DKUINSTALLDIR/lib/third/*"
    # Load JDBC drivers
    $_CP+=";$env:DIP_HOME/lib/jdbc/*"
    # And other uvser-provided code
    $_CP+=";$env:DIP_HOME/lib/java/*"
    
    $_CP+=$(bkdl_get_plugins_cp)

    Write-Output "$_CP"
}

function bkdl_get_plugins_cp() {
    $PCP=""

    if (Test-Path -Path "$env:DIP_HOME/plugins/installed") {
        Get-ChildItem "$env:DIP_HOME/plugins/installed" |
        Foreach-Object {
            if (Test-Path -Path "$env:DIP_HOME/plugins/installed/$($_.Name)/plugin.json") {
                $PCP+=";$env:DIP_HOME/plugins/installed/$($_.Name)/lib/*"
            }
        }
    }

    if (Test-Path -Path "$env:DIP_HOME/plugins/dev") {
        Get-ChildItem "$env:DIP_HOME/plugins/dev" |
        Foreach-Object {
            if (Test-Path -Path "$env:DIP_HOME/plugins/dev/$($_.Name)/plugin.json") {
                $PCP+=";$env:DIP_HOME/plugins/dev/$($_.Name)/lib/*"
            }
        }
    }

    return $PCP
}

function apinode_get_cp() {
	# Load our log4j.properties first so that it does not get overriden
	# and first the user's one
	$_CP="$env:DIP_HOME/bin"
	$_CP+=";$env:DKUINSTALLDIR/dist"
	# Load our code
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-core.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-scoring.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-dss-core.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-hproxy-client.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-app-platform.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-prepare-core.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-dip.jar"
	$_CP+=";$env:DKUINSTALLDIR/dist/dataiku-lambda-server.jar"
	# Load our dependencies
	$_CP+=";$env:DKUINSTALLDIR/lib/ivy/backend-run/*"
	$_CP+=";$env:DKUINSTALLDIR/lib/ivy/common-run/*"
	$_CP+=";$env:DKUINSTALLDIR/lib/shadelib/*"
	$_CP+=";$env:DKUINSTALLDIR/lib/third/*"
	# Load JDBC drivers
	$_CP+=";$env:DIP_HOME/lib/jdbc/*"
	# And other user-provided code
	$_CP+=";$env:DIP_HOME/lib/java/*"

	return $_CP
}

function bkdl_set_py_env() {
    $env:DKUPYTHONBIN="$env:DIP_HOME/pyenv/Scripts/python.exe"
}

function bkdl_set_R_env() {
    if ($env:DKURBIN) {
        Write-Host "DKURBIN set to '$env:DKURBIN'"
    } elseif (Get-Command "R.exe" -errorAction SilentlyContinue) {
        $env:DKURBIN=(Get-Command "R.exe").Source
    } else {
        return
    }

    $env:DKURLIB="$env:DIP_HOME/R.lib"
    $env:R_LIBS="$env:DKURLIB;$env:DKUINSTALLDIR/R"
}
function bkdl_set_R_libs() {
    if ($null -ne $env:DKURBIN -and $null -eq $env:DKU_RLIBS_SET) {
        # We only support R 4.X on Windows
        $DKURLIBDIR = "$env:DKUINSTALLDIR/R/4.x"

        if ($null -eq $env:R_LIBS) {
            $env:R_LIBS = "$env:DKURLIB;$DKURLIBDIR"
        }
        else {
            $env:R_LIBS = "$env:DKURLIB;${DKURLIBDIR};$env:R_LIBS"
        }

        $env:DKU_RLIBS_SET = "1"
    }
}

function bkdl_env_sanity_check() {
    if ($env:DKU_NOPROXY_SET -eq "") {       
        if ($env:NO_PROXY -eq "") {
            $env:NO_PROXY = "127.0.0.1,localhost"
        } else {
            $env:NO_PROXY = "127.0.0.1,localhost,$env:NO_PROXY"
        }
        $env:DKU_NOPROXY_SET = 1
    }
}