/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Luhncheck$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str ) - Checks that a string of digits is valid according to the Luhn algorithm.\n    This checksum function is widely applied on credit card numbers and government identification\n    numbers to distinguish valid numbers from mistyped, incorrect numbers.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('8112189876');\n       true\n      > SELECT _FUNC_('79927398713');\n       true\n      > SELECT _FUNC_('79927398714');\n       false\n  ", since="3.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u000f\u0001\u0003\u0016\u0004%\ta\u000f\u0005\ty\u0001\u0011\t\u0012)A\u0005O!)Q\b\u0001C\u0001}!A\u0011\t\u0001EC\u0002\u0013\u00053\bC\u0003C\u0001\u0011\u00053\tC\u0003W\u0001\u0011\u0005s\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003d\u0001\u0011EC\rC\u0004k\u0001\u0005\u0005I\u0011A6\t\u000f5\u0004\u0011\u0013!C\u0001]\"9\u0011\u0010AA\u0001\n\u0003R\b\"CA\u0003\u0001\u0005\u0005I\u0011AA\u0004\u0011%\ty\u0001AA\u0001\n\u0003\t\t\u0002C\u0005\u0002\u001e\u0001\t\t\u0011\"\u0011\u0002 !I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003w9\u0011\"a\u0018\u001a\u0003\u0003E\t!!\u0019\u0007\u0011aI\u0012\u0011!E\u0001\u0003GBa!\u0010\n\u0005\u0002\u0005E\u0004\"CA:%\u0005\u0005IQIA;\u0011%\t9HEA\u0001\n\u0003\u000bI\bC\u0005\u0002~I\t\t\u0011\"!\u0002\u0000!I\u00111\u0012\n\u0002\u0002\u0013%\u0011Q\u0012\u0002\n\u0019VDgn\u00195fG.T!AG\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00039u\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0007\u0001\u001dZc&M\u001c\u0011\u0005!JS\"A\r\n\u0005)J\"AC#yaJ,7o]5p]B\u0011\u0001\u0006L\u0005\u0003[e\u0011!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011\u0001fL\u0005\u0003ae\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\b!J|G-^2u!\t\u0011\u0004(\u0003\u0002:g\ta1+\u001a:jC2L'0\u00192mK\u0006)\u0011N\u001c9viV\tq%\u0001\u0004j]B,H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0002\u0005C\u0001\u0015\u0001\u0011\u0015Q4\u00011\u0001(\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001E!\r)U\n\u0015\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014B\u0001'4\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002MgA\u0011\u0011\u000bV\u0007\u0002%*\u00111+H\u0001\u0006if\u0004Xm]\u0005\u0003+J\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001Y!\tIVL\u0004\u0002[7B\u0011qiM\u0005\u00039N\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011AlM\u0001\tG\"LG\u000e\u001a:f]V\t!\rE\u0002F\u001b\u001e\nqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0005\u001d*\u0007\"\u00024\t\u0001\u00049\u0017a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u00042!\u00125(\u0013\tIwJ\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR\u0011q\b\u001c\u0005\bu%\u0001\n\u00111\u0001(\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001c\u0016\u0003OA\\\u0013!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Y\u001c\u0014AC1o]>$\u0018\r^5p]&\u0011\u0001p\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\tqV0\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\nA\u0019!'a\u0003\n\u0007\u000551GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u001a\u0002\u0016%\u0019\u0011qC\u001a\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001c5\t\t\u00111\u0001\u0002\n\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\t\u0011\r\u0005\r\u0012\u0011FA\n\u001b\t\t)CC\u0002\u0002(M\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY#!\n\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\t9\u0004E\u00023\u0003gI1!!\u000e4\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0007\u0010\u0003\u0003\u0005\r!a\u0005\u0002\r\u0015\fX/\u00197t)\u0011\t\t$!\u0010\t\u0013\u0005m\u0001#!AA\u0002\u0005M\u0001f\u0005\u0001\u0002B\u0005\u001d\u0013\u0011JA'\u0003\u001f\n\u0019&!\u0016\u0002Z\u0005m\u0003c\u0001\u0015\u0002D%\u0019\u0011QI\r\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111J\u0001\u0003\u001a)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJ\u0004\u0013\u0006I\u0017!\u0007\",7m[:!i\"\fG\u000fI1!gR\u0014\u0018N\\4!_\u001a\u0004C-[4jiN\u0004\u0013n\u001d\u0011wC2LG\rI1dG>\u0014H-\u001b8hAQ|\u0007\u0005\u001e5fA1+\bN\u001c\u0011bY\u001e|'/\u001b;i[:R\u0001\u0005\t\u0011!)\"L7\u000fI2iK\u000e\\7/^7!MVt7\r^5p]\u0002J7\u000fI<jI\u0016d\u0017\u0010I1qa2LW\r\u001a\u0011p]\u0002\u001a'/\u001a3ji\u0002\u001a\u0017M\u001d3!]Vl'-\u001a:tA\u0005tG\rI4pm\u0016\u0014h.\\3oi\u0002JG-\u001a8uS\u001aL7-\u0019;j_:T\u0001\u0005\t\u0011!]Vl'-\u001a:tAQ|\u0007\u0005Z5ti&tw-^5tQ\u00022\u0018\r\\5eA9,XNY3sg\u00022'o\\7![&\u001cH/\u001f9fI2\u0002\u0013N\\2peJ,7\r\u001e\u0011ok6\u0014WM]:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0013!a\u0014\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0014'\r\u001a2qeBtGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"(/^3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d:\u0014(\u000f\u001a8geBt'M\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":s'O\u001d3oMJ\u0004hN\u00195O%Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003/\nQa\r\u00186]A\nQa\u001a:pkB\f#!!\u0018\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u00131+\bN\\2iK\u000e\\\u0007C\u0001\u0015\u0013'\u0011\u0011\u0012QM\u001c\u0011\r\u0005\u001d\u0014QN\u0014@\u001b\t\tIGC\u0002\u0002lM\nqA];oi&lW-\u0003\u0003\u0002p\u0005%$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011M\u0001\ti>\u001cFO]5oOR\t10A\u0003baBd\u0017\u0010F\u0002@\u0003wBQAO\u000bA\u0002\u001d\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0002\u0006\u001d\u0005\u0003\u0002\u001a\u0002\u0004\u001eJ1!!\"4\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\u0012\f\u0002\u0002\u0003\u0007q(A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0012\t\u0004y\u0006E\u0015bAAJ{\n1qJ\u00196fGR\u0004")
public class Luhncheck
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Expression> unapply(Luhncheck luhncheck) {
        return Luhncheck$.MODULE$.unapply(luhncheck);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Luhncheck, A> function1) {
        return Luhncheck$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Luhncheck> compose(Function1<A, Expression> function1) {
        return Luhncheck$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Luhncheck luhncheck = this;
        synchronized (luhncheck) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    private Expression replacement$lzycompute() {
        Luhncheck luhncheck = this;
        synchronized (luhncheck) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, (DataType)BooleanType$.MODULE$, "isLuhnNumber", (Seq<Expression>)((Seq)new .colon.colon((Object)this.input(), (List)Nil$.MODULE$)), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "luhn_check";
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.input(), (List)Nil$.MODULE$);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0));
    }

    public Luhncheck copy(Expression input) {
        return new Luhncheck(input);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    @Override
    public String productPrefix() {
        return "Luhncheck";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Luhncheck;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Luhncheck)) return false;
        boolean bl = true;
        if (!bl) return false;
        Luhncheck luhncheck = (Luhncheck)x$1;
        Expression expression = this.input();
        Expression expression2 = luhncheck.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!luhncheck.canEqual(this)) return false;
        return true;
    }

    public Luhncheck(Expression input) {
        this.input = input;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

