/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType;
import org.apache.spark.sql.catalyst.types.PhysicalByteType;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType;
import org.apache.spark.sql.catalyst.types.PhysicalShortType;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.UserDefinedType;

public final class SpecializedGettersReader {
    private SpecializedGettersReader() {
    }

    public static Object read(SpecializedGetters obj, int ordinal, DataType dataType, boolean handleNull, boolean handleUserDefinedType) {
        PhysicalDataType physicalDataType = PhysicalDataType.apply(dataType);
        if (handleNull && (obj.isNullAt(ordinal) || physicalDataType instanceof PhysicalNullType)) {
            return null;
        }
        if (physicalDataType instanceof PhysicalBooleanType) {
            return obj.getBoolean(ordinal);
        }
        if (physicalDataType instanceof PhysicalByteType) {
            return obj.getByte(ordinal);
        }
        if (physicalDataType instanceof PhysicalShortType) {
            return obj.getShort(ordinal);
        }
        if (physicalDataType instanceof PhysicalIntegerType) {
            return obj.getInt(ordinal);
        }
        if (physicalDataType instanceof PhysicalLongType) {
            return obj.getLong(ordinal);
        }
        if (physicalDataType instanceof PhysicalFloatType) {
            return Float.valueOf(obj.getFloat(ordinal));
        }
        if (physicalDataType instanceof PhysicalDoubleType) {
            return obj.getDouble(ordinal);
        }
        if (physicalDataType instanceof PhysicalStringType) {
            return obj.getUTF8String(ordinal);
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            PhysicalDecimalType dt = (PhysicalDecimalType)physicalDataType;
            return obj.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (physicalDataType instanceof PhysicalCalendarIntervalType) {
            return obj.getInterval(ordinal);
        }
        if (physicalDataType instanceof PhysicalBinaryType) {
            return obj.getBinary(ordinal);
        }
        if (physicalDataType instanceof PhysicalStructType) {
            return obj.getStruct(ordinal, ((PhysicalStructType)physicalDataType).fields().length);
        }
        if (physicalDataType instanceof PhysicalArrayType) {
            return obj.getArray(ordinal);
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return obj.getMap(ordinal);
        }
        if (handleUserDefinedType && dataType instanceof UserDefinedType) {
            return obj.get(ordinal, ((UserDefinedType)dataType).sqlType());
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataType.simpleString());
    }
}

