/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.CompressionType;
import com.amazonaws.services.glue.model.GlueSchema;
import com.amazonaws.services.glue.model.S3DirectSourceAdditionalOptions;
import com.amazonaws.services.glue.model.transform.S3JsonSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3JsonSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> paths;
    private String compressionType;
    private List<String> exclusions;
    private String groupSize;
    private String groupFiles;
    private Boolean recurse;
    private Integer maxBand;
    private Integer maxFilesInBand;
    private S3DirectSourceAdditionalOptions additionalOptions;
    private String jsonPath;
    private Boolean multiline;
    private List<GlueSchema> outputSchemas;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3JsonSource withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Collection<String> paths) {
        if (paths == null) {
            this.paths = null;
            return;
        }
        this.paths = new ArrayList<String>(paths);
    }

    public S3JsonSource withPaths(String ... paths) {
        if (this.paths == null) {
            this.setPaths(new ArrayList<String>(paths.length));
        }
        for (String ele : paths) {
            this.paths.add(ele);
        }
        return this;
    }

    public S3JsonSource withPaths(Collection<String> paths) {
        this.setPaths(paths);
        return this;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public S3JsonSource withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public S3JsonSource withCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType.toString();
        return this;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<String> exclusions) {
        if (exclusions == null) {
            this.exclusions = null;
            return;
        }
        this.exclusions = new ArrayList<String>(exclusions);
    }

    public S3JsonSource withExclusions(String ... exclusions) {
        if (this.exclusions == null) {
            this.setExclusions(new ArrayList<String>(exclusions.length));
        }
        for (String ele : exclusions) {
            this.exclusions.add(ele);
        }
        return this;
    }

    public S3JsonSource withExclusions(Collection<String> exclusions) {
        this.setExclusions(exclusions);
        return this;
    }

    public void setGroupSize(String groupSize) {
        this.groupSize = groupSize;
    }

    public String getGroupSize() {
        return this.groupSize;
    }

    public S3JsonSource withGroupSize(String groupSize) {
        this.setGroupSize(groupSize);
        return this;
    }

    public void setGroupFiles(String groupFiles) {
        this.groupFiles = groupFiles;
    }

    public String getGroupFiles() {
        return this.groupFiles;
    }

    public S3JsonSource withGroupFiles(String groupFiles) {
        this.setGroupFiles(groupFiles);
        return this;
    }

    public void setRecurse(Boolean recurse) {
        this.recurse = recurse;
    }

    public Boolean getRecurse() {
        return this.recurse;
    }

    public S3JsonSource withRecurse(Boolean recurse) {
        this.setRecurse(recurse);
        return this;
    }

    public Boolean isRecurse() {
        return this.recurse;
    }

    public void setMaxBand(Integer maxBand) {
        this.maxBand = maxBand;
    }

    public Integer getMaxBand() {
        return this.maxBand;
    }

    public S3JsonSource withMaxBand(Integer maxBand) {
        this.setMaxBand(maxBand);
        return this;
    }

    public void setMaxFilesInBand(Integer maxFilesInBand) {
        this.maxFilesInBand = maxFilesInBand;
    }

    public Integer getMaxFilesInBand() {
        return this.maxFilesInBand;
    }

    public S3JsonSource withMaxFilesInBand(Integer maxFilesInBand) {
        this.setMaxFilesInBand(maxFilesInBand);
        return this;
    }

    public void setAdditionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public S3DirectSourceAdditionalOptions getAdditionalOptions() {
        return this.additionalOptions;
    }

    public S3JsonSource withAdditionalOptions(S3DirectSourceAdditionalOptions additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public S3JsonSource withJsonPath(String jsonPath) {
        this.setJsonPath(jsonPath);
        return this;
    }

    public void setMultiline(Boolean multiline) {
        this.multiline = multiline;
    }

    public Boolean getMultiline() {
        return this.multiline;
    }

    public S3JsonSource withMultiline(Boolean multiline) {
        this.setMultiline(multiline);
        return this;
    }

    public Boolean isMultiline() {
        return this.multiline;
    }

    public List<GlueSchema> getOutputSchemas() {
        return this.outputSchemas;
    }

    public void setOutputSchemas(Collection<GlueSchema> outputSchemas) {
        if (outputSchemas == null) {
            this.outputSchemas = null;
            return;
        }
        this.outputSchemas = new ArrayList<GlueSchema>(outputSchemas);
    }

    public S3JsonSource withOutputSchemas(GlueSchema ... outputSchemas) {
        if (this.outputSchemas == null) {
            this.setOutputSchemas(new ArrayList<GlueSchema>(outputSchemas.length));
        }
        for (GlueSchema ele : outputSchemas) {
            this.outputSchemas.add(ele);
        }
        return this;
    }

    public S3JsonSource withOutputSchemas(Collection<GlueSchema> outputSchemas) {
        this.setOutputSchemas(outputSchemas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPaths() != null) {
            sb.append("Paths: ").append(this.getPaths()).append(",");
        }
        if (this.getCompressionType() != null) {
            sb.append("CompressionType: ").append(this.getCompressionType()).append(",");
        }
        if (this.getExclusions() != null) {
            sb.append("Exclusions: ").append(this.getExclusions()).append(",");
        }
        if (this.getGroupSize() != null) {
            sb.append("GroupSize: ").append(this.getGroupSize()).append(",");
        }
        if (this.getGroupFiles() != null) {
            sb.append("GroupFiles: ").append(this.getGroupFiles()).append(",");
        }
        if (this.getRecurse() != null) {
            sb.append("Recurse: ").append(this.getRecurse()).append(",");
        }
        if (this.getMaxBand() != null) {
            sb.append("MaxBand: ").append(this.getMaxBand()).append(",");
        }
        if (this.getMaxFilesInBand() != null) {
            sb.append("MaxFilesInBand: ").append(this.getMaxFilesInBand()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getJsonPath() != null) {
            sb.append("JsonPath: ").append(this.getJsonPath()).append(",");
        }
        if (this.getMultiline() != null) {
            sb.append("Multiline: ").append(this.getMultiline()).append(",");
        }
        if (this.getOutputSchemas() != null) {
            sb.append("OutputSchemas: ").append(this.getOutputSchemas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JsonSource)) {
            return false;
        }
        S3JsonSource other = (S3JsonSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPaths() == null ^ this.getPaths() == null) {
            return false;
        }
        if (other.getPaths() != null && !other.getPaths().equals(this.getPaths())) {
            return false;
        }
        if (other.getCompressionType() == null ^ this.getCompressionType() == null) {
            return false;
        }
        if (other.getCompressionType() != null && !other.getCompressionType().equals(this.getCompressionType())) {
            return false;
        }
        if (other.getExclusions() == null ^ this.getExclusions() == null) {
            return false;
        }
        if (other.getExclusions() != null && !other.getExclusions().equals(this.getExclusions())) {
            return false;
        }
        if (other.getGroupSize() == null ^ this.getGroupSize() == null) {
            return false;
        }
        if (other.getGroupSize() != null && !other.getGroupSize().equals(this.getGroupSize())) {
            return false;
        }
        if (other.getGroupFiles() == null ^ this.getGroupFiles() == null) {
            return false;
        }
        if (other.getGroupFiles() != null && !other.getGroupFiles().equals(this.getGroupFiles())) {
            return false;
        }
        if (other.getRecurse() == null ^ this.getRecurse() == null) {
            return false;
        }
        if (other.getRecurse() != null && !other.getRecurse().equals(this.getRecurse())) {
            return false;
        }
        if (other.getMaxBand() == null ^ this.getMaxBand() == null) {
            return false;
        }
        if (other.getMaxBand() != null && !other.getMaxBand().equals(this.getMaxBand())) {
            return false;
        }
        if (other.getMaxFilesInBand() == null ^ this.getMaxFilesInBand() == null) {
            return false;
        }
        if (other.getMaxFilesInBand() != null && !other.getMaxFilesInBand().equals(this.getMaxFilesInBand())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getJsonPath() == null ^ this.getJsonPath() == null) {
            return false;
        }
        if (other.getJsonPath() != null && !other.getJsonPath().equals(this.getJsonPath())) {
            return false;
        }
        if (other.getMultiline() == null ^ this.getMultiline() == null) {
            return false;
        }
        if (other.getMultiline() != null && !other.getMultiline().equals(this.getMultiline())) {
            return false;
        }
        if (other.getOutputSchemas() == null ^ this.getOutputSchemas() == null) {
            return false;
        }
        return other.getOutputSchemas() == null || other.getOutputSchemas().equals(this.getOutputSchemas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPaths() == null ? 0 : this.getPaths().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionType() == null ? 0 : this.getCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getExclusions() == null ? 0 : this.getExclusions().hashCode());
        hashCode = 31 * hashCode + (this.getGroupSize() == null ? 0 : this.getGroupSize().hashCode());
        hashCode = 31 * hashCode + (this.getGroupFiles() == null ? 0 : this.getGroupFiles().hashCode());
        hashCode = 31 * hashCode + (this.getRecurse() == null ? 0 : this.getRecurse().hashCode());
        hashCode = 31 * hashCode + (this.getMaxBand() == null ? 0 : this.getMaxBand().hashCode());
        hashCode = 31 * hashCode + (this.getMaxFilesInBand() == null ? 0 : this.getMaxFilesInBand().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getJsonPath() == null ? 0 : this.getJsonPath().hashCode());
        hashCode = 31 * hashCode + (this.getMultiline() == null ? 0 : this.getMultiline().hashCode());
        hashCode = 31 * hashCode + (this.getOutputSchemas() == null ? 0 : this.getOutputSchemas().hashCode());
        return hashCode;
    }

    public S3JsonSource clone() {
        try {
            return (S3JsonSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3JsonSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

