/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.KinesisStreamingSourceOptions;
import java.util.Date;

@SdkInternalApi
public class KinesisStreamingSourceOptionsMarshaller {
    private static final MarshallingInfo<String> ENDPOINTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointUrl").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").build();
    private static final MarshallingInfo<String> DELIMITER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delimiter").build();
    private static final MarshallingInfo<String> STARTINGPOSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingPosition").build();
    private static final MarshallingInfo<Long> MAXFETCHTIMEINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxFetchTimeInMs").build();
    private static final MarshallingInfo<Long> MAXFETCHRECORDSPERSHARD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxFetchRecordsPerShard").build();
    private static final MarshallingInfo<Long> MAXRECORDPERREAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRecordPerRead").build();
    private static final MarshallingInfo<Boolean> ADDIDLETIMEBETWEENREADS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddIdleTimeBetweenReads").build();
    private static final MarshallingInfo<Long> IDLETIMEBETWEENREADSINMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdleTimeBetweenReadsInMs").build();
    private static final MarshallingInfo<Long> DESCRIBESHARDINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DescribeShardInterval").build();
    private static final MarshallingInfo<Integer> NUMRETRIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumRetries").build();
    private static final MarshallingInfo<Long> RETRYINTERVALMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryIntervalMs").build();
    private static final MarshallingInfo<Long> MAXRETRYINTERVALMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxRetryIntervalMs").build();
    private static final MarshallingInfo<Boolean> AVOIDEMPTYBATCHES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvoidEmptyBatches").build();
    private static final MarshallingInfo<String> STREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamArn").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<String> ROLESESSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleSessionName").build();
    private static final MarshallingInfo<String> ADDRECORDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddRecordTimestamp").build();
    private static final MarshallingInfo<String> EMITCONSUMERLAGMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmitConsumerLagMetrics").build();
    private static final MarshallingInfo<Date> STARTINGTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingTimestamp").timestampFormat("iso8601").build();
    private static final KinesisStreamingSourceOptionsMarshaller instance = new KinesisStreamingSourceOptionsMarshaller();

    public static KinesisStreamingSourceOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(KinesisStreamingSourceOptions kinesisStreamingSourceOptions, ProtocolMarshaller protocolMarshaller) {
        if (kinesisStreamingSourceOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getEndpointUrl(), ENDPOINTURL_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getStreamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getClassification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getDelimiter(), DELIMITER_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getStartingPosition(), STARTINGPOSITION_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getMaxFetchTimeInMs(), MAXFETCHTIMEINMS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getMaxFetchRecordsPerShard(), MAXFETCHRECORDSPERSHARD_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getMaxRecordPerRead(), MAXRECORDPERREAD_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getAddIdleTimeBetweenReads(), ADDIDLETIMEBETWEENREADS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getIdleTimeBetweenReadsInMs(), IDLETIMEBETWEENREADSINMS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getDescribeShardInterval(), DESCRIBESHARDINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getNumRetries(), NUMRETRIES_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getRetryIntervalMs(), RETRYINTERVALMS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getMaxRetryIntervalMs(), MAXRETRYINTERVALMS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getAvoidEmptyBatches(), AVOIDEMPTYBATCHES_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getStreamArn(), STREAMARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getRoleSessionName(), ROLESESSIONNAME_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getAddRecordTimestamp(), ADDRECORDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getEmitConsumerLagMetrics(), EMITCONSUMERLAGMETRICS_BINDING);
            protocolMarshaller.marshall((Object)kinesisStreamingSourceOptions.getStartingTimestamp(), STARTINGTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

