/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.IAuditTrailTargetFactory;
import com.dataiku.dip.security.audit.model.AuditTrailSettings;
import com.dataiku.dip.security.audit.model.AuditTrailTargetSettings;
import com.dataiku.dip.security.audit.targets.AuditTarget;
import com.dataiku.dip.security.audit.targets.EventServerTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AuditDispatcher {
    private AuditTrailSettings settings;
    private List<AuditTarget> targets = new ArrayList<AuditTarget>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auditmechanism.dispatcher");

    public AuditDispatcher(AuditTrailSettings settings) throws IOException, DKUSecurityException {
        this.reconfigure(settings);
    }

    public synchronized void reconfigure(AuditTrailSettings newSettings) throws IOException, DKUSecurityException {
        logger.info((Object)("Configuring audit dispatcher: " + JSON.json((Object)newSettings)));
        for (AuditTarget target : this.targets) {
            try {
                logger.info((Object)("Stopping previous target: " + String.valueOf(target)));
                target.shutdown();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to properly shutdown previous target", (Throwable)e);
            }
        }
        this.targets.clear();
        for (AuditTrailTargetSettings atts : newSettings.targets) {
            try {
                this.targets.add(SpringUtils.getBean(IAuditTrailTargetFactory.class).build(atts));
            }
            catch (Exception exc) {
                logger.error((Object)("Fail to add target settings " + atts.getClass().getName()), (Throwable)exc);
            }
        }
        this.settings = newSettings;
    }

    public synchronized void dispatch(AuditObj obj) {
        String objRoutingKey;
        if (logger.isTraceEnabled()) {
            logger.traceV("Dispatching obj t=%s rk=%s data=%s", new Object[]{obj.topic, obj.routingKey, JSON.json((Object)obj.get())});
        }
        DSSMetrics.registry().meter("dku.audit.dispatcher.dispatchedMessages").mark();
        String objTopic = obj.topic;
        if (objTopic == null) {
            objTopic = "??UnknownTopic??";
        }
        if ((objRoutingKey = obj.routingKey) == null) {
            objRoutingKey = "__Routed_Nowhere__";
        }
        for (AuditTarget target : this.targets) {
            String nameForMetrics;
            AuditTrailTargetSettings ats = target.getSettings();
            if (ats.topicsFiltering != TopicsFiltering.ALL && !ats.topics.contains(objTopic) || ats.routingKeysFiltering != RoutingKeyFiltering.ALL && !ats.routingKeys.contains(objRoutingKey)) continue;
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Dispatching on " + String.valueOf(target)));
                }
                target.handle(obj);
            }
            catch (IllegalStateException e) {
                logger.warn((Object)("Failed dispatching audit message to " + String.valueOf(target) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                nameForMetrics = target instanceof EventServerTarget ? "eventserver" : target.getClass().getSimpleName();
                DSSMetrics.registry().meter("dku.audit.targets." + nameForMetrics + ".droppedMessages").mark();
            }
            catch (Exception e) {
                logger.warn((Object)("Failed dispatching audit message to " + String.valueOf(target)), (Throwable)e);
                nameForMetrics = target instanceof EventServerTarget ? "eventserver" : target.getClass().getSimpleName();
                DSSMetrics.registry().meter("dku.audit.targets." + nameForMetrics + ".droppedMessages").mark();
            }
        }
    }
}

