/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.transactions.git.CommitDef;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;

public abstract class SingleRepositoryGitManager
extends JGitManager {
    private Git git;

    public SingleRepositoryGitManager(File repositoryRoot) throws IOException {
        this.root = repositoryRoot;
        this.git = this.initRepository(repositoryRoot);
    }

    @Override
    public Git getGlobalGit() {
        return this.git;
    }

    @Override
    public JGitManager.SubGit getSubGit(String namespace) {
        return new JGitManager.SubGit(this.git, this.getPath(namespace));
    }

    @Override
    public void invalidateSubGit(String namespace) {
    }

    @Override
    public synchronized String commit(CommitDef def) throws IOException {
        String ret = def.changes != null ? this.basicCommitChanges(this.git, this.root, this.gitProtectedFiles, def.author, def.message, Lists.newArrayList(def.changes)) : this.basicCommitPatterns(this.git, this.gitProtectedFiles, def.author, def.message, def.filePatterns);
        return ret;
    }

    protected abstract String getPath(String var1);

    @Override
    public synchronized void close() {
        if (this.git != null) {
            this.git.close();
            this.git = null;
        }
    }

    public Git getGit() {
        return this.git;
    }
}

