/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DebounceExecutor {
    protected static final DKULogger logger = DKULogger.getLogger((String)DebounceExecutor.class.getCanonicalName());
    private String name;
    public int debounceDelay;
    boolean closed = false;
    private final List<DebounceAction> pendingActions = new ArrayList<DebounceAction>();

    public DebounceExecutor(String name, int debounceDelay) {
        this.name = name;
        this.debounceDelay = debounceDelay;
        new Thread(new DebounceActionRunner()).start();
    }

    public void addAction(String actionId, Runnable action) {
        this.addAction(actionId, action, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String actionId, Runnable action, boolean clearPending) {
        logger.debugV("Registering action %s for %s", new Object[]{actionId, this.name});
        DebounceExecutor debounceExecutor = this;
        synchronized (debounceExecutor) {
            this.checkOpen();
            if (clearPending) {
                logger.debugV("Dropped %d pending actions for %s", new Object[]{this.pendingActions.size(), this.name});
                this.pendingActions.clear();
            } else {
                ListIterator<DebounceAction> it = this.pendingActions.listIterator();
                while (it.hasNext()) {
                    DebounceAction pendingAction = it.next();
                    if (!pendingAction.id.equals(actionId)) continue;
                    it.remove();
                    logger.debugV("Dropped duplicate pending action %s with timestamp %d for %s", new Object[]{pendingAction.id, pendingAction.timestamp, this.name});
                }
            }
            this.pendingActions.add(new DebounceAction(actionId, action, System.currentTimeMillis()));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executePending() throws InterruptedException {
        ExecutePendingAction action = new ExecutePendingAction("ExecutePendingAction", System.currentTimeMillis());
        Object object = this;
        synchronized (object) {
            this.checkOpen();
            this.pendingActions.add(action);
            this.notifyAll();
        }
        logger.info((Object)"Waiting for ExecutePendingAction to be done.");
        object = action.lock;
        synchronized (object) {
            while (!action.done) {
                action.lock.wait();
            }
        }
        logger.info((Object)"ExecutePendingAction has finished.");
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException(String.format("DebounceExecutor %s has been closed", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        this.executePending();
        DebounceExecutor debounceExecutor = this;
        synchronized (debounceExecutor) {
            this.closed = true;
        }
    }

    public class DebounceActionRunner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(String.format("DebounceExecutorRunner-%s", DebounceExecutor.this.name));
            while (true) {
                ArrayList<DebounceAction> actionsToRun = new ArrayList<DebounceAction>();
                Object object = DebounceExecutor.this;
                synchronized (object) {
                    if (DebounceExecutor.this.closed) {
                        break;
                    }
                    long now = System.currentTimeMillis();
                    ListIterator<DebounceAction> it = DebounceExecutor.this.pendingActions.listIterator();
                    while (it.hasNext()) {
                        DebounceAction pendingAction = it.next();
                        if (!pendingAction.urgent && pendingAction.timestamp + (long)DebounceExecutor.this.debounceDelay > now) continue;
                        it.remove();
                        actionsToRun.add(pendingAction);
                    }
                }
                for (DebounceAction action : actionsToRun) {
                    logger.debugV("Running action %s", new Object[]{action.id, DebounceExecutor.this.name});
                    try {
                        action.runnable.run();
                    }
                    catch (Throwable e) {
                        logger.error((Object)String.format("Running action %s failed", action.id), e);
                    }
                }
                try {
                    object = DebounceExecutor.this;
                    synchronized (object) {
                        int nbUrgent = 0;
                        for (DebounceAction da : DebounceExecutor.this.pendingActions) {
                            if (!da.urgent) continue;
                            ++nbUrgent;
                        }
                        if (nbUrgent == 0) {
                            DebounceExecutor.this.wait(DebounceExecutor.this.debounceDelay);
                        } else {
                            logger.debugV("Not sleeping, there are %d urgent actions", new Object[]{nbUrgent});
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.debug((Object)"Debounce action runner thread interrupted while waiting", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    public static class DebounceAction {
        String id;
        Runnable runnable;
        long timestamp;
        boolean urgent = false;

        DebounceAction(String id, Runnable runnable, long timestamp) {
            this.id = id;
            this.runnable = runnable;
            this.timestamp = timestamp;
        }
    }

    public class ExecutePendingAction
    extends DebounceAction {
        public boolean done;
        public final Object lock;

        ExecutePendingAction(String id, long timestamp) {
            super(id, null, timestamp);
            this.done = false;
            this.lock = new Object();
            this.urgent = true;
            this.runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<DebounceAction> actionsToRun;
                    logger.info((Object)"Start running ExecutePendingAction");
                    Object object = DebounceExecutor.this;
                    synchronized (object) {
                        actionsToRun = new ArrayList<DebounceAction>(DebounceExecutor.this.pendingActions.size());
                        actionsToRun.addAll(DebounceExecutor.this.pendingActions);
                        DebounceExecutor.this.pendingActions.clear();
                    }
                    logger.infoV("Found %d pending action(s).", new Object[]{actionsToRun.size()});
                    for (DebounceAction action : actionsToRun) {
                        logger.debugV("Running action %s", new Object[]{action.id, DebounceExecutor.this.name});
                        action.runnable.run();
                    }
                    object = ExecutePendingAction.this.lock;
                    synchronized (object) {
                        ExecutePendingAction.this.done = true;
                        ExecutePendingAction.this.lock.notifyAll();
                    }
                    logger.info((Object)"End running ExecutePendingAction");
                }
            };
        }
    }
}

