/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

class TSMappedType
implements Comparable<TSMappedType> {
    String polyJsonType;
    boolean hasJavaSubclasses;
    String tsCustomType;
    List<TSMappedType> manualImports = new ArrayList<TSMappedType>();
    Type javaType;
    TSType tsType;
    RelFile tsDefinitionFileNoExt;
    boolean inspected;
    List<TSMappedType> typeParameters;
    TSMappedType rawJavaType;
    TSMappedType superclass;
    TSMappedType rawSuperclass;
    List<TSMappedType> implementedInterfaces = new ArrayList<TSMappedType>();
    boolean hasPolyJsonAnnotation;
    PolyClassMetadata polyJsonMeta;
    List<TSMappedType> polyJsonSubclasses;
    String tsName;
    List<String> tsNamespaces = new ArrayList<String>();
    List<MappedField> typeFields;
    List<MappedField> uiDataFields;
    List<TSMappedType> subclasses = new ArrayList<TSMappedType>();
    ForeignMapping foreignMapping;
    boolean addToIndex = true;
    boolean generateUnion = false;
    String problem;
    List<MappedEnumValue> enumValues;
    boolean concrete;
    @Nullable
    TSMappedType translatedVia;
    int translatedViaDepth;
    @Nullable
    String customExportedTsName;

    TSMappedType() {
    }

    PersistedTypeMeta getPersistedTypeMeta() {
        PersistedTypeMeta typeMeta = new PersistedTypeMeta();
        typeMeta.javaType = this.javaType.getTypeName();
        typeMeta.tsDefinitionFileNoExt = this.tsDefinitionFileNoExt.getFullPath();
        typeMeta.tsName = this.tsName;
        typeMeta.tsType = this.tsType;
        typeMeta.tsNamespaces = this.tsNamespaces;
        typeMeta.customExportedTsName = this.customExportedTsName;
        typeMeta.concreteSubclasses = this.subclasses.stream().filter(mt -> mt.concrete).map(mt -> mt.javaType).map(Type::getTypeName).collect(Collectors.toList());
        return typeMeta;
    }

    String explainTranslation() {
        if (this.translatedVia == null) {
            return "UIModel annotation in the class hierarchy";
        }
        if (this.translatedVia.tsType == TSType.ENUM || this.translatedVia.tsType == TSType.INTERFACE) {
            return this.translatedVia.javaType.getTypeName();
        }
        return this.translatedVia.explainTranslation();
    }

    void logTranslationIssue(String message) {
        System.out.println("[!] " + message + " (" + this.javaType.getTypeName() + ")");
        TSMappedType current = this.translatedVia;
        while (current != null) {
            String line = "[!]     <- " + current.javaType.getTypeName();
            if (current.polyJsonMeta != null && current.polyJsonMeta.getAnnotatedClass() != current.javaType) {
                line = line + " (" + String.valueOf(current.polyJsonMeta.getAnnotatedClass()) + ")";
            }
            System.out.println(line);
            current = current.translatedVia;
        }
    }

    Set<TSMappedType> listHierarchyRecursivelyIncludingSelf() {
        TreeSet<TSMappedType> out = new TreeSet<TSMappedType>();
        if (!this.subclasses.isEmpty()) {
            for (TSMappedType subclass : this.subclasses) {
                out.addAll(subclass.listHierarchyRecursivelyIncludingSelf());
            }
        }
        out.add(this);
        return out;
    }

    @Override
    public int compareTo(TSMappedType o) {
        Type t1 = this.javaType;
        Type t2 = o.javaType;
        return t1.toString().compareTo(t2.toString());
    }

    static class PersistedTypeMeta {
        List<String> concreteSubclasses;
        String javaType;
        List<String> tsNamespaces = new ArrayList<String>();
        String tsName;
        String tsDefinitionFileNoExt;
        TSType tsType;
        @Nullable
        String customExportedTsName;

        PersistedTypeMeta() {
        }
    }

    static enum TSType {
        INTERFACE,
        STRING,
        NUMBER,
        LIST,
        MAP,
        BOOLEAN,
        ANY,
        UNKNOWN,
        ENUM,
        PARAMETRIZED_TYPE,
        TYPE_VARIABLE,
        CUSTOM;

    }

    static class ForeignMapping {
        Map<String, PersistedTypeMeta> javaToTs;
        File sourceDirectory;
        String foreignModuleName;

        ForeignMapping() {
        }
    }

    static class MappedEnumValue {
        String name;
        String value;

        MappedEnumValue() {
        }
    }

    static class MappedField {
        String name;
        TSMappedType mt;
        boolean optional;
        String tsData;

        MappedField() {
        }
    }
}

