/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt.devserver;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.lambda.client.LambdaAdminAPIClient;
import com.dataiku.lambda.tools.LambdaHomeDevBootstrapper;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.directory.api.util.Strings;

public class LambdaDevServerKernel
extends DSSKernelBase
implements AlivenessCheckableAndClosable {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final String targetUnixUser;
    private final AutoDelete lambdaHome;
    private final LambdaDevServerFutureThread lambdaDevServerFutureThread;
    private final long createdTime;
    protected File tmpOutputFile;
    private String adminApiKey;
    private boolean manualStop = false;
    private KernelState state = KernelState.CREATED;
    private long lastAccessTime;
    private int usageCount = 0;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.kernels.lambdadev");

    public LambdaDevServerKernel(@Nonnull AuthCtx authCtx, @Nonnull String projectKey, String targetUnixUser) {
        super("lambda-dev-server");
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.targetUnixUser = targetUnixUser;
        this.lastAccessTime = this.createdTime = System.currentTimeMillis();
        this.lambdaHome = new AutoDelete(DSSTempUtils.getTempFileNoCreate((String)"lambda-dev-server", (String)(projectKey + "-" + authCtx.getIdentifier() + "-" + SecretKeyGenerator.generate((int)12))));
        this.lambdaDevServerFutureThread = new LambdaDevServerFutureThread((DSSAuthCtx)authCtx, this);
    }

    public synchronized boolean unusedAndExpired(int idleTimeout) {
        return this.usageCount == 0 && this.getTimeSinceLastAccessMs() >= (long)idleTimeout;
    }

    public synchronized boolean reachedAccessTimeout(int accessTimeout) {
        return this.getTimeSinceLastAccessMs() >= (long)accessTimeout;
    }

    public synchronized int getUsageCount() {
        return this.usageCount;
    }

    public synchronized KernelState getState() {
        return this.state;
    }

    public synchronized void setState(KernelState newState) {
        this.state = newState;
    }

    public LambdaDevServerFutureThread getLambdaDevServerFutureThread() {
        return this.lambdaDevServerFutureThread;
    }

    public boolean isStartingOrRunning() {
        KernelState currentState = this.getState();
        return Arrays.asList(KernelState.STARTING, KernelState.RUNNING).contains((Object)currentState);
    }

    public synchronized long getTimeSinceLastAccessMs() {
        return System.currentTimeMillis() - this.lastAccessTime;
    }

    public synchronized long getAliveTimeMs() {
        return System.currentTimeMillis() - this.createdTime;
    }

    public synchronized KernelHandle startUsing() {
        ++this.usageCount;
        this.lastAccessTime = System.currentTimeMillis();
        return new KernelHandle(this);
    }

    public synchronized void stopUsing() {
        --this.usageCount;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public SmartLogTail getLogTail() {
        if (this.tmpOutputFile != null) {
            try {
                return FlowJobUtils.getSmartLogTail((String)DKUtils.tailFile((File)this.tmpOutputFile, (int)500), null);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to retrieve log tail", (Throwable)e);
            }
        }
        return new SmartLogTail();
    }

    public LambdaDevServerClient getAPIClient(String apiKey) {
        if (apiKey == null) {
            apiKey = "_no_api_key_";
        }
        return new LambdaDevServerClient(apiKey, this.port);
    }

    public LambdaDevServerAdminClient getAdminAPIClient() {
        return new LambdaDevServerAdminClient(this.adminApiKey, this.port);
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (System.getenv("DSS_DEV") == null) {
            if (DKUtils.isOsWindows()) {
                args.add(System.getenv("DIP_HOME") + "/bin/dss.cmd");
            } else {
                args.add(System.getenv("DIP_HOME") + "/bin/dss");
            }
            args.add("run");
            args.add("apimain_dev");
        } else {
            String lambdaBin = System.getenv("DKULAMBDABIN");
            if (lambdaBin == null) {
                throw new Error("Dev mode: environment variable DKULAMBDABIN not defined");
            }
            args.add(lambdaBin);
        }
        this.port = DKUNetUtils.findUnusedPort();
        this.adminApiKey = SecretKeyGenerator.generate((int)32);
        try {
            LambdaHomeDevBootstrapper.bootstrap((File)this.lambdaHome, (String)this.adminApiKey, (AuthCtx)this.authCtx, (String)this.projectKey, (String)this.targetUnixUser);
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred when bootstrapping the dev lambda server home directory", (Throwable)e);
            throw new Exception("Error initializing the dev lambda server", e);
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().put("DKU_APIMAIN_PORT", "" + this.port);
        pb.environment().put("DKU_LAMBDA_HOME", this.lambdaHome.getAbsolutePath());
        pb.environment().put("DKU_LAMBDA_DEVSERVER", "1");
        pb.environment().put("DKU_LAMBDA_DEVSERVER_LOGIN", this.authCtx.getIdentifier());
        pb.environment().put("DKU_BACKEND_PORT", "");
        pb.environment().put("DKU_NODE_TYPE", "api");
        if (null != System.getenv("DEV_MODE")) {
            pb.environment().put("DEV_MODE", "true");
        }
        logger.infoV("Starting Lambda dev server listening on port %s, in directory %s%s", new Object[]{this.port, this.lambdaHome.getAbsolutePath(), Strings.isNotEmpty((String)this.targetUnixUser) ? ", using " + this.targetUnixUser + " to impersonate custom code kernels" : ""});
        this.process = new RegularProcess(pb, (File)this.lambdaHome, GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER, this.authCtx, this.projectKey);
        this.process.start();
        this.setState(KernelState.STARTING);
        this.tmpOutputFile = DKUFileUtils.getWithin((File)this.lambdaHome, (String[])new String[]{"apinode-devserver-log", "devserver.log"});
        DKUFileUtils.mkdirsParent((File)this.tmpOutputFile);
        FileOutputStream tmpOutputFileStream = new FileOutputStream(this.tmpOutputFile);
        this.startStandardTailers(tmpOutputFileStream, tmpOutputFileStream);
        this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
        this.monitorThread.start();
    }

    public void stop() {
        this.manualStop = true;
        this.close();
    }

    public void waitStartedFixedPort() throws Exception {
        int loops = 0;
        KernelHandle kernelHandle = this.startUsing();
        while (true) {
            ++loops;
            Thread.sleep(300L);
            KernelState kernelState = this.getState();
            if (KernelState.CREATED.equals((Object)kernelState)) {
                if (loops % 10 != 5) continue;
                logger.info((Object)"Lambda dev server is not started yet.");
                continue;
            }
            if (this.process == null || KernelState.STOPPED.equals((Object)kernelState)) {
                File errFile = new File((File)this.lambdaHome, "error.json");
                SerializedError startupError = null;
                if (errFile.isFile() && errFile.length() > 0L) {
                    try {
                        startupError = (SerializedError)JSON.parseFile((File)errFile, SerializedError.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String error = "Lambda process died before start" + (String)(startupError == null ? "" : ":\n" + startupError.detailedMessage);
                logger.error((Object)error);
                this.close();
                this.lambdaDevServerFutureThread.throwExceptionIfAny();
                throw new Exception(error, this.processExitException);
            }
            try {
                this.getAdminAPIClient().ping();
                this.setState(KernelState.RUNNING);
                logger.info((Object)"Lambda devserver is ready !");
                return;
            }
            catch (Exception e) {
                if (loops % 10 != 5) continue;
                logger.info((Object)("Lambda dev server is not yet ready." + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        finally {
            if (kernelHandle != null) {
                kernelHandle.close();
            }
        }
    }

    public boolean isAlive() {
        KernelState currentState = this.getState();
        if (KernelState.STOPPED.equals((Object)currentState)) {
            return false;
        }
        if (Arrays.asList(KernelState.CREATED, KernelState.STARTING).contains((Object)currentState)) {
            return true;
        }
        try {
            this.getAdminAPIClient().ping();
        }
        catch (Exception e) {
            logger.warn((Object)("Lambda dev server is not responding anymore. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (!this.killed) {
            this.killNoWaitNoException(this.manualStop);
        }
        if (this.lambdaHome != null) {
            this.lambdaHome.close();
        }
        this.setState(KernelState.STOPPED);
    }

    public static enum KernelState {
        STOPPED,
        CREATED,
        STARTING,
        RUNNING;

    }

    public static class LambdaDevServerFutureThread
    extends SimpleFutureThread<Void> {
        LambdaDevServerKernel kernel;

        public LambdaDevServerFutureThread(DSSAuthCtx authCtx, LambdaDevServerKernel kernel) {
            super((AuthCtx)authCtx);
            this.kernel = kernel;
        }

        public FuturePayload getPayload() {
            String impersonationDetails = Strings.isNotEmpty((String)this.kernel.targetUnixUser) ? ", using " + this.kernel.targetUnixUser + " to impersonate custom code kernels" : "";
            FuturePayload fp = FuturePayload.newSimple((String)"dev_lambda_server", (String)("Dev lambda server" + impersonationDetails));
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.kernel.projectKey, ITaggingService.TaggableType.PROJECT.name()));
            return fp;
        }

        protected Void compute() throws Exception {
            try (FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(() -> {
                if (null != this.kernel) {
                    logger.info((Object)"Dev lambda server aborted, cleaning up resources");
                    this.kernel.close();
                }
            });){
                try {
                    this.kernel.start();
                }
                catch (Exception e) {
                    this.kernel.setState(KernelState.STOPPED);
                    throw e;
                }
                this.kernel.waitForShutdown();
                Void void_ = null;
                return void_;
            }
        }
    }

    public static class KernelHandle
    implements AutoCloseable {
        LambdaDevServerKernel kernel;

        KernelHandle(LambdaDevServerKernel kernel) {
            this.kernel = kernel;
        }

        @Override
        public void close() {
            if (this.kernel != null) {
                this.kernel.stopUsing();
            }
        }
    }

    public static class LambdaDevServerClient {
        private final APIKeyAuthAPIClient apiClient;

        public LambdaDevServerClient(String apiKey, int port) {
            this.apiClient = new APIKeyAuthAPIClient("http://127.0.0.1:" + port, apiKey, false);
        }

        public InternalAPIClient.ResponseStringWithHeaders runTestQuery(String serviceId, String endpointId, String testCallName, JsonObject query) throws IOException {
            String path = String.format("/public/api/v1/%s/%s/%s", serviceId, endpointId, testCallName);
            return this.apiClient.postObjectToStringResponseAndHeaders(path, (Object)query);
        }
    }

    public static class LambdaDevServerAdminClient {
        private final LambdaAdminAPIClient apiClient;

        public LambdaDevServerAdminClient(String apiKey, int port) {
            this.apiClient = new LambdaAdminAPIClient("http://127.0.0.1:" + port, apiKey, false, null, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        }

        public void deleteServiceIfExists(String serviceId) throws IOException {
            List existingServices = this.apiClient.listServices();
            if (existingServices.stream().anyMatch(serviceSummaryState -> Objects.equals(serviceSummaryState.serviceId, serviceId))) {
                this.apiClient.deleteService(serviceId);
            }
        }

        public void createService(String serviceId) throws IOException {
            this.apiClient.createService(serviceId, false);
        }

        public void importGeneration(String serviceId, File packageDir) throws IOException {
            String importPath = "/admin/api/services/" + serviceId + "/generations/actions/importFromDirectory";
            this.apiClient.postFormToJSON(importPath, Void.class, new Object[]{"dirPath", packageDir.getAbsolutePath()});
        }

        public void switchToNewestGeneration(String serviceId) throws IOException {
            this.apiClient.switchToNewest(serviceId);
        }

        public void ping() throws Exception {
            this.apiClient.postObject("/public/api/v1/ping", 5000, Void.class, (Object)new JsonObject());
        }
    }
}

