/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/dashboards"})
public class PublicAPIDashboardController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private UsersService usersService;

    @AuditedCall(value={"msgType", "dashboards-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Dashboard.DashboardListItem> listDashboards(HttpServletRequest req, @PathVariable String projectKey) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
            ArrayList<Dashboard.DashboardListItem> result = new ArrayList<Dashboard.DashboardListItem>();
            for (Dashboard dashboard : this.dashboardsService.listDashboards(authCtx, projectKey)) {
                Dashboard.DashboardListItem listItem = new Dashboard.DashboardListItem(dashboard);
                listItem.hasMissingReaderAuthorizations = this.dashboardsService.hasMissingReaderAuthorizations(dashboard);
                UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(listItem.owner);
                listItem.ownerDisplayName = owner != null ? owner.displayName : null;
                this.taggableObjectsService.setEditionInfoFromTags((TaggableObjectsService.TaggableObject)dashboard, (TaggableObjectsService.TaggableListItem)listItem);
                result.add(listItem);
            }
            ArrayList<Dashboard.DashboardListItem> arrayList = result;
            return arrayList;
        }
    }

    @AuditedCall(value={"msgType", "dashboards-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public Dashboard createDashboard(HttpServletRequest req, @PathVariable String projectKey, @RequestBody Dashboard data) throws IOException, DKUSecurityException, CodedException {
        Dashboard dashboard;
        data.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(data.projectKey);
            this.projectsService.checkPerm(authCtx, project.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS});
            data.owner = authCtx.getIdentifier();
            data.id = this.dashboardsService.generateUniqueId(data.projectKey);
        }
        t = this.transactionService.beginWriteForAPI(req);
        try {
            dashboard = this.dashboardsService.save(data, true);
            t.commit("Created dashboard: " + dashboard.id);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return dashboard;
    }

    @AuditedCall(value={"msgType", "dashboard-get", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Dashboard getDashboard(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String dashboardId) throws IOException, DKUSecurityException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS});
            Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, dashboardId);
            return dashboard;
        }
    }

    @AuditedCall(value={"msgType", "dashboard-update", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public Dashboard updateDashboard(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String dashboardId, @RequestBody Dashboard data) throws IOException, DKUSecurityException, CodedException {
        Dashboard dashboard;
        data.id = dashboardId;
        data.projectKey = projectKey;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(data.projectKey);
            this.projectsService.checkPerm(authCtx, project.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS});
            Dashboard existing = this.dashboardsService.getMandatoryUnsafe(data.projectKey, data.id);
            if (!StringUtils.equals((String)existing.owner, (String)data.owner)) {
                this.projectsService.checkPerm(authCtx, project.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
            }
            if (!(project.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY || existing.listed == data.listed && StringUtils.equals((String)existing.owner, (String)authCtx.getIdentifier()))) {
                this.projectsService.checkPerm(authCtx, project.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS});
            }
            data.owner = existing.owner;
        }
        t = this.transactionService.beginWriteForAPI(req);
        try {
            dashboard = this.dashboardsService.save(data, false);
            t.commitV("Dashboard '%s' updated", new Object[]{dashboardId});
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return dashboard;
    }

    @AuditedCall(value={"msgType", "dashboard-delete", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDashboard(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String dashboardId) throws IOException, DKUSecurityException, CodedException {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS});
            this.dashboardsService.delete(projectKey, dashboardId);
            t.commitV("Dashboard '%s' deleted", new Object[]{dashboardId});
        }
    }
}

