/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.model.core.BaseUserMeta;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.mec.drift.DriftResult;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricUtils;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/modelevaluationstores"})
public class PublicAPIModelEvaluationStoresController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ModelEvaluationService modelEvaluationService;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.modelevaluationstores");

    @AuditedCall(value={"msgType", "modelevaluationstores-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public List<ModelEvaluationStore> listJobs(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            List ret;
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = ret = this.kernelsModelEvaluationStoresService.list(projectKey);
            return list;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public PublicAPIControllerBase.ResponseMessageWithId add(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        JsonObject mesObject = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        this.require(mesObject.has("name") && StringUtils.isNotBlank((String)mesObject.get("name").getAsString()), "Required field 'name' is missing.");
        if (mesObject.has("projectKey") && !mesObject.get("projectKey").isJsonNull() && mesObject.get("projectKey").getAsString().length() > 0) {
            this.require(mesObject.get("projectKey").getAsString().equals(projectKey), "Model evaluation store projectKey does not match the requested URL");
        } else {
            mesObject.addProperty("projectKey", projectKey);
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        ModelEvaluationStore mes = (ModelEvaluationStore)JSON.parse((JsonElement)mesObject, ModelEvaluationStore.class);
        ModelEvaluationStore created = new ModelEvaluationStore(projectKey);
        this.copyMESFields(mes, created);
        String commitMessage = "Created model evaluation store " + created.id + " (named " + created.name + ") in " + created.projectKey;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            if (this.modelEvaluationStoresCRUDService.getOrNull(created.projectKey, created.id) != null) {
                throw new IllegalArgumentException("The model evaluation store '" + created.id + "' already exists in project " + created.projectKey);
            }
            this.modelEvaluationStoresCRUDService.save(created, true, false);
            t.commit(commitMessage);
            this.auditTrailService.generic("modelevaluationstore-create").with("projectKey", mes.projectKey).with("mesId", mes.id).with("name", mes.name).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("modelevaluationstore-create", (Throwable)e).with("projectKey", mes.projectKey).with("mesId", mes.id).with("name", mes.name).emit();
            throw e;
        }
        return new PublicAPIControllerBase.ResponseMessageWithId(created.id, commitMessage);
    }

    private void copyMESFields(ModelEvaluationStore source, ModelEvaluationStore target) {
        target.name = source.name;
        target.checklists = source.checklists;
        target.creationTag = source.creationTag;
        target.versionTag = source.versionTag;
        target.tags = source.tags;
        target.description = source.description;
        target.shortDesc = source.shortDesc;
        target.flowOptions = source.flowOptions;
        target.rebuildBehavior = source.rebuildBehavior;
        target.customFields = source.customFields;
        target.partitioning = source.partitioning;
        target.metrics = source.metrics;
        target.metricsChecks = source.metricsChecks;
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}"}, method={RequestMethod.GET})
    public ModelEvaluationStore get(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ModelEvaluationStore modelEvaluationStore = this.kernelsModelEvaluationStoresService.getMandatory(projectKey, mesId);
            return modelEvaluationStore;
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-save", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}"}, method={RequestMethod.PUT})
    public String update(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        ModelEvaluationStore mes = (ModelEvaluationStore)this.getRequestBodyAs(req, ModelEvaluationStore.class);
        this.require(StringUtils.isNotBlank((String)mes.projectKey), "Required field 'projectKey' is missing.");
        this.require(StringUtils.isNotBlank((String)mes.name), "Required field 'name' is missing.");
        this.require(StringUtils.isNotBlank((String)mes.id), "Required field 'id' is missing.");
        this.require(mes.projectKey.equals(projectKey), "Model evaluation store projectKey does not match the requested URL");
        this.require(mes.id.equals(mesId), "Model evaluation store id does not match the requested URL");
        String commitMessage = "Updated model evaluation store" + mes.projectKey + "." + mes.id;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ModelEvaluationStore existingMes = this.modelEvaluationStoresCRUDService.getMandatory(mes.projectKey, mes.id);
            this.copyMESFields(mes, existingMes);
            this.modelEvaluationStoresCRUDService.save(existingMes, false, false);
            t.commit(commitMessage);
        }
        return commitMessage;
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-delete", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}"}, method={RequestMethod.DELETE})
    public String delete(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        String commitMessage = "Deleted model evaluation store " + projectKey + "." + mesId;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.modelEvaluationStoresCRUDService.performDeletion(authCtx, projectKey, mesId, null);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit(commitMessage);
        }
        return commitMessage;
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-list-evaluations", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/"}, method={RequestMethod.GET})
    public List<AbstractModelEvaluation> listEvaluations(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mes = this.kernelsModelEvaluationStoresService.getMandatory(projectKey, mesId);
        }
        return this.kernelsModelEvaluationStoresService.listEvaluations(mes);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-latest-evaluation", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/latestEvaluationId"}, method={RequestMethod.GET})
    public String getLatestEvaluationId(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            String string = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
            return string;
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-evaluation", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId:.+}"}, method={RequestMethod.GET})
    public ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails getEvaluation(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ModelEvaluationStore mes = this.kernelsModelEvaluationStoresService.getMandatory(projectKey, mesId);
            ModelEvaluationStoresCRUDService.AbstractModelEvaluationDetails abstractModelEvaluationDetails = this.modelEvaluationStoresCRUDService.getEvaluationDetails(mes, evaluationId);
            return abstractModelEvaluationDetails;
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-delete-evaluations", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/"}, method={RequestMethod.DELETE})
    public List<String> deleteEvaluations(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mes = this.kernelsModelEvaluationStoresService.getMandatory(projectKey, mesId);
        }
        List evaluationsToDelete = (List)this.getRequestBodyAs(req, (TypeToken)new TypeToken<List<String>>(){});
        this.modelEvaluationStoresCRUDService.deleteEvaluations(mes, evaluationsToDelete);
        return evaluationsToDelete;
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-metrics", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId:.+}/metrics"}, method={RequestMethod.GET})
    public MetricsService.ComputedMetrics getEvaluationMetrics(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mes = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, mesId);
        }
        return this.getComputedMetricsForEvaluation_NT(mes, evaluationId);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-last-metrics", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/metrics/last"}, method={RequestMethod.GET})
    public MetricsService.ComputedMetrics getLastEvaluationMetrics(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId) throws Exception {
        ModelEvaluationStore mes;
        String latestEvaluationId;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            latestEvaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
            if (null == latestEvaluationId) {
                throw new NotFoundException("Model evaluation store " + mesId + " contains no evaluation");
            }
            mes = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, mesId);
        }
        return this.getComputedMetricsForEvaluation_NT(mes, latestEvaluationId);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/metrics/history"}, method={RequestMethod.GET})
    public MetricsService.MetricHistoryData getHistoryValuesOnMES(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @RequestParam String metricLookup) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            mes = this.modelEvaluationStoresCRUDService.getMandatoryUnsafe(projectKey, mesId);
        }
        Map lastMetrics = this.metricsService.getLastKnownMetrics_NT((Object)mes, MetricTargetType.MODEL_EVALUATION_STORE);
        Metric lookedUpMetric = MetricsService.lookupMetric((String)metricLookup, (Map)lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on model evaluation store " + projectKey + "." + mesId + ".");
        }
        return this.metricsService.getMetricData_NT((Object)mes, MetricTargetType.MODEL_EVALUATION_STORE, null, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-compute-status", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/actions/computeMetrics"}, method={RequestMethod.POST})
    public FutureResponse<?> computeMetrics(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @RequestParam(required=false) String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
            ProbesSet probesToCompute = null;
            String body = IOUtils.toString((InputStream)req.getInputStream());
            if (body != null && body.length() > 0) {
                probesToCompute = (ProbesSet)JSON.parse((String)body, ProbesSet.class);
            } else {
                logger.info((Object)"Probes to compute not specified, using the ones from the MES");
                probesToCompute = mes.metrics;
            }
            Partition p = null;
            if (StringUtils.isNotEmpty((String)evaluationId)) {
                p = MetricsComputationService.fakeMEVersionPartition((String)evaluationId);
            } else {
                evaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
                p = MetricsComputationService.fakeMEVersionPartition((String)evaluationId);
            }
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            FutureResponse fr = this.metricsLaunchService.launchComputeMetrics(authCtx, mes, p, probesToCompute, new MetricsEngineDesc.MetricsEngineContext(authCtx), environment);
            FutureResponse futureResponse = fr = this.futureService.waitForFinalResponse(fr);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "dataset-compute-status", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/{mesId}/actions/runChecks"}, method={RequestMethod.POST})
    public void runChecks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String mesId, @RequestParam(required=false) String evaluationId) throws Exception {
        MetricsComputationService.MetricsComputationEnvironment environment;
        ChecksSet checks;
        ModelEvaluationStore mes;
        AuthCtx authCtx;
        Object p = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
            String body = IOUtils.toString((InputStream)req.getInputStream());
            if (body != null && body.length() > 0) {
                checks = (ChecksSet)JSON.parse((String)body, ChecksSet.class);
            } else {
                logger.info((Object)"Checks set not specified, using the MES' own checks set");
                checks = mes.metricsChecks;
            }
            environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            if (StringUtils.isEmpty((String)evaluationId)) {
                evaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
            }
        }
        FutureResponse fr = this.metricsLaunchService.launchRunChecks(authCtx, mes, evaluationId, checks, environment, (DataQualityRunOrigin)new DataQualityRunOrigin.PublicAPI());
        fr = this.futureService.waitForFinalResponse(fr);
        PublicAPIModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, (Object)fr);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-add-custom-evaluation", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations"}, method={RequestMethod.POST})
    public AbstractModelEvaluation createCustomME(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @RequestBody CreateCustomModelEvaluation params) throws Exception {
        ModelEvaluationStore mes;
        AuthCtx authCtx;
        this.require(params.predictionType == PredictionMLTask.PredictionType.BINARY_CLASSIFICATION || params.predictionType == PredictionMLTask.PredictionType.REGRESSION || params.predictionType == PredictionMLTask.PredictionType.MULTICLASS || params.predictionType == null, "Cannot use prediction type \"" + String.valueOf(params.predictionType) + ".");
        FullModelId fmi = null;
        SavedModel sm = null;
        try (Transaction t = this.transactionService.beginRead();){
            if (StringUtils.isNotEmpty((String)params.fullModelId)) {
                fmi = FullModelId.parse((String)params.fullModelId);
                sm = this.savedModelsCRUDService.getMandatory(fmi.getProjectKey(), fmi.getSavedModelID());
            }
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
        }
        TabularModelEvaluation evaluation = this.kernelsModelEvaluationStoresService.createCustomModelEvaluation(authCtx, mes, params.evaluationId, params.name, params.metrics, params.labels, params.predictionType, sm, fmi);
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        this.metricsComputationService.scoopAndSaveMetrics(authCtx, (Object)mes, MetricsComputationService.fakeMEVersionPartition((String)evaluation.ref.evaluationId), environment);
        return evaluation;
    }

    @AuditedCall(value={"msgType", "managedfolder-compute-status", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/actions/computeMetricsFromIds"}, method={RequestMethod.POST})
    public FutureResponse<?> computeMetricsFromIds(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @RequestParam(required=false) String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            ModelEvaluationStore mes = this.modelEvaluationStoresCRUDService.getMandatory(projectKey, mesId);
            logger.info((Object)"Start to compute");
            MetricUtils.CustomMetricsSet cms = (MetricUtils.CustomMetricsSet)this.getRequestBodyAs(req, MetricUtils.CustomMetricsSet.class);
            ProbesSet datasetProbes = mes.metrics;
            ProbesSet probesToCompute = MetricUtils.probesSetFromMetricIds((ProbesSet)datasetProbes, (List)cms.metricIds);
            Partition p = null;
            if (StringUtils.isNotEmpty((String)evaluationId)) {
                p = MetricsComputationService.fakeMEVersionPartition((String)evaluationId);
            } else {
                evaluationId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
                p = MetricsComputationService.fakeMEVersionPartition((String)evaluationId);
            }
            logger.info((Object)("Will compute: " + JSON.json((Object)probesToCompute)));
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            FutureResponse fr = this.metricsLaunchService.launchComputeMetrics(authCtx, mes, p, probesToCompute, new MetricsEngineDesc.MetricsEngineContext(authCtx), environment);
            FutureResponse futureResponse = fr = this.futureService.waitForFinalResponse(fr);
            return futureResponse;
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-download-sample", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/sample"}, method={RequestMethod.GET})
    public void getSample(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        this.getItem(req, resp, projectKey, mesId, evaluationId, "sample_scored.csv.gz");
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-drift-compute", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/computeDataDrift"}, method={RequestMethod.POST})
    @Deprecated
    public FutureResponse<DriftResult> computeDataDrift(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId, @RequestBody ComputedDataDriftRequest driftRequest) throws Exception {
        DriftParams driftParams = driftRequest.dataDriftParams == null ? new DriftParams() : driftRequest.dataDriftParams;
        return this.getDriftResult(req, projectKey, mesId, evaluationId, driftParams, driftRequest.referenceId);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-drift-compute", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/computeDrift"}, method={RequestMethod.POST})
    public FutureResponse<DriftResult> computeDrift(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId, @RequestBody ComputedDriftRequest driftRequest) throws Exception {
        DriftParams driftParams = driftRequest.driftParams == null ? new DriftParams() : driftRequest.driftParams;
        return this.getDriftResult(req, projectKey, mesId, evaluationId, driftParams, driftRequest.referenceId);
    }

    private FutureResponse<DriftResult> getDriftResult(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId, DriftParams driftParams, String referenceId) throws Exception {
        ModelLikeId reference;
        FullModelEvaluationId currentMe;
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            currentMe = new FullModelEvaluationId(projectKey, mesId, evaluationId);
            this.projectsService.failIfNoReadAccess((AuthCtx)authCtx, currentMe.getUnderlyingStore(), projectKey);
            if (referenceId == null) {
                reference = this.modelEvaluationService.getReferenceForDrift((ModelLikeId)currentMe);
                if (reference == null || !reference.getMainFolder().exists()) {
                    throw new IllegalArgumentException("Could not automatically determine a suitable reference model / evaluation");
                }
            } else {
                reference = ModelLikeId.parse((String)referenceId, (String)projectKey);
            }
            this.projectsService.failIfNoReadAccess((AuthCtx)authCtx, reference.getUnderlyingStore(), projectKey);
        }
        return this.modelEvaluationService.startDriftComputation(authCtx, projectKey, reference, (ModelLikeId)currentMe, driftParams);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-download-schema", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/schema"}, method={RequestMethod.GET})
    public Schema getSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            FullModelEvaluationId currentMe = new FullModelEvaluationId(projectKey, mesId, evaluationId);
            Schema schema = currentMe.getScoredSchema();
            return schema;
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-save-meta", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/user-meta"}, method={RequestMethod.PUT})
    public String setEvaluationMeta(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        FullModelEvaluationId fmeId = new FullModelEvaluationId(projectKey, mesId, evaluationId);
        BaseUserMeta meta = (BaseUserMeta)this.getRequestBodyAs(req, BaseUserMeta.class);
        String commitMessage = "Updated user meta of model evaluation " + String.valueOf(fmeId);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            AbstractModelEvaluation me = this.modelEvaluationService.getModelEvaluation(fmeId);
            me.userMeta = meta;
            this.modelEvaluationService.save(me);
            t.commit(commitMessage);
        }
        return commitMessage;
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-get-per-timeseries-metrics", "projectKey", "${projectKey}", "mesId", "${mesId}", "evaluationId", "${evaluationId}"})
    @ResponseBody
    @RequestMapping(value={"/{mesId}/evaluations/{evaluationId}/per-timeseries-metrics"}, method={RequestMethod.GET})
    public void getPerTimeseriesMetrics(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String mesId, @PathVariable String evaluationId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        FullModelEvaluationId fmeId = new FullModelEvaluationId(projectKey, mesId, evaluationId);
        if (fmeId.getPredictionType() != PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            throw new IllegalArgumentException("Can only fetch per time series metrics for time series forecasting models");
        }
        TimeseriesForecastingModelPerf modelPerf = fmeId.getTimeseriesForecastingPerf(true);
        PublicAPIModelEvaluationStoresController.writeJSON((HttpServletResponse)resp, Map.of("perTimeseries", modelPerf.perTimeseriesMetrics));
    }

    private void getItem(HttpServletRequest req, HttpServletResponse resp, String projectKey, String mesId, String evaluationId, String itemPath) throws Exception {
        Callable callableDownloadHandler;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ModelEvaluationStore mes = this.kernelsModelEvaluationStoresService.getMandatoryUnsafe(projectKey, mesId);
            AbstractModelEvaluation me = this.kernelsModelEvaluationStoresService.getEvaluation(mes, evaluationId);
            callableDownloadHandler = this.kernelsModelEvaluationStoresService.handleDownloadRequest(me, itemPath, resp);
        }
        callableDownloadHandler.call();
    }

    private MetricsService.ComputedMetrics getComputedMetricsForEvaluation_NT(ModelEvaluationStore mes, String evaluationId) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        MetricsService.ComputedMetrics list = this.metricsService.listComputedMetrics_NT((Object)mes, MetricTargetType.MODEL_EVALUATION_STORE, mes.metrics != null ? mes.metrics.displayedState : null, true);
        MetricsService.ComputedMetrics restricted = new MetricsService.ComputedMetrics();
        for (MetricsService.ComputedMetric computedMetric : list.metrics) {
            String match = null;
            for (String computedMetricPartition : computedMetric.partitionsWithValue) {
                if (!evaluationId.equals(computedMetricPartition)) continue;
                match = computedMetricPartition;
                break;
            }
            if (match == null) continue;
            computedMetric.partitionsWithValue = Lists.newArrayList((Object[])new String[]{match});
            computedMetric.lastValues = computedMetric.lastValues.stream().filter(lv -> StringUtils.equals((String)lv.partition, (String)evaluationId)).collect(Collectors.toList());
            restricted.metrics.add(computedMetric);
        }
        return restricted;
    }

    public class CreateCustomModelEvaluation {
        public String evaluationId;
        public String name;
        List<KernelsModelEvaluationStoresService.ModelCustomEvaluationMetricWithValue> metrics;
        List<SimpleKeyValue> labels;
        PredictionMLTask.PredictionType predictionType;
        String fullModelId;
    }

    @Deprecated
    public static class ComputedDataDriftRequest {
        DriftParams dataDriftParams;
        String referenceId;
    }

    public static class ComputedDriftRequest {
        DriftParams driftParams;
        String referenceId;
    }
}

