/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.dataquality.UIRuleHistory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.server.services.dataquality.DataQualitySummaryService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets/{datasetName}"})
public class PublicAPIDatasetMetricsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private DataQualityRulesLaunchService launchService;
    @Autowired
    private DataQualitySummaryService dataQualitySummaryService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    private ReadOnlyJobsInternalDB readOnlyJobsInternalDB;
    static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.metrics.api");

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/metrics/last/{partition:.+}"}, method={RequestMethod.GET})
    public void getLastValuesOnDataset(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @PathVariable String partition) throws Exception {
        MetricsService.ComputedMetrics ret;
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        if (StringUtils.isBlank((String)partition)) {
            ret = this.metricsService.listComputedMetrics_NT((Object)dataset, MetricTargetType.DATASET, dataset.getModel().getMetrics() != null ? dataset.getModel().getMetrics().displayedState : null, true);
        } else {
            Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition);
            ret = this.metricsService.listComputedMetrics_NT((Object)dataset, MetricTargetType.DATASET, p, dataset.getModel().getMetrics() != null ? dataset.getModel().getMetrics().displayedState : null, true);
        }
        PublicAPIDatasetMetricsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/metrics/history/{partition:.+}"}, method={RequestMethod.GET})
    public void getHistoryValuesOnDataset(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @PathVariable String partition, @RequestParam String metricLookup) throws Exception {
        Dataset dataset;
        DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        Partition p = MetricsComputationService.makePartitionFromId((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition);
        Map lastMetrics = this.metricsService.getLastKnownMetrics_NT((Object)dataset, MetricTargetType.DATASET);
        Metric lookedUpMetric = MetricsService.lookupMetric((String)metricLookup, (Map)lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on dataset " + loc.getFullName() + ".");
        }
        PublicAPIDatasetMetricsController.writeJSON((HttpServletResponse)resp, (Object)this.metricsService.getMetricData_NT((Object)dataset, MetricTargetType.DATASET, p, lookedUpMetric.getId(), true));
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-rules", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/rules"}, method={RequestMethod.GET})
    @ResponseBody
    public DataQualityRuleSet getDatasetRules(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        return sd.getDataQualityRuleSet();
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-rule-create", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/rules"}, method={RequestMethod.POST})
    @ResponseBody
    public DataQualityRule createRule(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        DataQualityRule newRule = (DataQualityRule)this.getRequestBodyAs(req, DataQualityRule.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            List rules = sd.getDataQualityRuleSet().getRules();
            if (StringUtils.isBlank((String)newRule.getId())) {
                newRule.initializeId();
            } else if (rules.stream().anyMatch(r -> r.getId().equals(newRule.getId()))) {
                throw new IllegalArgumentException("A rule with the provided id already exists for this dataset");
            }
            sd.getDataQualityRuleSet().getRules().add(newRule);
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            this.datasetSaveService.save(loc, sd, authCtx);
            t.commit("Created rule on " + projectKey + " for dataset " + datasetName);
        }
        return newRule;
    }

    public void checkPartitionParameterOnDataset(SerializedDataset sd, @Nullable String partition) {
        boolean isPartitionForNonPartitionedDataset;
        boolean bl = isPartitionForNonPartitionedDataset = partition == null || partition.equals("NP") || partition.equals("");
        if (sd.isPartitioned() && isPartitionForNonPartitionedDataset) {
            throw new IllegalArgumentException("Dataset is partitioned. You need to set a specific partition");
        }
        if (!sd.isPartitioned() && !isPartitionForNonPartitionedDataset) {
            throw new IllegalArgumentException("You cannot fetch a specific partition value for a non-partitioned dataset");
        }
    }

    public void checkPartitionParameterOnDataset(SerializedDataset sd, List<String> partitions) {
        for (String partition : partitions) {
            this.checkPartitionParameterOnDataset(sd, partition);
        }
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-compute-rules", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/actions/compute-rules"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport> computeRulesForPartition(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="NP") String partition, @RequestParam(required=false) String ruleId) throws Exception {
        SerializedDataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        partition = StringUtils.isBlank((String)partition) ? "NP" : partition;
        this.checkPartitionParameterOnDataset(dataset, partition);
        DataQualityRulesLaunchService.RunOptions options = DataQualityRulesLaunchService.RunOptions.fromPublicAPI();
        List rules = ruleId == null ? dataset.getDataQualityRuleSet().getRules() : dataset.getDataQualityRuleSet().getRules().stream().filter(r -> r.getId().equals(ruleId)).collect(Collectors.toList());
        return this.launchService.computeRulesOnSinglePartition(authCtx, Dataset.fromSerialized((SerializedDataset)dataset), rules, partition, options);
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-get-partitions-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/get-partitions-status"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, AbstractCheckContext.CheckOutcome> getPartitionsStatus(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="['NP']") List<String> partitions) throws Exception {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        this.checkPartitionParameterOnDataset(sd, partitions);
        Map partitionNameToPartitionPoint = this.readOnlyJobsInternalDB.getLastDataQualityPartitionStatusesForList(projectKey, sd.getId(), partitions);
        return partitionNameToPartitionPoint.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ReadOnlyJobsInternalDB.DataQualityPartitionPoint)e.getValue()).last.getOutcome()));
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/status"}, method={RequestMethod.GET})
    @ResponseBody
    public AbstractCheckContext.CheckOutcome getDatasetStatus(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        ReadOnlyJobsInternalDB.DataQualityLastObjectPoint lastObjectPoint = this.readOnlyJobsInternalDB.getLastDataQualityObjectStatus(projectKey, sd.getId());
        if (lastObjectPoint == null) {
            throw new NotFoundException("There is no result for this dataset");
        }
        return lastObjectPoint.last.getOutcome();
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-status-by-partition", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/status-by-partition"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getDatasetStatusByPartition(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="false") boolean includeAllPartitions) throws SQLException, DKUSecurityException, IOException {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        Map points = this.readOnlyJobsInternalDB.getLastDataQualityPartitionStatusesForObject(projectKey, sd.getId());
        HashMap<String, String> result = new HashMap<String, String>();
        long lastComputation = 0L;
        for (ReadOnlyJobsInternalDB.DataQualityPartitionPoint point : points.values()) {
            if (point.lastRunRuleComputeTime <= lastComputation) continue;
            lastComputation = point.lastRunRuleComputeTime;
        }
        long computeDay = this.dataQualitySummaryService.computeDay(lastComputation);
        for (Map.Entry point : points.entrySet()) {
            if (!includeAllPartitions && ((ReadOnlyJobsInternalDB.DataQualityPartitionPoint)point.getValue()).lastRunRuleComputeTime <= computeDay) continue;
            result.put((String)point.getKey(), ((ReadOnlyJobsInternalDB.DataQualityPartitionPoint)point.getValue()).last.getOutcome().name());
        }
        return result;
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-last-rules-results-for-partition", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/last-rules-result"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DatQualityRuleResultAPI> getLastRulesResultForPartition(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="NP") String partition, @RequestParam(required=false) String ruleId) throws Exception {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        partition = StringUtils.isBlank((String)partition) ? "NP" : partition;
        this.checkPartitionParameterOnDataset(sd, partition);
        Map ruleIdsToCheckResult = this.readOnlyJobsInternalDB.getLastChecksResultForPartition(projectKey, sd.getId(), partition, ruleId);
        ArrayList<DatQualityRuleResultAPI> result = new ArrayList<DatQualityRuleResultAPI>();
        for (DataQualityRule r : sd.getDataQualityRuleSet().getRules()) {
            if (!ruleIdsToCheckResult.containsKey(r.getId())) continue;
            result.add(new DatQualityRuleResultAPI(r, (ReadOnlyJobsInternalDB.CheckDataPoint)ruleIdsToCheckResult.get(r.getId())));
        }
        return result;
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-rules-history", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/data-quality/rules-history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DatQualityRuleResultAPI> getRulesHistory(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(required=false, defaultValue="-1") long minTimestamp, @RequestParam(required=false, defaultValue="-1") long maxTimestamp, @RequestParam(required=false, defaultValue="10000") int resultsPerPage, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false) List<String> ruleIds) throws Exception {
        SerializedDataset sd;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            sd = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        UIRuleHistory.PageFilters filters = new UIRuleHistory.PageFilters(page, resultsPerPage, minTimestamp, maxTimestamp);
        if (ruleIds != null) {
            filters.rules = ruleIds;
        }
        List points = this.readOnlyJobsInternalDB.getChecksWithFilter(projectKey, sd.getId(), filters);
        return points.stream().map(DatQualityRuleResultAPI::new).collect(Collectors.toList());
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-delete-rules-history", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "partitionId", "${partitionId}"})
    @RequestMapping(value={"/data-quality/history/{partitionId}"}, method={RequestMethod.DELETE})
    public void deleteRulesHistory(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @PathVariable String partitionId) throws Exception {
        SerializedDataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(projectKey, datasetName);
        }
        this.dataQualityService.deletePartitionHistory(dataset, partitionId);
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-update-rule", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "ruleId", "${ruleId}"})
    @RequestMapping(value={"/data-quality/rules/{ruleId}"}, method={RequestMethod.PUT})
    public void saveRule(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @PathVariable String ruleId) throws Exception {
        DataQualityRule rule = (DataQualityRule)this.getRequestBodyAs(req, DataQualityRule.class);
        if (!StringUtils.isBlank((String)rule.getId()) && !rule.getId().equals(ruleId)) {
            throw new IllegalArgumentException("The rule provided does not match the rule id specified");
        }
        rule.withId(ruleId);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            List rules = sd.getDataQualityRuleSet().getRules();
            if (rules.stream().noneMatch(r -> r.getId().equals(ruleId))) {
                throw new NotFoundException("The rule id provided does not match any rule in the dataset");
            }
            sd.getDataQualityRuleSet().withRules(rules.stream().map(r -> {
                if (rule.getId().equals(r.getId())) {
                    return rule;
                }
                return r;
            }).collect(Collectors.toList()));
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            this.datasetSaveService.save(loc, sd, authCtx);
            t.commit("Updated rule " + rule.getId() + " for dataset " + datasetName);
        }
    }

    @AuditedCall(value={"msgType", "dataset-data-quality-delete-rule", "projectKey", "${projectKey}", "datasetName", "${datasetName}", "ruleId", "${ruleId}"})
    @RequestMapping(value={"/data-quality/rules/{ruleId}"}, method={RequestMethod.DELETE})
    public void deleteRule(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @PathVariable String ruleId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            List rules = sd.getDataQualityRuleSet().getRules();
            sd.getDataQualityRuleSet().withRules(rules.stream().filter(r -> !r.getId().equals(ruleId)).collect(Collectors.toList()));
            DatasetLocUtils.DatasetLoc loc = new DatasetLocUtils.DatasetLoc(projectKey, datasetName);
            this.datasetSaveService.save(loc, sd, authCtx);
            t.commit("Deleted rule " + ruleId + " for dataset " + datasetName);
        }
    }

    public static class DatQualityRuleResultAPI {
        public final String name;
        public final String id;
        public final String outcome;
        public final String message;
        public final DataQualityRunOrigin runOrigin;
        public final long computeDate;
        public final String partition;

        public DatQualityRuleResultAPI(DataQualityRule r, ReadOnlyJobsInternalDB.CheckDataPoint res) {
            this.id = res.check.getId();
            this.outcome = res.outcome.name();
            this.message = res.message;
            this.runOrigin = res.runOrigin;
            this.computeDate = res.time;
            this.partition = res.partition;
            this.name = r.getDisplayName();
        }

        public DatQualityRuleResultAPI(UIRuleHistory.RuleHistoryPoint p) {
            this.id = p.id;
            this.outcome = p.outcome.name();
            this.message = p.message;
            this.runOrigin = p.runOrigin;
            this.computeDate = p.computationTime;
            this.partition = p.partition;
            this.name = p.displayName;
        }
    }
}

