/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.ml.prediction;

import com.dataiku.dip.analysis.model.prediction.BinaryClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.ClassificationModelPredictionInfos;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.MulticlassModelPerf;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelIntrinsicPerf;
import com.dataiku.dip.analysis.model.prediction.RegressionModelPerf;
import com.dataiku.dip.spark.compat.package;
import com.dataiku.dip.spark.ml.Calibration$;
import com.dataiku.dip.spark.ml.prediction.BinaryClassificationPerf;
import com.dataiku.dip.spark.ml.prediction.BinaryClassificationPerf$;
import com.dataiku.dip.spark.ml.prediction.BinaryPredictionAssessment$;
import com.dataiku.dip.spark.ml.prediction.ModelScorer;
import com.dataiku.dip.spark.ml.preprocessing.Features;
import com.dataiku.dip.spark.ml.preprocessing.ListFeatures;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.KernelDensity;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.StatCounter$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.ZippedTraversable3;
import scala.runtime.ZippedTraversable3$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ModelScorer$ {
    public static ModelScorer$ MODULE$;
    private final int LIFT_BINS;
    private final int ERROR_BINS;
    private final long SAMPLE_SIZE;
    private final long PLOT_SAMPLE_SIZE;
    private final int MAX_COEFS;
    private final int LIMIT_NVAR_FOR_MRAUC;
    private final int FURTHER_SAMPLE_SIZE;
    private final Logger logger;

    static {
        new ModelScorer$();
    }

    public int LIFT_BINS() {
        return this.LIFT_BINS;
    }

    public int ERROR_BINS() {
        return this.ERROR_BINS;
    }

    public long SAMPLE_SIZE() {
        return this.SAMPLE_SIZE;
    }

    public long PLOT_SAMPLE_SIZE() {
        return this.PLOT_SAMPLE_SIZE;
    }

    public int MAX_COEFS() {
        return this.MAX_COEFS;
    }

    public int LIMIT_NVAR_FOR_MRAUC() {
        return this.LIMIT_NVAR_FOR_MRAUC;
    }

    public int FURTHER_SAMPLE_SIZE() {
        return this.FURTHER_SAMPLE_SIZE;
    }

    public <T> Tuple2<T, Object> highest(Tuple2<T, Object> a, Tuple2<T, Object> b) {
        if (a._2$mcD$sp() >= b._2$mcD$sp()) {
            return a;
        }
        return b;
    }

    public <T> Tuple2<T, Object> lowest(Tuple2<T, Object> a, Tuple2<T, Object> b) {
        if (a._2$mcD$sp() <= b._2$mcD$sp()) {
            return a;
        }
        return b;
    }

    public <T> Tuple2<RDD<T>, Object> subSample(RDD<T> rdd, long fullLen, long seed, long max) {
        double ratio = (double)max / (double)fullLen;
        if (ratio < 0.9) {
            return new Tuple2((Object)rdd.sample(false, ratio, seed), (Object)BoxesRunTime.boxToLong((long)max));
        }
        return new Tuple2(rdd, (Object)BoxesRunTime.boxToLong((long)fullLen));
    }

    public <T> long subSample$default$4() {
        return this.SAMPLE_SIZE();
    }

    public scala.collection.immutable.Map<Enumeration.Value, Object> gainMatrix(MetricParams.CostMatrixWeights costMatrixWeight) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryPredictionAssessment$.MODULE$.TRUE_NEGATIVE()), (Object)BoxesRunTime.boxToDouble((double)costMatrixWeight.tnGain)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryPredictionAssessment$.MODULE$.FALSE_POSITIVE()), (Object)BoxesRunTime.boxToDouble((double)costMatrixWeight.fpGain)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryPredictionAssessment$.MODULE$.FALSE_NEGATIVE()), (Object)BoxesRunTime.boxToDouble((double)costMatrixWeight.fnGain)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BinaryPredictionAssessment$.MODULE$.TRUE_POSITIVE()), (Object)BoxesRunTime.boxToDouble((double)costMatrixWeight.tpGain))}));
    }

    public BinaryClassificationModelPerf binaryClassificationPerfNP(RDD<Tuple2<Object, Object>> predLabel, MetricParams.CostMatrixWeights costMatrixWeight, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        return this.binaryClassificationPerf(predLabel, null, (Option<MetricParams.ThresholdOptimizationMetric>)None$.MODULE$, this.gainMatrix(costMatrixWeight), 0.0, targetRemapping, subSamplingSeed, false);
    }

    public BinaryClassificationModelPerf binaryClassificationPerf(RDD<Tuple3<Object, Object, org.apache.spark.ml.linalg.Vector>> labelPredProba, Option<MetricParams.ThresholdOptimizationMetric> optimizeFor, MetricParams.CostMatrixWeights costMatrixWeight, double liftPoint, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        return this.binaryClassificationPerf(labelPredProba, (Function1 & Serializable & scala.Serializable)lpp -> new Tuple2.mcDD.sp(((org.apache.spark.ml.linalg.Vector)lpp._3()).apply(1), BoxesRunTime.unboxToDouble((Object)lpp._1())), optimizeFor, this.gainMatrix(costMatrixWeight), liftPoint, targetRemapping, subSamplingSeed, true);
    }

    public ClassificationModelPredictionInfos classificationPred(RDD<Tuple2<Object, org.apache.spark.ml.linalg.Vector>> predProba, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        return this.classificationPred(predProba, targetRemapping, subSamplingSeed, true);
    }

    public ClassificationModelPredictionInfos classificationPredNoProba(RDD<Object> preds, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        return this.classificationPred(preds, targetRemapping, subSamplingSeed, false);
    }

    public <T> BinaryClassificationModelPerf binaryClassificationPerf(RDD<T> labelPredProba, Function1<T, Tuple2<Object, Object>> extractScoreProbas, Option<MetricParams.ThresholdOptimizationMetric> optimizeFor, scala.collection.immutable.Map<Enumeration.Value, Object> gainMatrix, double liftPoint, IndexedSeq<String> targetRemapping, long subSamplingSeed, boolean hasProbas) {
        BinaryClassificationModelPerf perf;
        BinaryClassificationPerf metrics;
        RDD sample;
        block13: {
            block10: {
                double[] percentiles;
                long[] liftBins;
                Option option;
                long positives;
                long[] liftBinPops;
                RDD scoreLabels;
                long len;
                block12: {
                    Tuple6 tuple6;
                    block11: {
                        long fullLen = labelPredProba.count();
                        Tuple2<RDD<T>, Object> tuple2 = this.subSample(labelPredProba, fullLen, subSamplingSeed, this.subSample$default$4());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        RDD sample2 = (RDD)tuple2._1();
                        long len2 = tuple2._2$mcJ$sp();
                        Tuple2 tuple22 = new Tuple2((Object)sample2, (Object)BoxesRunTime.boxToLong((long)len2));
                        sample = (RDD)tuple22._1();
                        len = tuple22._2$mcJ$sp();
                        sample.persist();
                        this.logger().info((Object)new StringBuilder(16).append("Sample: ").append(len).append(" records").toString());
                        scoreLabels = extractScoreProbas == null ? sample : sample.map(extractScoreProbas, ClassTag$.MODULE$.apply(Tuple2.class));
                        metrics = new BinaryClassificationPerf((RDD<Tuple2<Object, Object>>)scoreLabels, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)len)), gainMatrix, liftPoint, optimizeFor, hasProbas);
                        this.logger().info((Object)new StringBuilder(15).append(metrics.cuts().length).append(" thresholds (").append(metrics.cuts()[0]).append("-").append(metrics.cuts()[metrics.cuts().length - 1]).append(")").toString());
                        this.logger().info((Object)new StringBuilder(24).append("Optimal threshold for ").append(optimizeFor).append(": ").append(metrics.optimalThreshold()).toString());
                        perf = new BinaryClassificationModelPerf();
                        perf.optimalThreshold = BoxesRunTime.unboxToDouble((Object)metrics.optimalThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble(null)));
                        perf.usedThreshold = BoxesRunTime.unboxToDouble((Object)metrics.optimalThreshold().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.5));
                        this.logger().info((Object)new StringBuilder(19).append("Used threshold for ").append(perf.usedThreshold).toString());
                        perf.perCutData = new BinaryClassificationModelPerf.CutData();
                        perf.perCutData.cut = metrics.cuts();
                        perf.perCutData.accuracy = (double[])((TraversableOnce)metrics.accuracy().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._2$mcD$sp()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                        perf.perCutData.recall = (double[])((TraversableOnce)metrics.recall().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3._2$mcD$sp()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                        perf.perCutData.precision = (double[])((TraversableOnce)metrics.precision().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4._2$mcD$sp()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                        perf.perCutData.f1 = (double[])((TraversableOnce)metrics.f1().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5._2$mcD$sp()), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                        perf.perCutData.tn = (float[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(metrics.tn())).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)x -> x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        perf.perCutData.fp = (float[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(metrics.fp())).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)x -> x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        perf.perCutData.fn = (float[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(metrics.fn())).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)x -> x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        perf.perCutData.tp = (float[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(metrics.tp())).map((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)x -> x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        perf.perCutData.mcc = metrics.mcc();
                        perf.perCutData.hammingLoss = (double[])metrics.hammingLoss().toArray(ClassTag$.MODULE$.Double());
                        if (!hasProbas) break block10;
                        perf.rocVizData = new ArrayList(1);
                        perf.rocVizData.add(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rocViz(metrics, metrics.desCuts()))).toList()));
                        perf.prVizData = new ArrayList(1);
                        perf.prVizData.add(this.prViz(metrics, metrics.desCuts()));
                        RDD descData = sample.sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$binaryClassificationPerf$12(x$6)), false, 1, (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
                        long liftPointPop = (long)(liftPoint * (double)len);
                        liftBinPops = (long[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)this.LIFT_BINS())).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$7 -> x$7 * len / (long)MODULE$.LIFT_BINS(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
                        long[] percentilePops = (long[])((TraversableOnce)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)99L)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$8 -> x$8 * len / 100L, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
                        Tuple6 liftAgg = new Tuple6((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)None$.MODULE$, new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(liftBinPops)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$9 -> 0L, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(liftBinPops)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$10 -> 0L, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(percentilePops)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$11 -> 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                        tuple6 = (Tuple6)descData.aggregate((Object)liftAgg, (Function2 & Serializable & scala.Serializable)(acc, lpp) -> {
                            int percentile;
                            long idx = BoxesRunTime.unboxToLong((Object)acc._1()) + 1L;
                            long pos = BoxesRunTime.unboxToDouble((Object)lpp._1()) == 1.0 ? BoxesRunTime.unboxToLong((Object)acc._2()) + 1L : BoxesRunTime.unboxToLong((Object)acc._2());
                            Option lift = ((Option)acc._3()).isEmpty() && idx >= liftPointPop ? new Some((Object)BoxesRunTime.boxToLong((long)pos)) : (Option)acc._3();
                            int achieved = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(liftBinPops)).indexOf((Object)BoxesRunTime.boxToLong((long)idx));
                            if (achieved >= 0) {
                                ((long[])acc._4())[achieved] = pos - (achieved == 0 ? 0L : ((long[])acc._5())[achieved - 1]);
                                ((long[])acc._5())[achieved] = pos;
                            }
                            if ((percentile = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(percentilePops)).indexOf((Object)BoxesRunTime.boxToLong((long)(len - idx)))) >= 0) {
                                ((double[])acc._6())[percentile] = ((org.apache.spark.ml.linalg.Vector)lpp._3()).apply(1);
                            }
                            return new Tuple6((Object)BoxesRunTime.boxToLong((long)idx), (Object)BoxesRunTime.boxToLong((long)pos), (Object)lift, acc._4(), acc._5(), acc._6());
                        }, (Function2 & Serializable & scala.Serializable)(a, b) -> {
                            if (BoxesRunTime.unboxToLong((Object)a._1()) == 0L) {
                                return b;
                            }
                            if (BoxesRunTime.unboxToLong((Object)b._1()) == 0L) {
                                return a;
                            }
                            throw new IllegalStateException(new StringBuilder(39).append("Can't parallelize sorted iteration:\t\n").append(a).append("\t\n").append(b).toString());
                        }, ClassTag$.MODULE$.apply(Tuple6.class));
                        if (tuple6 == null) break block11;
                        positives = BoxesRunTime.unboxToLong((Object)tuple6._2());
                        option = (Option)tuple6._3();
                        liftBins = (long[])tuple6._4();
                        percentiles = (double[])tuple6._6();
                        if (option instanceof Some) break block12;
                    }
                    throw new MatchError((Object)tuple6);
                }
                Some some = (Some)option;
                long lift = BoxesRunTime.unboxToLong((Object)some.value());
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToLong((long)positives), (Object)BoxesRunTime.boxToLong((long)lift), (Object)liftBins, (Object)percentiles);
                long positives2 = BoxesRunTime.unboxToLong((Object)tuple4._1());
                long lift2 = BoxesRunTime.unboxToLong((Object)tuple4._2());
                long[] liftBins2 = (long[])tuple4._3();
                double[] percentiles2 = (double[])tuple4._4();
                double targetDensity = (double)positives2 / (double)len;
                List liftBinList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Tuple3Zipped$.MODULE$.map$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)liftBins2, (Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(liftBins2)).indices(), (Object)liftBinPops)), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(xs)), (Function1)Predef$.MODULE$.$conforms(), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(xs))), (Function3 & Serializable & scala.Serializable)(binLift, i, max) -> ModelScorer$.$anonfun$binaryClassificationPerf$22(len, targetDensity, positives2, BoxesRunTime.unboxToLong((Object)binLift), BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToLong((Object)max)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryClassificationModelPerf.LiftBin.class))))).toList();
                liftBinList.sliding(2).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$binaryClassificationPerf$23(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                    ModelScorer$.$anonfun$binaryClassificationPerf$24(x$13);
                    return BoxedUnit.UNIT;
                });
                perf.liftVizData = new BinaryClassificationModelPerf.LiftVizData();
                perf.liftVizData.bins = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)liftBinList);
                perf.liftVizData.wizard = new BinaryClassificationModelPerf.LiftWizard();
                perf.liftVizData.wizard.positives = (int)positives2;
                perf.liftVizData.wizard.total = (int)len;
                perf.tiMetrics.auc = metrics.areaUnderROC();
                perf.tiMetrics.averagePrecision = this.averagePrecisionScore((RDD<Tuple2<Object, Object>>)scoreLabels);
                perf.tiMetrics.lift = (double)lift2 / (double)positives2 / targetDensity;
                perf.probaPercentiles = percentiles2;
                break block13;
            }
            perf.tiMetrics.lift = 0.0;
            perf.tiMetrics.auc = 0.0;
        }
        perf.tiMetrics.logLoss = metrics.logLoss();
        metrics.unpersist();
        if (hasProbas) {
            RDD rdd = sample;
            try {
                ((IterableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}))).map((Function1 & Serializable & scala.Serializable)c -> ModelScorer$.$anonfun$binaryClassificationPerf$25(rdd, BoxesRunTime.unboxToDouble((Object)c)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                    Tuple2 tuple2 = x$18;
                    if (tuple2 != null) {
                        double c = tuple2._1$mcD$sp();
                        RDD c_rdd = (RDD)tuple2._2();
                        BinaryClassificationModelPerf.PerClassPredictedProbabilityDensityData densityData = new BinaryClassificationModelPerf.PerClassPredictedProbabilityDensityData();
                        RDD probasWhenActualIsThisClass = c_rdd.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$binaryClassificationPerf$28(c, x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$binaryClassificationPerf$29(x$15)), ClassTag$.MODULE$.Double());
                        RDD probasWhenActualIsNotThisClass = c_rdd.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$binaryClassificationPerf$30(c, x$16))).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$binaryClassificationPerf$31(x$17)), ClassTag$.MODULE$.Double());
                        densityData.actualIsThisClass = MODULE$.probaDensity((RDD<Object>)probasWhenActualIsThisClass);
                        densityData.actualIsNotThisClass = MODULE$.probaDensity((RDD<Object>)probasWhenActualIsNotThisClass);
                        densityData.actualIsThisClassMedian = MODULE$.approxMedian((RDD<Object>)probasWhenActualIsThisClass);
                        densityData.actualIsNotThisClassMedian = MODULE$.approxMedian((RDD<Object>)probasWhenActualIsNotThisClass);
                        return perf$1.densityData.put(targetRemapping.apply((int)c), densityData);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            catch (Exception e) {
                this.logger().error((Object)"Couldn't compute density data", (Throwable)e);
            }
            try {
                perf.calibrationData = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.calibrationCurve(metrics.getRawCalibrationCurve()))).toList());
                perf.tiMetrics.calibrationLoss = metrics.getCalibrationLoss();
            }
            catch (Exception e) {
                this.logger().error((Object)"Couldn't compute calibration data", (Throwable)e);
            }
        }
        sample.unpersist(sample.unpersist$default$1());
        return perf;
    }

    public double averagePrecisionScore(RDD<Tuple2<Object, Object>> rdd) {
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(rdd, 0);
        return this.averagePrecisionScore(metrics);
    }

    public double averagePrecisionScore(BinaryClassificationMetrics fullBinaryMetrics) {
        RDD prCurve = fullBinaryMetrics.pr();
        Tuple2[] localAreas = (Tuple2[])prCurve.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            if (iter.nonEmpty()) {
                DoubleRef localArea = DoubleRef.create((double)0.0);
                BooleanRef head = BooleanRef.create((boolean)true);
                ObjectRef firstPoint = ObjectRef.create((Object)new Tuple2.mcDD.sp(Double.NaN, Double.NaN));
                ObjectRef lastPoint = ObjectRef.create((Object)new Tuple2.mcDD.sp(Double.NaN, Double.NaN));
                iter.sliding(2, iter.sliding$default$2()).foreach((Function1 & Serializable & scala.Serializable)points -> {
                    ModelScorer$.$anonfun$averagePrecisionScore$2(head, firstPoint, lastPoint, localArea, points);
                    return BoxedUnit.UNIT;
                });
                return scala.package$.MODULE$.Iterator().single((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)localArea.elem), (Object)new Tuple2((Object)((Tuple2)firstPoint.elem), (Object)((Tuple2)lastPoint.elem))));
            }
            return scala.package$.MODULE$.Iterator().empty();
        }, prCurve.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        Iterator qual$1 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localAreas)).iterator().map((Function1 & Serializable & scala.Serializable)x$20 -> (Tuple2)x$20._2());
        int x$1 = 2;
        int x$2 = qual$1.sliding$default$2();
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])localAreas)).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19._1$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + BoxesRunTime.unboxToDouble((Object)qual$1.sliding(x$1, x$2).withPartial(false).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$averagePrecisionScore$5(x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    private double weightedPrecision(Seq<Tuple2<Object, Object>> points) {
        Predef$.MODULE$.require(points.length() == 2);
        Tuple2 tuple2 = (Tuple2)points.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prevRecall = tuple2._1$mcD$sp();
        double prevPrecision = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(prevRecall, prevPrecision);
        double prevRecall2 = sp2._1$mcD$sp();
        double prevPrecision2 = sp2._2$mcD$sp();
        Tuple2 tuple22 = (Tuple2)points.last();
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double recall = tuple22._1$mcD$sp();
        double precision = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(recall, precision);
        double recall2 = sp3._1$mcD$sp();
        double precision2 = sp3._2$mcD$sp();
        return (recall2 - prevRecall2) * precision2;
    }

    public <T> ClassificationModelPredictionInfos classificationPred(RDD<T> labelPredProba, IndexedSeq<String> targetRemapping, long subSamplingSeed, boolean hasProbas) {
        long fullLen = labelPredProba.count();
        Tuple2<RDD<T>, Object> tuple2 = this.subSample(labelPredProba, fullLen, subSamplingSeed, this.subSample$default$4());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD sample = (RDD)tuple2._1();
        long len = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)sample, (Object)BoxesRunTime.boxToLong((long)len));
        RDD sample2 = (RDD)tuple22._1();
        long len2 = tuple22._2$mcJ$sp();
        sample2.persist();
        this.logger().info((Object)new StringBuilder(16).append("Sample: ").append(len2).append(" records").toString());
        ClassificationModelPredictionInfos pred = new ClassificationModelPredictionInfos();
        if (hasProbas) {
            this.computePredictionInfos(targetRemapping, sample2, pred);
        } else {
            this.computePredictionInfosNoProba(targetRemapping, sample2, pred);
        }
        sample2.unpersist(sample2.unpersist$default$1());
        return pred;
    }

    private <T> void computePredictionInfosNoProba(IndexedSeq<String> targetRemapping, RDD<T> sample, ClassificationModelPredictionInfos pred) {
        RDD<T> predsRDD = sample;
        try {
            pred.predictedClassCount = this.getPredictionDistributionFromPreds(predsRDD, targetRemapping);
        }
        catch (Exception e) {
            this.logger().error((Object)"Couldn't compute prediction distribution", (Throwable)e);
        }
    }

    private <T> void computePredictionInfos(IndexedSeq<String> targetRemapping, RDD<T> sample, ClassificationModelPredictionInfos pred) {
        RDD predsAndProbasRDD = sample;
        try {
            pred.predictedClassCount = this.getPredictionDistributionFromPreds((RDD<Object>)predsAndProbasRDD.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToDouble((double)r._1$mcD$sp()), ClassTag$.MODULE$.Double()), targetRemapping);
            targetRemapping.indices().foreach((Function1 & Serializable & scala.Serializable)c -> ModelScorer$.$anonfun$computePredictionInfos$2(predsAndProbasRDD, pred, targetRemapping, BoxesRunTime.unboxToInt((Object)c)));
        }
        catch (Exception e) {
            this.logger().error((Object)"Couldn't compute prediction distribution and density data", (Throwable)e);
        }
    }

    public java.util.Map<String, Long> getPredictionDistributionFromPreds(RDD<Object> predsRDD, IndexedSeq<String> targetRemapping) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)predsRDD.countByValue((Ordering)Ordering.Double$.MODULE$).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(targetRemapping.apply((int)kv._1$mcD$sp()), (Object)BoxesRunTime.boxToLong((long)kv._2$mcJ$sp())), Map$.MODULE$.canBuildFrom())).asJava();
    }

    public BinaryClassificationModelPerf.RocVizBin[] rocViz(BinaryClassificationMetrics metrics, double[] desCuts) {
        return (BinaryClassificationModelPerf.RocVizBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metrics.roc().collect())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(desCuts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)e -> {
            double cut;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = e;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    cut = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double x = tuple2._1$mcD$sp();
            double y = tuple2._2$mcD$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)cut));
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double cut2 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            BinaryClassificationModelPerf.RocVizBin bin = new BinaryClassificationModelPerf.RocVizBin();
            bin.p = cut2;
            bin.x = x2;
            bin.y = y2;
            return bin;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryClassificationModelPerf.RocVizBin.class)));
    }

    public BinaryClassificationModelPerf.PrVizData prViz(BinaryClassificationMetrics metrics, double[] desCuts) {
        BinaryClassificationModelPerf.PrVizBin[] bins = (BinaryClassificationModelPerf.PrVizBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metrics.pr().collect())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(desCuts), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)e -> {
            double cut;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = e;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    cut = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            double x = tuple2._1$mcD$sp();
            double y = tuple2._2$mcD$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)cut));
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double cut2 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            BinaryClassificationModelPerf.PrVizBin bin = new BinaryClassificationModelPerf.PrVizBin(cut2, x2, y2);
            return bin;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryClassificationModelPerf.PrVizBin.class))))).reverse();
        long actualPositivesCount = metrics.scoreAndLabels().filter((Function1 & Serializable & scala.Serializable)sl -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$prViz$2(sl))).count();
        long totalCount = metrics.scoreAndLabels().count();
        double positiveRate = (double)actualPositivesCount / (double)totalCount;
        return new BinaryClassificationModelPerf.PrVizData(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bins)).toList()), positiveRate);
    }

    public double[] probaDensityOrEmptyArray(RDD<Object> data) {
        if (data.isEmpty()) {
            return (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        }
        return this.probaDensity(data);
    }

    public double[] probaDensity(RDD<Object> data) {
        RDD qual$1 = data.map((Function1 & Serializable & scala.Serializable)d -> Vectors$.MODULE$.dense(new double[]{BoxesRunTime.unboxToDouble((Object)d)}), ClassTag$.MODULE$.apply(Vector.class));
        MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(agg, vec) -> agg.add(vec);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(agg, agg2) -> agg.merge(agg2);
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        MultivariateOnlineSummarizer stats = (MultivariateOnlineSummarizer)qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        double bandwidth = 1.06 * package$.MODULE$.sqrt(stats.variance().apply(0)) * package$.MODULE$.pow((double)stats.count(), -0.2);
        return new KernelDensity().setSample(data).setBandwidth(bandwidth > 0.0 ? bandwidth : 0.06).estimate((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$28 -> (double)x$28 / 100.0, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public BinaryClassificationModelPerf.CalibrationBin[] calibrationCurve(Tuple3<Object, Object, Object>[] rawCalibrationCurve) {
        return (BinaryClassificationModelPerf.CalibrationBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawCalibrationCurve)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                double n = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double x = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double y = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                return new BinaryClassificationModelPerf.CalibrationBin(n, x, y);
            }
            throw new MatchError((Object)tuple3);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryClassificationModelPerf.CalibrationBin.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToDouble((double)x$29.x), (Ordering)Ordering.Double$.MODULE$);
    }

    public double approxMedian(RDD<Object> probaRDD) {
        SparkSession spark = SparkSession$.MODULE$.builder().config(probaRDD.sparkContext().getConf()).getOrCreate();
        Dataset probaDF = spark.implicits().rddToDatasetHolder(probaRDD, spark.implicits().newDoubleEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"proba"}));
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probaDF.stat().approxQuantile("proba", new double[]{0.5}, 0.001))).head());
    }

    public ClassificationModelIntrinsicPerf binaryClassificationIntrinsicPerf(PreTrainPredictionModelingParams.Algorithm algorithm, Model<?> model, Features features, boolean probaAware) {
        ClassificationModelIntrinsicPerf iperf;
        block11: {
            Model<?> model2;
            block10: {
                iperf = new ClassificationModelIntrinsicPerf();
                iperf.probaAware = probaAware;
                model2 = model;
                if (!(model2 instanceof LogisticRegressionModel)) break block10;
                LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)model2;
                int weightSize = com.dataiku.dip.spark.compat.package$.MODULE$.getLogitCoefficients(logisticRegressionModel).size();
                if (weightSize != features.length()) {
                    this.logger().warn((Object)new StringBuilder(37).append("Variable length (").append(features.length()).append(") != coefs length (").append(weightSize).append(")").toString());
                }
                iperf.lmCoefficients = new PredictionModelIntrinsicPerf.Coefficients();
                iperf.lmCoefficients.interceptCoef = logisticRegressionModel.intercept();
                if (weightSize <= this.MAX_COEFS()) {
                    String[] stringArray;
                    iperf.lmCoefficients.coefs = com.dataiku.dip.spark.compat.package$.MODULE$.getLogitCoefficients(logisticRegressionModel).toArray();
                    PredictionModelIntrinsicPerf.Coefficients coefficients = iperf.lmCoefficients;
                    Features features2 = features;
                    if (features2 instanceof ListFeatures) {
                        ListFeatures listFeatures = (ListFeatures)features2;
                        List<String> l = listFeatures.features();
                        stringArray = (String[])l.toArray(ClassTag$.MODULE$.apply(String.class));
                    } else {
                        stringArray = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features.length()).map((Function1)features, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                    }
                    coefficients.variables = stringArray;
                } else {
                    this.logger().warn((Object)new StringBuilder(32).append("Coefs length = ").append(weightSize).append(" > ").append(this.MAX_COEFS()).append(", not reported").toString());
                    iperf.lmCoefficients.unavailableReason = new StringBuilder(26).append("Too many coefficients ( ").append(weightSize).append(" )").toString();
                    iperf.lmCoefficients.coefs = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
                    iperf.lmCoefficients.variables = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                }
                break block11;
            }
            if (!(model2 instanceof RandomForestClassificationModel)) break block11;
            RandomForestClassificationModel randomForestClassificationModel = (RandomForestClassificationModel)model2;
            org.apache.spark.ml.linalg.Vector importances = (org.apache.spark.ml.linalg.Vector)RandomForestClassificationModel.class.getDeclaredMethod("featureImportances", new Class[0]).invoke((Object)randomForestClassificationModel, new Object[0]);
            int impSize = importances.size();
            if (impSize != features.length()) {
                this.logger().warn((Object)new StringBuilder(43).append("Variable length (").append(features.length()).append(") != importance length (").append(impSize).append("})").toString());
            }
            iperf.rawImportance = new PredictionModelIntrinsicPerf.VariablesImportance();
            if (impSize <= this.MAX_COEFS()) {
                String[] stringArray;
                iperf.rawImportance.importances = importances.toArray();
                PredictionModelIntrinsicPerf.VariablesImportance variablesImportance = iperf.rawImportance;
                Features features3 = features;
                if (features3 instanceof ListFeatures) {
                    ListFeatures listFeatures = (ListFeatures)features3;
                    List<String> l = listFeatures.features();
                    stringArray = (String[])l.toArray(ClassTag$.MODULE$.apply(String.class));
                } else {
                    stringArray = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features.length()).map((Function1)features, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                }
                variablesImportance.variables = stringArray;
            } else {
                this.logger().warn((Object)new StringBuilder(37).append("Importance length = ").append(impSize).append(" > ").append(this.MAX_COEFS()).append(", not reported").toString());
                iperf.rawImportance.unavailableReason = new StringBuilder(26).append("Too many coefficients ( ").append(impSize).append(" )").toString();
                iperf.rawImportance.importances = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
                iperf.rawImportance.variables = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }
        return iperf;
    }

    public MulticlassModelPerf multiclassClassificationPerfNP(RDD<Tuple2<Object, Object>> labelPred, long len, IndexedSeq<String> targetRemapping) {
        package.AdvancedMulticlassMetrics metrics = new package.AdvancedMulticlassMetrics(labelPred);
        MulticlassModelPerf perf = new MulticlassModelPerf();
        perf.classes = (String[])targetRemapping.toArray(ClassTag$.MODULE$.apply(String.class));
        perf.metrics.f1 = Predef$.MODULE$.double2Double(metrics.f1());
        perf.metrics.recall = Predef$.MODULE$.double2Double(metrics.averageRecall());
        perf.metrics.precision = Predef$.MODULE$.double2Double(metrics.averagePrecision());
        perf.metrics.accuracy = Predef$.MODULE$.double2Double(metrics.accuracy_());
        perf.metrics.hammingLoss = Predef$.MODULE$.double2Double(metrics.hammingLoss_());
        perf.confusion = new MulticlassModelPerf.MulticlassConfusion();
        metrics.confusion(targetRemapping).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$multiclassClassificationPerfNP$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 != null) {
                String actual = (String)tuple2._1();
                scala.collection.immutable.Map m = (scala.collection.immutable.Map)tuple2._2();
                MulticlassModelPerf.MulticlassActualClassConfusion mac = new MulticlassModelPerf.MulticlassActualClassConfusion();
                IntRef acc = IntRef.create((int)0);
                m.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$multiclassClassificationPerfNP$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$30 -> {
                    ModelScorer$.$anonfun$multiclassClassificationPerfNP$4(mac, acc, x$30);
                    return BoxedUnit.UNIT;
                });
                mac.actualClassCount = acc.elem;
                return perf$2.confusion.perActual.put(actual, mac);
            }
            throw new MatchError((Object)tuple2);
        });
        perf.confusion.totalRows = len;
        return perf;
    }

    public MulticlassModelPerf multiclassClassificationPerfNP(RDD<Tuple2<Object, Object>> labelPred, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        long fullLen = labelPred.count();
        Tuple2<RDD<Tuple2<Object, Object>>, Object> tuple2 = this.subSample(labelPred, fullLen, subSamplingSeed, this.subSample$default$4());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD sample = (RDD)tuple2._1();
        long len = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)sample, (Object)BoxesRunTime.boxToLong((long)len));
        RDD sample2 = (RDD)tuple22._1();
        long len2 = tuple22._2$mcJ$sp();
        sample2.persist();
        MulticlassModelPerf perf = this.multiclassClassificationPerfNP((RDD<Tuple2<Object, Object>>)sample2, len2, targetRemapping);
        perf.metrics.logLoss = Predef$.MODULE$.double2Double(0.0);
        perf.metrics.mrocAUC = Predef$.MODULE$.double2Double(0.5);
        sample2.unpersist(sample2.unpersist$default$1());
        return perf;
    }

    public MulticlassModelPerf multiclassClassificationPerf(RDD<Tuple3<Object, Object, double[]>> predLabelScores, IndexedSeq<String> targetRemapping, long subSamplingSeed) {
        ModelScorer.ProbabilisticMulticlassMetrics metrics = new ModelScorer.ProbabilisticMulticlassMetrics(subSamplingSeed, predLabelScores);
        MulticlassModelPerf perf = this.multiclassClassificationPerfNP((RDD<Tuple2<Object, Object>>)predLabelScores.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)r._1()), BoxesRunTime.unboxToDouble((Object)r._2())), ClassTag$.MODULE$.apply(Tuple2.class)), predLabelScores.count(), targetRemapping);
        perf.metrics.mrocAUC = Predef$.MODULE$.double2Double(metrics.mrocAUC());
        perf.metrics.logLoss = Predef$.MODULE$.double2Double(metrics.logLoss());
        perf.metrics.averagePrecision = Predef$.MODULE$.double2Double(metrics.maveragePrecision());
        ((TraversableLike)targetRemapping.zipWithIndex(scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$multiclassClassificationPerf$2(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$39 -> {
            Tuple2 tuple2 = x$39;
            if (tuple2 != null) {
                String klass = (String)tuple2._1();
                int i = tuple2._2$mcI$sp();
                double di = i;
                RDD binRDD = predLabelScores.map((Function1 & Serializable & scala.Serializable)pls -> new Tuple2.mcDD.sp(((double[])pls._3())[i], BoxesRunTime.unboxToDouble((Object)pls._2()) == di ? 1.0 : 0.0), ClassTag$.MODULE$.apply(Tuple2.class));
                BinaryClassificationMetrics binMetrics = new BinaryClassificationMetrics(binRDD, BinaryClassificationPerf$.MODULE$.CUT_BINS());
                perf$3.oneVsAllRocAUC.put(klass, Predef$.MODULE$.double2Double(binMetrics.areaUnderROC()));
                perf$3.oneVsAllRocCurves.put(klass, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.rocViz(binMetrics, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])binMetrics.thresholds().collect())).reverse()))).toList()));
                perf$3.oneVsAllAveragePrecision.put(klass, Predef$.MODULE$.double2Double(MODULE$.averagePrecisionScore((RDD<Tuple2<Object, Object>>)binRDD)));
                perf$3.oneVsAllPrCurves.put(klass, MODULE$.prViz(binMetrics, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])binMetrics.thresholds().collect())).reverse()));
                Tuple3<Object, Object, Object>[] rawCalibrationCurve = Calibration$.MODULE$.rawCurve((RDD<Tuple2<Object, Object>>)binRDD);
                perf$3.oneVsAllCalibrationCurves.put(klass, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.calibrationCurve(rawCalibrationCurve))).toList()));
                double calibrationLoss = Calibration$.MODULE$.calibrationLoss(rawCalibrationCurve);
                return perf$3.oneVsAllCalibrationLoss.put(klass, Predef$.MODULE$.double2Double(calibrationLoss));
            }
            throw new MatchError((Object)tuple2);
        });
        perf.metrics.mcalibrationLoss = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(perf.oneVsAllCalibrationLoss.values()).map((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToDouble((double)x$40), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)perf.classes.length);
        return perf;
    }

    public Tuple2<Object, Object> cumError(double predicted, double actual, double cumErrR, int count) {
        if (actual == 0.0) {
            return new Tuple2.mcDI.sp(cumErrR, predicted == 0.0 ? count + 1 : count);
        }
        return new Tuple2.mcDI.sp(cumErrR + package$.MODULE$.abs((predicted - actual) / actual), count + 1);
    }

    public RegressionModelPerf.RegressionMetrics regressionMetrics(RDD<Tuple2<Object, Object>> sample) {
        ModelScorer.AdvancedRegressionMetrics metrics = new ModelScorer.AdvancedRegressionMetrics(sample);
        RegressionModelPerf.RegressionMetrics regressionMetrics = new RegressionModelPerf.RegressionMetrics();
        regressionMetrics.r2 = Predef$.MODULE$.double2Double(metrics.r2());
        regressionMetrics.mse = Predef$.MODULE$.double2Double(metrics.meanSquaredError());
        regressionMetrics.rmse = Predef$.MODULE$.double2Double(metrics.rootMeanSquaredError());
        regressionMetrics.evs = Predef$.MODULE$.double2Double(metrics.evs());
        regressionMetrics.mae = Predef$.MODULE$.double2Double(metrics.meanAbsoluteError());
        regressionMetrics.mape = Predef$.MODULE$.double2Double(metrics.mape());
        regressionMetrics.rmsle = Predef$.MODULE$.double2Double(metrics.rmsle());
        regressionMetrics.pearson = Predef$.MODULE$.double2Double(metrics.pearson());
        return regressionMetrics;
    }

    public RegressionModelPerf regressionPerf(RDD<Tuple2<Object, Object>> predObs, long subSamplingSeed) {
        long fullLen = predObs.count();
        Tuple2<RDD<Tuple2<Object, Object>>, Object> tuple2 = this.subSample(predObs, fullLen, subSamplingSeed, this.subSample$default$4());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RDD sample = (RDD)tuple2._1();
        long len = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)sample, (Object)BoxesRunTime.boxToLong((long)len));
        RDD sample2 = (RDD)tuple22._1();
        long len2 = tuple22._2$mcJ$sp();
        sample2.persist();
        long exactLen = sample2.count();
        RegressionModelPerf perf = new RegressionModelPerf();
        perf.metrics = this.regressionMetrics((RDD<Tuple2<Object, Object>>)sample2);
        Tuple2[] plot = (Tuple2[])((RDD)this.subSample(sample2, len2, subSamplingSeed, this.PLOT_SAMPLE_SIZE())._1()).collect();
        perf.scatterPlotData = new RegressionModelPerf.ScatterplotData();
        perf.scatterPlotData.y = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])plot)).map((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToDouble((double)x$46._1$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        perf.scatterPlotData.x = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])plot)).map((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToDouble((double)x$47._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        perf.regression_performance = new RegressionModelPerf.RegressionPerformance();
        RDD ascErrData = sample2.map((Function1 & Serializable & scala.Serializable)po -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$regressionPerf$3(po)), ClassTag$.MODULE$.Double()).sortBy((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)a -> a, true, 1, (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
        StatCounter errStats = (StatCounter)ascErrData.aggregate((Object)StatCounter$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(counter, err) -> counter.merge(BoxesRunTime.unboxToDouble((Object)err)), (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.merge(c2), ClassTag$.MODULE$.apply(StatCounter.class));
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(errStats.min(), errStats.max());
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double errMin = sp2._1$mcD$sp();
        double errMax = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(errMin, errMax);
        double errMin2 = sp3._1$mcD$sp();
        double errMax2 = sp3._2$mcD$sp();
        perf.regression_performance.min_error = errMin2;
        perf.regression_performance.max_error = errMax2;
        perf.regression_performance.average_error = errStats.mean();
        perf.regression_performance.std_error = errStats.sampleStdev();
        long[] errQuantiles = new long[]{exactLen / 4L, exactLen / 2L, exactLen * 3L / 4L, exactLen * 9L / 10L};
        double errBinWidth = (errMax2 - errMin2) / (double)this.ERROR_BINS();
        scala.collection.immutable.IndexedSeq errBinMin = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.ERROR_BINS()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> errMin2 + (double)i * errBinWidth, IndexedSeq$.MODULE$.canBuildFrom());
        Tuple3 errAgg = new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(errQuantiles)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$49 -> 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.fill(errBinMin.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int()));
        Tuple3 tuple3 = (Tuple3)ascErrData.aggregate((Object)errAgg, (Function2 & Serializable & scala.Serializable)(agg, err) -> ModelScorer$.$anonfun$regressionPerf$10(errQuantiles, errBinMin, errBinWidth, agg, BoxesRunTime.unboxToDouble((Object)err)), (Function2 & Serializable & scala.Serializable)(a, b) -> {
            if (BoxesRunTime.unboxToLong((Object)a._1()) == 0L) {
                return b;
            }
            if (BoxesRunTime.unboxToLong((Object)b._1()) == 0L) {
                return a;
            }
            throw new IllegalStateException(new StringBuilder(39).append("Can't parallelize sorted iteration:\t\n").append(a).append("\t\n").append(b).toString());
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double[] quantiles = (double[])tuple3._2();
        int[] bins = (int[])tuple3._3();
        Tuple2 tuple23 = new Tuple2((Object)quantiles, (Object)bins);
        double[] quantiles2 = (double[])tuple23._1();
        int[] bins2 = (int[])tuple23._2();
        perf.regression_performance.p25_error = quantiles2[0];
        perf.regression_performance.median_error = quantiles2[1];
        perf.regression_performance.p75_error = quantiles2[2];
        perf.regression_performance.p90_error = quantiles2[3];
        perf.regression_performance.error_distribution = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)((TraversableOnce)ZippedTraversable3$.MODULE$.zippedTraversable3ToTraversable((ZippedTraversable3)new Tuple3Zipped(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)errBinMin.indices(), (Object)errBinMin, (Object)bins2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms(), (Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(xs))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$regressionPerf$16(check$ifrefutable$6))).map((Function1 & Serializable & scala.Serializable)x$53 -> {
            Tuple3 tuple3 = x$53;
            if (tuple3 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
                double min = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                int pop = BoxesRunTime.unboxToInt((Object)tuple3._3());
                PredictionModelPerf.HistogramBin bin = new PredictionModelPerf.HistogramBin();
                bin.bin_id = i;
                bin.bin_min = min;
                bin.bin_max = min + errBinWidth;
                bin.count = pop;
                return bin;
            }
            throw new MatchError((Object)tuple3);
        }, Traversable$.MODULE$.canBuildFrom())).toList());
        sample2.unpersist(sample2.unpersist$default$1());
        return perf;
    }

    public RegressionModelIntrinsicPerf regressionIntrinsicPerf(PreTrainPredictionModelingParams.Algorithm algorithm, Model<?> model, Features features) {
        RegressionModelIntrinsicPerf iperf;
        block5: {
            iperf = new RegressionModelIntrinsicPerf();
            Model<?> model2 = model;
            if (!(model2 instanceof LinearRegressionModel)) break block5;
            LinearRegressionModel linearRegressionModel = (LinearRegressionModel)model2;
            int weightSize = com.dataiku.dip.spark.compat.package$.MODULE$.getLinregCoefficients(linearRegressionModel).size();
            if (weightSize != features.length()) {
                this.logger().warn((Object)new StringBuilder(47).append("Variable length (").append(features.length()).append(") != coefs length (weightSize)").toString());
            }
            iperf.lmCoefficients = new PredictionModelIntrinsicPerf.Coefficients();
            iperf.lmCoefficients.interceptCoef = linearRegressionModel.intercept();
            if (weightSize <= this.MAX_COEFS()) {
                String[] stringArray;
                iperf.lmCoefficients.coefs = com.dataiku.dip.spark.compat.package$.MODULE$.getLinregCoefficients(linearRegressionModel).toArray();
                PredictionModelIntrinsicPerf.Coefficients coefficients = iperf.lmCoefficients;
                Features features2 = features;
                if (features2 instanceof ListFeatures) {
                    ListFeatures listFeatures = (ListFeatures)features2;
                    List<String> l = listFeatures.features();
                    stringArray = (String[])l.toArray(ClassTag$.MODULE$.apply(String.class));
                } else {
                    stringArray = (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features.length()).map((Function1)features, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                }
                coefficients.variables = stringArray;
            } else {
                this.logger().warn((Object)new StringBuilder(32).append("Coefs length = ").append(weightSize).append(" > ").append(this.MAX_COEFS()).append(", not reported").toString());
                iperf.lmCoefficients.unavailableReason = new StringBuilder(26).append("Too many coefficients ( ").append(weightSize).append(" )").toString();
                iperf.lmCoefficients.coefs = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
                iperf.lmCoefficients.variables = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }
        return iperf;
    }

    public Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ double $anonfun$binaryClassificationPerf$12(Tuple3 x$6) {
        return ((org.apache.spark.ml.linalg.Vector)x$6._3()).apply(1);
    }

    public static final /* synthetic */ BinaryClassificationModelPerf.LiftBin $anonfun$binaryClassificationPerf$22(long len$1, double targetDensity$1, long positives$1, long binLift, int i, long max) {
        BinaryClassificationModelPerf.LiftBin bin = new BinaryClassificationModelPerf.LiftBin();
        bin.percentile_idx = i;
        bin.cum_size = (double)max / (double)len$1;
        bin.bin_lift = (double)binLift / (double)max / targetDensity$1;
        bin.cum_lift = (double)binLift / (double)positives$1;
        return bin;
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationPerf$23(List check$ifrefutable$1) {
        List list = check$ifrefutable$1;
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        return !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0;
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationPerf$24(List x$13) {
        List list = x$13;
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
            BinaryClassificationModelPerf.LiftBin prev = (BinaryClassificationModelPerf.LiftBin)((LinearSeqOptimized)some.get()).apply(0);
            BinaryClassificationModelPerf.LiftBin cur = (BinaryClassificationModelPerf.LiftBin)((LinearSeqOptimized)some.get()).apply(1);
            cur.cum_lift += prev.cum_lift;
            return;
        }
        throw new MatchError((Object)list);
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationPerf$26(double c$1, Tuple3 r) {
        return BoxesRunTime.unboxToDouble((Object)r._1()) == c$1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$binaryClassificationPerf$25(RDD rdd$1, double c) {
        RDD c_rdd = rdd$1.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$binaryClassificationPerf$26(c, r)));
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)c), (Object)c_rdd);
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationPerf$28(double c$2, Tuple3 x$14) {
        return BoxesRunTime.unboxToDouble((Object)x$14._2()) == c$2;
    }

    public static final /* synthetic */ double $anonfun$binaryClassificationPerf$29(Tuple3 x$15) {
        return ((org.apache.spark.ml.linalg.Vector)x$15._3()).apply(1);
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationPerf$30(double c$2, Tuple3 x$16) {
        return BoxesRunTime.unboxToDouble((Object)x$16._2()) != c$2;
    }

    public static final /* synthetic */ double $anonfun$binaryClassificationPerf$31(Tuple3 x$17) {
        return ((org.apache.spark.ml.linalg.Vector)x$17._3()).apply(1);
    }

    public static final /* synthetic */ void $anonfun$averagePrecisionScore$2(BooleanRef head$1, ObjectRef firstPoint$1, ObjectRef lastPoint$1, DoubleRef localArea$1, Seq points) {
        if (head$1.elem) {
            firstPoint$1.elem = (Tuple2)points.head();
            head$1.elem = false;
        }
        lastPoint$1.elem = (Tuple2)points.last();
        if (points.length() == 2) {
            localArea$1.elem += MODULE$.weightedPrecision((Seq<Tuple2<Object, Object>>)points);
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$averagePrecisionScore$5(Seq x0$1) {
        Seq seq = x0$1;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
            Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
            if (tuple2 != null) {
                Tuple2 last1 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Tuple2 first2 = (Tuple2)tuple22._1();
                    return MODULE$.weightedPrecision((Seq<Tuple2<Object, Object>>)((Seq)new .colon.colon((Object)last1, (List)new .colon.colon((Object)first2, (List)Nil$.MODULE$))));
                }
            }
        }
        throw new MatchError((Object)seq);
    }

    public static final /* synthetic */ double $anonfun$computePredictionInfos$3(int c$3, Tuple2 x$24) {
        return ((org.apache.spark.ml.linalg.Vector)x$24._2()).apply(c$3);
    }

    public static final /* synthetic */ double $anonfun$computePredictionInfos$4(int c$3, Tuple2 x$25) {
        return ((org.apache.spark.ml.linalg.Vector)x$25._2()).apply(c$3);
    }

    public static final /* synthetic */ ClassificationModelPredictionInfos.ClassProbabilityDensity $anonfun$computePredictionInfos$2(RDD predsAndProbasRDD$1, ClassificationModelPredictionInfos pred$1, IndexedSeq targetRemapping$2, int c) {
        ClassificationModelPredictionInfos.ClassProbabilityDensity density = new ClassificationModelPredictionInfos.ClassProbabilityDensity();
        density.density = MODULE$.probaDensityOrEmptyArray((RDD<Object>)predsAndProbasRDD$1.map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$computePredictionInfos$3(c, x$24)), ClassTag$.MODULE$.Double()));
        density.median = MODULE$.approxMedian((RDD<Object>)predsAndProbasRDD$1.map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToDouble((double)ModelScorer$.$anonfun$computePredictionInfos$4(c, x$25)), ClassTag$.MODULE$.Double()));
        return pred$1.probabilityDensities.put(targetRemapping$2.apply(c), density);
    }

    public static final /* synthetic */ boolean $anonfun$prViz$2(Product sl) {
        return BoxesRunTime.equals((Object)sl.productElement(1), (Object)BoxesRunTime.boxToFloat((float)1.0f));
    }

    public static final /* synthetic */ boolean $anonfun$multiclassClassificationPerfNP$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$multiclassClassificationPerfNP$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$multiclassClassificationPerfNP$4(MulticlassModelPerf.MulticlassActualClassConfusion mac$1, IntRef acc$1, Tuple2 x$30) {
        Tuple2 tuple2 = x$30;
        if (tuple2 != null) {
            String predicted = (String)tuple2._1();
            double count = tuple2._2$mcD$sp();
            mac$1.perPredicted.put(predicted, Predef$.MODULE$.double2Double((double)((int)count)));
            acc$1.elem += (int)count;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$multiclassClassificationPerf$2(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        return tuple2 != null;
    }

    public static final /* synthetic */ double $anonfun$regressionPerf$3(Tuple2 po) {
        return po._2$mcD$sp() - po._1$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$regressionPerf$11(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$regressionPerf$12(double err$1, double errBinWidth$1, Tuple3 agg$1, Tuple2 x$50) {
        Tuple2 tuple2 = x$50;
        if (tuple2 != null) {
            double min = tuple2._1$mcD$sp();
            int bin = tuple2._2$mcI$sp();
            return err$1 >= min && (err$1 < min + errBinWidth$1 || bin == ((double[])agg$1._2()).length - 1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$regressionPerf$13(Tuple3 agg$1, Tuple2 x$51) {
        Tuple2 tuple2 = x$51;
        if (tuple2 != null) {
            int bin = tuple2._2$mcI$sp();
            ((int[])agg$1._3())[bin] = ((int[])agg$1._3())[bin] + 1;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple3 $anonfun$regressionPerf$10(long[] errQuantiles$1, scala.collection.immutable.IndexedSeq errBinMin$1, double errBinWidth$1, Tuple3 agg, double err) {
        long pop = BoxesRunTime.unboxToLong((Object)agg._1()) + 1L;
        int qi = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(errQuantiles$1)).indexOf((Object)BoxesRunTime.boxToLong((long)pop));
        if (qi >= 0) {
            ((double[])agg._2())[qi] = err;
        }
        ((TraversableLike)errBinMin$1.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$regressionPerf$11(check$ifrefutable$5))).withFilter((Function1 & Serializable & scala.Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)ModelScorer$.$anonfun$regressionPerf$12(err, errBinWidth$1, agg, x$50))).foreach((Function1 & Serializable & scala.Serializable)x$51 -> {
            ModelScorer$.$anonfun$regressionPerf$13(agg, x$51);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)pop), agg._2(), agg._3());
    }

    public static final /* synthetic */ boolean $anonfun$regressionPerf$16(Tuple3 check$ifrefutable$6) {
        Tuple3 tuple3 = check$ifrefutable$6;
        return tuple3 != null;
    }

    private ModelScorer$() {
        MODULE$ = this;
        this.LIFT_BINS = 10;
        this.ERROR_BINS = 10;
        this.SAMPLE_SIZE = 1000000L;
        this.PLOT_SAMPLE_SIZE = 1000L;
        this.MAX_COEFS = 1000;
        this.LIMIT_NVAR_FOR_MRAUC = 50;
        this.FURTHER_SAMPLE_SIZE = 30000;
        this.logger = Logger.getLogger((String)"dku.spark.mllib");
    }
}

