/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.notebook;

import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobFilesInitialFetchRequest;
import com.dataiku.dip.spark.notebook.DkuAddFiles;
import com.dataiku.dip.spark.notebook.DkuRegisterDataset;
import com.dataiku.dip.spark.notebook.DkuRemoteDatasetRead;
import com.dataiku.dip.spark.notebook.DkuRemoteNextBatch;
import com.dataiku.dip.spark.notebook.DkuRemoteSparkSQLAndScriptStatement;
import com.dataiku.dip.spark.notebook.DkuRemoteSparkSQLPreparedStatement;
import com.dataiku.dip.spark.notebook.DkuRemoteSparkSQLStatement;
import com.dataiku.dip.spark.notebook.DkuStopContext;
import com.dataiku.dip.spark.package$;
import com.dataiku.dip.spark.sparksql.RemotedSparkSQLHandler;
import com.dataiku.dip.spark.submit.DKUSparkKubernetesEntrypoint;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class InteractiveSparkSQLEntryPoint$
implements App {
    public static InteractiveSparkSQLEntryPoint$ MODULE$;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new InteractiveSparkSQLEntryPoint$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public void main(String[] args) {
        block20: {
            if (args.length != 1) {
                System.err.println("usage: InteractiveSparkSQLEntryPoint port");
                System.exit(1);
            }
            Logger logger = Logger.getLogger((String)"dku.spark.interactive.sparkSQL");
            try {
                com.dataiku.dip.utils.package$.MODULE$.initializeApplication(com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$1(), com.dataiku.dip.utils.package$.MODULE$.initializeApplication$default$2());
                String backendHost = com.dataiku.dip.remoterun.package$.MODULE$.getOrElse("DKU_BACKEND_HOST", InetAddress.getLocalHost().getHostName());
                int port = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
                logger.info((Object)new StringBuilder(23).append("Using host for backend ").append(backendHost).toString());
                logger.info((Object)new StringBuilder(23).append("Using port for backend ").append(port).toString());
                JavaBlockLink link = new JavaBlockLink();
                link.setSocket(new Socket(backendHost, port));
                logger.info((Object)"Connected.");
                try {
                    logger.info((Object)"Creating Spark context");
                    SparkConf conf = new SparkConf();
                    SparkJobExecEnv execEnv = com.dataiku.dip.remoterun.package$.MODULE$.getJobExecEnv();
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(execEnv.additionalSparkConf).asScala()).foreach((Function1 & Serializable & scala.Serializable)cdp -> conf.set(cdp.name, cdp.value));
                    SparkContext sc = new SparkContext(conf);
                    SparkJobFilesInitialFetchRequest fr = DKUSparkKubernetesEntrypoint.getFetchRequest();
                    if (fr != null) {
                        ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(fr.pathsToDistribute).asScala()).toList().foreach((Function1 & Serializable & scala.Serializable)path -> {
                            sc.addFile(path);
                            return BoxedUnit.UNIT;
                        });
                    }
                    package$.MODULE$.addRemoteRunEnvDefForExecutors(sc);
                    boolean running = true;
                    boolean stopped = false;
                    while (running) {
                        logger.info((Object)"Waiting for command");
                        JsonObject commandJson = (JsonObject)link.receiveJsonResponse(JsonObject.class);
                        if (commandJson == null) {
                            logger.info((Object)"Closed from backend side");
                            running = false;
                            continue;
                        }
                        logger.info((Object)new StringBuilder(17).append("Received command ").append(commandJson.get("type").getAsString()).toString());
                        String string = commandJson.get("type").getAsString();
                        if ("ping".equals(string)) {
                            link.sendStringRequest("pong");
                            continue;
                        }
                        if ("registerDataset".equals(string)) {
                            List filteredPartitions;
                            RemotedSparkSQLHandler.RegisterDatasetCommand registerDatasetCommand = (RemotedSparkSQLHandler.RegisterDatasetCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.RegisterDatasetCommand.class);
                            None$ partitions = None$.MODULE$;
                            if (registerDatasetCommand.partitions != null && (filteredPartitions = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(registerDatasetCommand.partitions).asScala()).toList().collect((PartialFunction)new scala.Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1;
                                    A1 A12 = A1 = x1;
                                    String string = "ALL";
                                    if (A12 == null ? string != null : !A12.equals(string)) {
                                        return (B1)A1;
                                    }
                                    return (B1)function1.apply(x1);
                                }

                                public final boolean isDefinedAt(String x1) {
                                    String string;
                                    String string2 = string = x1;
                                    String string3 = "ALL";
                                    return string2 == null ? string3 != null : !string2.equals(string3);
                                }
                            }, List$.MODULE$.canBuildFrom())).nonEmpty()) {
                                partitions = new Some((Object)filteredPartitions);
                            }
                            DkuRegisterDataset registerer = new DkuRegisterDataset(registerDatasetCommand.database, registerDatasetCommand.datasetFullName, registerDatasetCommand.tableName, JSON.json((Object)registerDatasetCommand.datasetEnv), (List<String>)((List)partitions.orNull(Predef$.MODULE$.$conforms())));
                            link.sendStringRequest(registerer.doRegisterDataset(sc));
                            continue;
                        }
                        if ("readDataset".equals(string)) {
                            RemotedSparkSQLHandler.ReadDatasetCommand readDatasetCommand = (RemotedSparkSQLHandler.ReadDatasetCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.ReadDatasetCommand.class);
                            DkuRemoteDatasetRead executor = new DkuRemoteDatasetRead(readDatasetCommand.dataset, JSON.json((Object)readDatasetCommand.datasetEnv), readDatasetCommand.sampling, (List<String>)(readDatasetCommand.partitions == null ? null : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(readDatasetCommand.partitions).asScala()).toList()), readDatasetCommand.columnNames == null ? null : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(readDatasetCommand.columnNames).asScala()).toList(), readDatasetCommand.filterExpression);
                            link.sendRequest((Object)executor.doReadDataset(sc));
                            continue;
                        }
                        if ("prepareSQL".equals(string)) {
                            RemotedSparkSQLHandler.PrepareSQLCommand prepareSQLCommand = (RemotedSparkSQLHandler.PrepareSQLCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.PrepareSQLCommand.class);
                            DkuRemoteSparkSQLPreparedStatement executor = new DkuRemoteSparkSQLPreparedStatement(prepareSQLCommand.database, prepareSQLCommand.sql);
                            link.sendRequest((Object)executor.doPrepareSQL(sc));
                            continue;
                        }
                        if ("executeSQL".equals(string)) {
                            RemotedSparkSQLHandler.ExecuteSQLCommand executeSQLCommand = (RemotedSparkSQLHandler.ExecuteSQLCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.ExecuteSQLCommand.class);
                            DkuRemoteSparkSQLStatement executor = new DkuRemoteSparkSQLStatement(executeSQLCommand.database, Predef$.MODULE$.int2Integer(executeSQLCommand.fetchSize), executeSQLCommand.sql);
                            link.sendRequest((Object)executor.doExecuteSQL(sc));
                            continue;
                        }
                        if ("executeSQLAndScript".equals(string)) {
                            RemotedSparkSQLHandler.ExecuteSQLAndScriptCommand executeSQLAndScriptCommand = (RemotedSparkSQLHandler.ExecuteSQLAndScriptCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.ExecuteSQLAndScriptCommand.class);
                            DkuRemoteSparkSQLAndScriptStatement executor = new DkuRemoteSparkSQLAndScriptStatement(executeSQLAndScriptCommand.database, Predef$.MODULE$.int2Integer(executeSQLAndScriptCommand.fetchSize), executeSQLAndScriptCommand.sql, JSON.json((Object)executeSQLAndScriptCommand.scriptSteps), JSON.json((Object)executeSQLAndScriptCommand.scriptOutputSchema), executeSQLAndScriptCommand.reportLocation, JSON.json((Object)executeSQLAndScriptCommand.resourceMapping));
                            link.sendRequest((Object)executor.doExecuteSQL(sc));
                            continue;
                        }
                        if ("nextBatch".equals(string)) {
                            RemotedSparkSQLHandler.NextBatchCommand nextBacthCommand = (RemotedSparkSQLHandler.NextBatchCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.NextBatchCommand.class);
                            DkuRemoteNextBatch executor = new DkuRemoteNextBatch(Predef$.MODULE$.int2Integer(nextBacthCommand.fetchSize), nextBacthCommand.sql);
                            link.sendRequest((Object)executor.doNextBatch());
                            continue;
                        }
                        if ("addFiles".equals(string)) {
                            RemotedSparkSQLHandler.AddFilesCommand addFilesCommand = (RemotedSparkSQLHandler.AddFilesCommand)JSON.parse((JsonElement)commandJson, RemotedSparkSQLHandler.AddFilesCommand.class);
                            DkuAddFiles executor = new DkuAddFiles(addFilesCommand.executionId, JSON.json((Object)addFilesCommand.resourceMapping));
                            link.sendRequest((Object)executor.doAddFiles(sc));
                            continue;
                        }
                        if ("stopContext".equals(string)) {
                            DkuStopContext executor = new DkuStopContext();
                            link.sendRequest((Object)executor.doStop(sc));
                            running = false;
                            stopped = true;
                            continue;
                        }
                        throw new MatchError((Object)string);
                    }
                    if (stopped) break block20;
                    com.dataiku.dip.remoterun.package$.MODULE$.exitWhenDoneIfNeeded(sc);
                }
                finally {
                    if (link.hasSocket()) {
                        link.sendNullCommand();
                        link.close();
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Failure while evaluating sparksql", t);
                com.dataiku.dip.remoterun.package$.MODULE$.storeError(t);
                System.exit(1);
            }
        }
    }

    private InteractiveSparkSQLEntryPoint$() {
        MODULE$ = this;
        App.$init$((App)this);
    }
}

