/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.oracle;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.oracle.OracleQuery;
import java.sql.Connection;
import javax.inject.Provider;

@BridgeMethodsAdded
public abstract class AbstractOracleQuery<T, C extends AbstractOracleQuery<T, C>>
extends AbstractSQLQuery<T, C> {
    protected static final String CONNECT_BY = "\nconnect by ";
    protected static final String CONNECT_BY_NOCYCLE_PRIOR = "\nconnect by nocycle prior ";
    protected static final String CONNECT_BY_PRIOR = "\nconnect by prior ";
    protected static final String ORDER_SIBLINGS_BY = "\norder siblings by ";
    protected static final String START_WITH = "\nstart with ";

    public AbstractOracleQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public AbstractOracleQuery(Provider<Connection> connProvider, Configuration configuration, QueryMetadata metadata) {
        super(connProvider, configuration, metadata);
    }

    @WithBridgeMethods(value={OracleQuery.class}, castRequired=true)
    public C connectByPrior(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_PRIOR, (Expression)cond));
    }

    @WithBridgeMethods(value={OracleQuery.class}, castRequired=true)
    public C connectBy(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY, (Expression)cond));
    }

    @WithBridgeMethods(value={OracleQuery.class}, castRequired=true)
    public C connectByNocyclePrior(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, CONNECT_BY_NOCYCLE_PRIOR, (Expression)cond));
    }

    @WithBridgeMethods(value={OracleQuery.class}, castRequired=true)
    public <A> C startWith(Predicate cond) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, START_WITH, (Expression)cond));
    }

    @WithBridgeMethods(value={OracleQuery.class}, castRequired=true)
    public C orderSiblingsBy(Expression<?> path) {
        return (C)((AbstractOracleQuery)this.addFlag(QueryFlag.Position.BEFORE_ORDER, ORDER_SIBLINGS_BY, (Expression)path));
    }
}

