/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import java.util.Collections;
import java.util.List;

public interface Request {
    public static final ParsedRequestFactory factory = new ParsedRequestFactory(){

        @Override
        public ParsedRequest parsedRequest(Request request, List<Pair> params) {
            return new ParsedRequest(request.scheme() == null ? null : request.scheme().toUpperCase(), request.host(), request.port(), request.method() == null ? null : request.method().toUpperCase(), request.path(), params);
        }
    };

    public String authHeader();

    public String body();

    public String contentType();

    public String host();

    public String method();

    public String path();

    public int port();

    public String queryString();

    public String scheme();

    public static class ParsedRequest {
        private final String scheme;
        private final String host;
        private final int port;
        private final String verb;
        private final String path;
        private final List<Pair> params;

        public ParsedRequest(String scheme, String host, int port, String verb, String path, List<Pair> params) {
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.verb = verb;
            this.path = path;
            this.params = Collections.unmodifiableList(params);
        }

        public String scheme() {
            return this.scheme;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String verb() {
            return this.verb;
        }

        public String path() {
            return this.path;
        }

        public List<Pair> params() {
            return this.params;
        }

        public String toString() {
            return "ParsedRequest{scheme='" + this.scheme + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", verb='" + this.verb + '\'' + ", path='" + this.path + '\'' + ", params=" + this.params + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParsedRequest that = (ParsedRequest)o;
            if (this.port != that.port) {
                return false;
            }
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
                return false;
            }
            if (this.params != null ? !((Object)this.params).equals(that.params) : that.params != null) {
                return false;
            }
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
                return false;
            }
            if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
                return false;
            }
            return !(this.verb != null ? !this.verb.equals(that.verb) : that.verb != null);
        }

        public int hashCode() {
            int result = this.scheme != null ? this.scheme.hashCode() : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + this.port;
            result = 31 * result + (this.verb != null ? this.verb.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
            return result;
        }
    }

    public static class Pair {
        public final String key;
        public final String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            if (this.key != null ? !this.key.equals(pair.key) : pair.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(pair.value) : pair.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Pair{key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static interface ParsedRequestFactory {
        public ParsedRequest parsedRequest(Request var1, List<Pair> var2);
    }
}

