/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.server.pg.PgServer;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CaseInsensitiveMap;

public class PgServerThread
implements Runnable {
    private final PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private int secret;
    private JdbcStatement activeRequest;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO";
    private final HashMap<String, Prepared> prepared = new CaseInsensitiveMap<Prepared>();
    private final HashMap<String, Portal> portals = new CaseInsensitiveMap<Portal>();

    PgServerThread(Socket socket, PgServer pgServer) {
        this.server = pgServer;
        this.socket = socket;
        this.secret = (int)MathUtils.secureRandomLong();
    }

    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream inputStream = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(inputStream);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.dataIn.read()) > 0) {
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] byArray) throws IOException {
        this.dataIn.readFully(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process() throws IOException {
        if (this.initDone) {
            var1_1 = this.dataInRaw.read();
            if (var1_1 < 0) {
                this.stop = true;
                return;
            }
        } else {
            var1_1 = 0;
        }
        var2_2 = this.dataInRaw.readInt();
        var3_3 = DataUtils.newBytes(var2_2 -= 4);
        this.dataInRaw.readFully(var3_3, 0, var2_2);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(var3_3, 0, var2_2));
        switch (var1_1) {
            case 0: {
                this.server.trace("Init");
                var4_4 = this.readInt();
                if (var4_4 == 80877102) {
                    this.server.trace("CancelRequest");
                    var5_5 = this.readInt();
                    var6_14 = this.readInt();
                    var7_24 = this.server.getThread(var5_5);
                    if (var7_24 != null && var6_14 == var7_24.secret) {
                        var7_24.cancelRequest();
                    } else {
                        this.server.trace("Invalid CancelRequest: pid=" + var5_5 + ", key=" + var6_14);
                    }
                    this.close();
                    break;
                }
                if (var4_4 == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + var4_4 + " (" + (var4_4 >> 16) + "." + (var4_4 & 255) + ")");
                while ((var5_6 = this.readString()).length() != 0) {
                    var6_15 = this.readString();
                    if ("user".equals(var5_6)) {
                        this.userName = var6_15;
                    } else if ("database".equals(var5_6)) {
                        this.databaseName = this.server.checkKeyAndGetDatabaseName(var6_15);
                    } else if ("client_encoding".equals(var5_6)) {
                        this.clientEncoding = var6_15;
                    } else if ("DateStyle".equals(var5_6)) {
                        this.dateStyle = var6_15;
                    }
                    this.server.trace(" param " + var5_6 + "=" + var6_15);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                var5_7 = this.readString();
                try {
                    var6_16 = new Properties();
                    var6_16.put("MODE", "PostgreSQL");
                    var6_16.put("USER", this.userName);
                    var6_16.put("PASSWORD", var5_7);
                    var7_25 = "jdbc:h2:" + this.databaseName;
                    var8_34 = new ConnectionInfo(var7_25, var6_16);
                    var9_41 = this.server.getBaseDir();
                    if (var9_41 == null) {
                        var9_41 = SysProperties.getBaseDir();
                    }
                    if (var9_41 != null) {
                        var8_34.setBaseDir(var9_41);
                    }
                    if (this.server.getIfExists()) {
                        var8_34.setProperty("IFEXISTS", "TRUE");
                    }
                    this.conn = new JdbcConnection(var8_34, false);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception var6_17) {
                    var6_17.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                var5_8 = new Prepared();
                var5_8.name = this.readString();
                var5_8.sql = this.getSQL(this.readString());
                var6_18 = this.readShort();
                var5_8.paramType = new int[var6_18];
                for (var7_26 = 0; var7_26 < var6_18; ++var7_26) {
                    var8_35 = this.readInt();
                    this.server.checkType(var8_35);
                    var5_8.paramType[var7_26] = var8_35;
                }
                try {
                    var5_8.prep = (JdbcPreparedStatement)this.conn.prepareStatement(var5_8.sql);
                    this.prepared.put(var5_8.name, var5_8);
                    this.sendParseComplete();
                }
                catch (Exception var7_27) {
                    this.sendErrorResponse(var7_27);
                }
                break;
            }
            case 66: {
                this.server.trace("Bind");
                var5_9 = new Portal();
                var5_9.name = this.readString();
                var6_19 = this.readString();
                var7_28 = this.prepared.get(var6_19);
                if (var7_28 == null) {
                    this.sendErrorResponse("Prepared not found");
                    break;
                }
                var5_9.prep = var7_28;
                this.portals.put(var5_9.name, var5_9);
                var8_36 = this.readShort();
                var9_42 = new int[var8_36];
                for (var10_47 = 0; var10_47 < var8_36; ++var10_47) {
                    var9_42[var10_47] = this.readShort();
                }
                var10_47 = this.readShort();
                try {
                    for (var11_51 = 0; var11_51 < var10_47; ++var11_51) {
                        this.setParameter(var7_28.prep, var7_28.paramType[var11_51], var11_51, var9_42);
                    }
                }
                catch (Exception var11_52) {
                    this.sendErrorResponse(var11_52);
                    break;
                }
                var11_51 = this.readShort();
                var5_9.resultColumnFormat = new int[var11_51];
                for (var12_56 = 0; var12_56 < var11_51; ++var12_56) {
                    var5_9.resultColumnFormat[var12_56] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 67: {
                var5_10 = (char)this.readByte();
                var6_20 = this.readString();
                this.server.trace("Close");
                if (var5_10 == 'S') {
                    var7_29 = this.prepared.remove(var6_20);
                    if (var7_29 != null) {
                        JdbcUtils.closeSilently(var7_29.prep);
                    }
                } else if (var5_10 == 'P') {
                    this.portals.remove(var6_20);
                } else {
                    this.server.trace("expected S or P, got " + var5_10);
                    this.sendErrorResponse("expected S or P");
                    break;
                }
                this.sendCloseComplete();
                break;
            }
            case 68: {
                var5_11 = (char)this.readByte();
                var6_21 = this.readString();
                this.server.trace("Describe");
                if (var5_11 == 'S') {
                    var7_30 = this.prepared.get(var6_21);
                    if (var7_30 == null) {
                        this.sendErrorResponse("Prepared not found: " + var6_21);
                        break;
                    }
                    this.sendParameterDescription(var7_30);
                    break;
                }
                if (var5_11 == 'P') {
                    var7_31 = this.portals.get(var6_21);
                    if (var7_31 == null) {
                        this.sendErrorResponse("Portal not found: " + var6_21);
                        break;
                    }
                    var8_37 = var7_31.prep.prep;
                    try {
                        var9_43 = var8_37.getMetaData();
                        this.sendRowDescription(var9_43);
                    }
                    catch (Exception var9_44) {
                        this.sendErrorResponse(var9_44);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + var5_11);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                var5_12 = this.readString();
                this.server.trace("Execute");
                var6_22 = this.portals.get(var5_12);
                if (var6_22 == null) {
                    this.sendErrorResponse("Portal not found: " + var5_12);
                    break;
                }
                var7_32 = this.readShort();
                var8_38 = var6_22.prep;
                var9_45 = var8_38.prep;
                this.server.trace(var8_38.sql);
                try {
                    var9_45.setMaxRows(var7_32);
                    this.setActiveRequest(var9_45);
                    var10_48 = var9_45.execute();
                    if (var10_48) {
                        try {
                            var11_53 = var9_45.getResultSet();
                            while (var11_53.next()) {
                                this.sendDataRow(var11_53);
                            }
                            this.sendCommandComplete(var9_45, 0);
                        }
                        catch (Exception var11_54) {
                            this.sendErrorResponse(var11_54);
                        }
                        break;
                    }
                    this.sendCommandComplete(var9_45, var9_45.getUpdateCount());
                    break;
                }
                catch (Exception var10_49) {
                    if (var9_45.wasCancelled()) {
                        this.sendCancelQueryResponse();
                        break;
                    }
                    this.sendErrorResponse(var10_49);
                    break;
                }
                finally {
                    this.setActiveRequest(null);
                }
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.trace("Query");
                var5_13 = this.readString();
                var6_23 = new ScriptReader(new StringReader(var5_13));
                while (true) {
                    var7_33 = null;
                    var8_39 = var6_23.readStatement();
                    if (var8_39 != null) ** GOTO lbl232
                    JdbcUtils.closeSilently(var7_33);
                    this.setActiveRequest(null);
                    ** GOTO lbl270
lbl232:
                    // 2 sources

                    var8_39 = this.getSQL(var8_39);
                    var7_33 = (JdbcStatement)this.conn.createStatement();
                    this.setActiveRequest(var7_33);
                    var9_46 = var7_33.execute(var8_39);
                    if (!var9_46) ** GOTO lbl253
                    var10_50 = var7_33.getResultSet();
                    var11_55 = var10_50.getMetaData();
                    try {
                        this.sendRowDescription(var11_55);
                        while (var10_50.next()) {
                            this.sendDataRow(var10_50);
                        }
                        this.sendCommandComplete(var7_33, 0);
                    }
                    catch (Exception var12_57) {
                        this.sendErrorResponse(var12_57);
                        JdbcUtils.closeSilently(var7_33);
                        this.setActiveRequest(null);
                    }
                    ** GOTO lbl254
lbl253:
                    // 1 sources

                    this.sendCommandComplete(var7_33, var7_33.getUpdateCount());
lbl254:
                    // 2 sources

                    JdbcUtils.closeSilently(var7_33);
                    this.setActiveRequest(null);
                }
                catch (SQLException var8_40) {
                    try {
                        if (var7_33 == null || !var7_33.wasCancelled()) ** GOTO lbl262
                        this.sendCancelQueryResponse();
                        ** GOTO lbl267
lbl262:
                        // 1 sources

                        this.sendErrorResponse(var8_40);
                    }
                    catch (Throwable var14_59) {
                        JdbcUtils.closeSilently(var7_33);
                        this.setActiveRequest(null);
                        throw var14_59;
                    }
lbl267:
                    // 2 sources

                    JdbcUtils.closeSilently(var7_33);
                    this.setActiveRequest(null);
                }
lbl270:
                // 3 sources

                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + var1_1 + " (" + (char)var1_1 + ")");
            }
        }
    }

    private String getSQL(String string) {
        String string2 = StringUtils.toLowerEnglish(string);
        if (string2.startsWith("show max_identifier_length")) {
            string = "CALL 63";
        } else if (string2.startsWith("set client_encoding to")) {
            string = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(string + ";");
        }
        return string;
    }

    private void sendCommandComplete(JdbcStatement jdbcStatement, int n) throws IOException {
        this.startMessage(67);
        switch (jdbcStatement.getLastExecutedCommandType()) {
            case 61: {
                this.writeStringPart("INSERT 0 ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 68: {
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 58: {
                this.writeStringPart("DELETE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 57: 
            case 66: {
                this.writeString("SELECT");
                break;
            }
            case 83: {
                this.writeString("BEGIN");
                break;
            }
            default: {
                this.server.trace("check CommandComplete tag for command " + jdbcStatement);
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
            }
        }
        this.sendMessage();
    }

    private void sendDataRow(ResultSet resultSet) throws Exception {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.startMessage(68);
        this.writeShort(n);
        for (int i = 1; i <= n; ++i) {
            this.writeDataColumn(resultSet, i, PgServer.convertType(resultSetMetaData.getColumnType(i)));
        }
        this.sendMessage();
    }

    private void writeDataColumn(ResultSet resultSet, int n, int n2) throws Exception {
        if (PgServerThread.formatAsText(n2)) {
            switch (n2) {
                case 16: {
                    this.writeInt(1);
                    this.dataOut.writeByte(resultSet.getBoolean(n) ? 116 : 102);
                    break;
                }
                default: {
                    String string = resultSet.getString(n);
                    if (string == null) {
                        this.writeInt(-1);
                        break;
                    }
                    byte[] byArray = string.getBytes(this.getEncoding());
                    this.writeInt(byArray.length);
                    this.write(byArray);
                    break;
                }
            }
        } else {
            switch (n2) {
                case 21: {
                    this.writeInt(2);
                    this.writeShort(resultSet.getShort(n));
                    break;
                }
                case 23: {
                    this.writeInt(4);
                    this.writeInt(resultSet.getInt(n));
                    break;
                }
                case 20: {
                    this.writeInt(8);
                    this.dataOut.writeLong(resultSet.getLong(n));
                    break;
                }
                case 700: {
                    this.writeInt(4);
                    this.dataOut.writeFloat(resultSet.getFloat(n));
                    break;
                }
                case 701: {
                    this.writeInt(8);
                    this.dataOut.writeDouble(resultSet.getDouble(n));
                    break;
                }
                case 17: {
                    byte[] byArray = resultSet.getBytes(n);
                    if (byArray == null) {
                        this.writeInt(-1);
                        break;
                    }
                    this.writeInt(byArray.length);
                    this.write(byArray);
                    break;
                }
                default: {
                    throw new IllegalStateException("output binary format is undefined");
                }
            }
        }
    }

    private String getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return "UTF-8";
        }
        return this.clientEncoding;
    }

    private void setParameter(PreparedStatement preparedStatement, int n, int n2, int[] nArray) throws SQLException, IOException {
        boolean bl = n2 >= nArray.length || nArray[n2] == 0;
        int n3 = n2 + 1;
        int n4 = this.readInt();
        if (n4 == -1) {
            preparedStatement.setNull(n3, 0);
        } else if (bl) {
            byte[] byArray = DataUtils.newBytes(n4);
            this.readFully(byArray);
            preparedStatement.setString(n3, new String(byArray, this.getEncoding()));
        } else {
            switch (n) {
                case 21: {
                    PgServerThread.checkParamLength(4, n4);
                    preparedStatement.setShort(n3, this.readShort());
                    break;
                }
                case 23: {
                    PgServerThread.checkParamLength(4, n4);
                    preparedStatement.setInt(n3, this.readInt());
                    break;
                }
                case 20: {
                    PgServerThread.checkParamLength(8, n4);
                    preparedStatement.setLong(n3, this.dataIn.readLong());
                    break;
                }
                case 700: {
                    PgServerThread.checkParamLength(4, n4);
                    preparedStatement.setFloat(n3, this.dataIn.readFloat());
                    break;
                }
                case 701: {
                    PgServerThread.checkParamLength(8, n4);
                    preparedStatement.setDouble(n3, this.dataIn.readDouble());
                    break;
                }
                case 17: {
                    byte[] byArray = DataUtils.newBytes(n4);
                    this.readFully(byArray);
                    preparedStatement.setBytes(n3, byArray);
                    break;
                }
                default: {
                    this.server.trace("Binary format for type: " + n + " is unsupported");
                    byte[] byArray = DataUtils.newBytes(n4);
                    this.readFully(byArray);
                    preparedStatement.setString(n3, new String(byArray, this.getEncoding()));
                }
            }
        }
    }

    private static void checkParamLength(int n, int n2) {
        if (n != n2) {
            throw DbException.getInvalidValueException("paramLen", n2);
        }
    }

    private void sendErrorResponse(Exception exception) throws IOException {
        SQLException sQLException = DbException.toSQLException(exception);
        this.server.traceError(sQLException);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(sQLException.getSQLState());
        this.write(77);
        this.writeString(sQLException.getMessage());
        this.write(68);
        this.writeString(sQLException.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendCancelQueryResponse() throws IOException {
        this.server.trace("CancelSuccessResponse");
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("57014");
        this.write(77);
        this.writeString("canceling statement due to user request");
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(Prepared prepared) throws IOException {
        try {
            JdbcPreparedStatement jdbcPreparedStatement = prepared.prep;
            ParameterMetaData parameterMetaData = jdbcPreparedStatement.getParameterMetaData();
            int n = parameterMetaData.getParameterCount();
            this.startMessage(116);
            this.writeShort(n);
            for (int i = 0; i < n; ++i) {
                int n2 = prepared.paramType != null && prepared.paramType[i] != 0 ? prepared.paramType[i] : 1043;
                this.server.checkType(n2);
                this.writeInt(n2);
            }
            this.sendMessage();
        }
        catch (Exception exception) {
            this.sendErrorResponse(exception);
        }
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData resultSetMetaData) throws Exception {
        if (resultSetMetaData == null) {
            this.sendNoData();
        } else {
            int n;
            int n2 = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                String string;
                stringArray[n] = string = resultSetMetaData.getColumnName(n + 1);
                int n3 = resultSetMetaData.getColumnType(n + 1);
                int n4 = PgServer.convertType(n3);
                nArray2[n] = resultSetMetaData.getColumnDisplaySize(n + 1);
                if (n3 != 0) {
                    this.server.checkType(n4);
                }
                nArray[n] = n4;
            }
            this.startMessage(84);
            this.writeShort(n2);
            for (n = 0; n < n2; ++n) {
                this.writeString(StringUtils.toLowerEnglish(stringArray[n]));
                this.writeInt(0);
                this.writeShort(0);
                this.writeInt(nArray[n]);
                this.writeShort(PgServerThread.getTypeSize(nArray[n], nArray2[n]));
                this.writeInt(-1);
                this.writeShort(PgServerThread.formatAsText(nArray[n]) ? 0 : 1);
            }
            this.sendMessage();
        }
    }

    private static boolean formatAsText(int n) {
        switch (n) {
            case 17: {
                return false;
            }
        }
        return true;
    }

    private static int getTypeSize(int n, int n2) {
        switch (n) {
            case 16: {
                return 1;
            }
            case 1043: {
                return Math.max(255, n2 + 10);
            }
        }
        return n2 + 4;
    }

    private void sendErrorResponse(String string) throws IOException {
        this.server.trace("Exception: " + string);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(string);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    private void sendCloseComplete() throws IOException {
        this.startMessage(51);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object object = this.server;
            synchronized (object) {
                resultSet = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
                boolean bl = resultSet.next();
                statement = this.conn.createStatement();
                if (!bl) {
                    PgServerThread.installPgCatalog(statement);
                }
                if (!(resultSet = statement.executeQuery("select * from pg_catalog.pg_version")).next() || resultSet.getInt(1) < 2) {
                    PgServerThread.installPgCatalog(statement);
                } else {
                    int n = resultSet.getInt(2);
                    if (n > 2) {
                        throw DbException.throwInternalError("Incompatible PG_VERSION");
                    }
                }
            }
            statement.execute("set search_path = PUBLIC, pg_catalog");
            object = this.server.getTypeSet();
            if (((HashSet)object).size() == 0) {
                resultSet = statement.executeQuery("select oid from pg_catalog.pg_type");
                while (resultSet.next()) {
                    ((HashSet)object).add(resultSet.getInt(1));
                }
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(resultSet);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(resultSet);
    }

    private static void installPgCatalog(Statement statement) throws SQLException {
        InputStreamReader inputStreamReader = null;
        try {
            String string;
            inputStreamReader = new InputStreamReader(new ByteArrayInputStream(Utils.getResource("/org/h2/server/pg/pg_catalog.sql")));
            ScriptReader scriptReader = new ScriptReader(inputStreamReader);
            while ((string = scriptReader.readStatement()) != null) {
                statement.execute(string);
            }
            scriptReader.close();
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, "Can not read pg_catalog resource");
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStreamReader);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStreamReader);
    }

    void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int n;
        this.startMessage(90);
        try {
            n = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException sQLException) {
            n = 69;
        }
        this.write((byte)n);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.secret);
        this.sendMessage();
    }

    private void writeString(String string) throws IOException {
        this.writeStringPart(string);
        this.write(0);
    }

    private void writeStringPart(String string) throws IOException {
        this.write(string.getBytes(this.getEncoding()));
    }

    private void writeInt(int n) throws IOException {
        this.dataOut.writeInt(n);
    }

    private void writeShort(int n) throws IOException {
        this.dataOut.writeShort(n);
    }

    private void write(byte[] byArray) throws IOException {
        this.dataOut.write(byArray);
    }

    private void write(int n) throws IOException {
        this.dataOut.write(n);
    }

    private void startMessage(int n) {
        this.messageType = n;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] byArray = this.outBuffer.toByteArray();
        int n = byArray.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(n + 4);
        this.dataOut.write(byArray);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String string, String string2) throws IOException {
        this.startMessage(83);
        this.writeString(string);
        this.writeString(string2);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int n) {
        this.processId = n;
    }

    int getProcessId() {
        return this.processId;
    }

    private synchronized void setActiveRequest(JdbcStatement jdbcStatement) {
        this.activeRequest = jdbcStatement;
    }

    private synchronized void cancelRequest() {
        if (this.activeRequest != null) {
            try {
                this.activeRequest.cancel();
                this.activeRequest = null;
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    static class Portal {
        String name;
        int[] resultColumnFormat;
        Prepared prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        JdbcPreparedStatement prep;
        int[] paramType;

        Prepared() {
        }
    }
}

