/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ArtifactRoleAssignmentsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IArtifactRoleAssignmentsService artifactRoleAssignmentsService;

    @AuditedCall(value={"msgType", "artifact-role-assignments-get", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifact-role-assignments/get"}, method={RequestMethod.GET})
    @ResponseBody
    public ArtifactRoleAssignments get(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactRoleAssignmentsService.getArtifactRoleAssignments(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "artifact-role-assignments-get-or-null", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifact-role-assignments/get-or-null"}, method={RequestMethod.GET})
    @ResponseBody
    public ArtifactRoleAssignments getOrNull(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.artifactRoleAssignmentsService.getArtifactRoleAssignmentsOrNull(authCtx, artifactId);
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-role-assignments/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_CREATE)
    @ResponseBody
    public ArtifactRoleAssignments create(HttpServletRequest req, @RequestParam ArtifactRoleAssignments artifactRoleAssignments) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArtifactRoleAssignments createdArtifactRoleAssignments = this.artifactRoleAssignmentsService.createArtifactRoleAssignments(authCtx, artifactRoleAssignments);
            this.auditTrailService.generic("artifact-role-assignments-create").with("artifactId", createdArtifactRoleAssignments.artifactId).emit();
            return createdArtifactRoleAssignments;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-role-assignments-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/artifact-role-assignments/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_SAVE)
    @ResponseBody
    public ArtifactRoleAssignments save(HttpServletRequest req, @RequestParam ArtifactRoleAssignments artifactRoleAssignments) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            ArtifactRoleAssignments savedArtifactRoleAssignments = this.artifactRoleAssignmentsService.saveArtifactRoleAssignments(authCtx, artifactRoleAssignments);
            this.auditTrailService.generic("artifact-role-assignments-save").with("artifactId", savedArtifactRoleAssignments.artifactId).emit();
            return savedArtifactRoleAssignments;
        }
        catch (Exception e) {
            this.auditTrailService.failure("artifact-role-assignments-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "artifact-role-assignments-delete", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/artifact-role-assignments/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ARTIFACT_ROLE_ASSIGNMENTS_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.artifactRoleAssignmentsService.deleteArtifactRoleAssignments(authCtx, artifactId);
    }
}

