/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.services.blueprints.IBlueprintsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class BlueprintsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IBlueprintsService blueprintsService;

    @AuditedCall(value={"msgType", "blueprint-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/blueprints/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BlueprintsController.writeJSON((HttpServletResponse)resp, (Object)this.blueprintsService.getBlueprint(authCtx, blueprintId));
    }

    @AuditedCall(value={"msgType", "blueprints-list"})
    @RequestMapping(value={"/api/blueprints/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BlueprintsController.writeJSON((HttpServletResponse)resp, this.blueprintsService.listBlueprints(authCtx));
    }
}

