/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.dss.DataikuDeploymentSourceObjects;
import com.dataiku.gh.core.models.dss.DataikuSourceObjects;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.dss.govern.IDSSIntegrationService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DSSIntegrationController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IDSSIntegrationService dssIntegrationService;

    @AuditedCall(value={"msgType", "list-related-projects", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/list-related-projects"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIArtifact> listRelatedProjects(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.listRelatedProjects(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "get-dataiku-sources", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/get-dataiku-sources"}, method={RequestMethod.GET})
    @ResponseBody
    public DataikuSourceObjects getDataikuSources(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.getDataikuSources(authCtx, artifactId);
    }

    @AuditedCall(value={"msgType", "get-dataiku-deployment-sources", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/dss/get-dataiku-deployment-sources"}, method={RequestMethod.GET})
    @ResponseBody
    public DataikuDeploymentSourceObjects getDataikuDeploymentSources(HttpServletRequest req, @RequestParam String artifactId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.dssIntegrationService.getDataikuDeploymentSources(authCtx, artifactId);
    }
}

