/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.enriched;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.visitors.IEnrichedArtifactVisitor;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class EnrichedArtifact
extends EnrichedArtifactWithoutPermissions {
    public BlueprintRoleAssignments blueprintRoleAssignments;
    @Nullable
    public ArtifactRoleAssignments artifactRoleAssignments;
    public BlueprintPermissions blueprintPermissions;

    public void accept(IEnrichedArtifactVisitor enrichedArtifactVisitor) {
        super.acceptWithoutSelf(enrichedArtifactVisitor);
        if (this.blueprintRoleAssignments != null) {
            this.blueprintRoleAssignments.accept(enrichedArtifactVisitor);
        }
        if (this.artifactRoleAssignments != null) {
            this.artifactRoleAssignments.accept(enrichedArtifactVisitor);
        }
        if (this.blueprintPermissions != null) {
            this.blueprintPermissions.accept(enrichedArtifactVisitor);
        }
        enrichedArtifactVisitor.visit(this);
    }

    public EnrichedArtifact() {
    }

    public EnrichedArtifact(Blueprint blueprint, BlueprintVersion blueprintVersion, BlueprintVersionTrace blueprintVersionTrace, Artifact artifact, @Nullable List<Signoff> signoffs, EnrichedArtifactDetails enrichedArtifactDetails, BlueprintRoleAssignments blueprintRoleAssignments, @Nullable ArtifactRoleAssignments artifactRoleAssignments, BlueprintPermissions blueprintPermissions) {
        super(blueprint, blueprintVersion, blueprintVersionTrace, artifact, signoffs, enrichedArtifactDetails);
        this.blueprintRoleAssignments = blueprintRoleAssignments;
        this.artifactRoleAssignments = artifactRoleAssignments;
        this.blueprintPermissions = blueprintPermissions;
    }

    public static EnrichedArtifact build(Blueprint blueprint, BlueprintVersion blueprintVersion, BlueprintVersionTrace blueprintVersionTrace, BlueprintRoleAssignments blueprintRoleAssignments, @Nullable ArtifactRoleAssignments artifactRoleAssignments, BlueprintPermissions blueprintPermissions, Artifact artifact, @Nullable List<Signoff> signoffs, EnrichedArtifactDetails enrichedArtifactDetails) {
        return new EnrichedArtifact(blueprint, blueprintVersion, blueprintVersionTrace, artifact, signoffs, enrichedArtifactDetails, blueprintRoleAssignments, artifactRoleAssignments, blueprintPermissions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichedArtifact that = (EnrichedArtifact)o;
        return Objects.equals(this.blueprintRoleAssignments, that.blueprintRoleAssignments) && Objects.equals(this.artifactRoleAssignments, that.artifactRoleAssignments) && Objects.equals(this.blueprintPermissions, that.blueprintPermissions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blueprintRoleAssignments, this.artifactRoleAssignments, this.blueprintPermissions);
    }
}

