/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.system;

import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SystemProvidedEnrichedBlueprint {
    @Nonnull
    public final String blueprintId;
    public final Set<BlueprintVersionId> defaultBlueprintVersionIds = new HashSet<BlueprintVersionId>();
    public final boolean systemLocked;

    private SystemProvidedEnrichedBlueprint(@Nonnull String blueprintId, boolean systemLocked, Set<String> defaultBlueprintVersionIds) {
        this.blueprintId = blueprintId;
        this.systemLocked = systemLocked;
        this.defaultBlueprintVersionIds.addAll(defaultBlueprintVersionIds.stream().map(verId -> BlueprintVersionId.build(this.blueprintId, verId)).collect(Collectors.toSet()));
    }

    public boolean matchBlueprint(String other) {
        return this.blueprintId.equals(other);
    }

    public boolean matchBlueprint(BlueprintVersionId blueprintVersionId) {
        return this.blueprintId.equals(blueprintVersionId.blueprintId);
    }

    public BlueprintVersionId findByVersionId(String versionId) {
        return this.defaultBlueprintVersionIds.stream().filter(bpvId -> StringUtils.equals((CharSequence)bpvId.versionId, (CharSequence)versionId)).findAny().orElseThrow(() -> new ValidationException("Cannot find default system version: " + versionId + " for blueprint: " + this.blueprintId));
    }

    public static SystemProvidedEnrichedBlueprint build(@Nonnull String blueprintId, boolean lockedArtifacts, Set<String> defaultBlueprintVersionIds) {
        return new SystemProvidedEnrichedBlueprint(blueprintId, lockedArtifacts, defaultBlueprintVersionIds);
    }

    public static class SingleSystemProvidedEnrichedBlueprint
    extends SystemProvidedEnrichedBlueprint {
        private SingleSystemProvidedEnrichedBlueprint(@Nonnull String blueprintId, boolean lockedArtifacts, String singleDefaultBlueprintVersionId) {
            super(blueprintId, lockedArtifacts, Sets.newHashSet((Object[])new String[]{singleDefaultBlueprintVersionId}));
        }

        public BlueprintVersionId getSingleDefaultBlueprintVersionId() {
            if (this.defaultBlueprintVersionIds.size() != 1) {
                throw new IllegalStateException("No single default BlueprintVersion for this System Blueprint: " + this.blueprintId);
            }
            return (BlueprintVersionId)this.defaultBlueprintVersionIds.stream().findAny().get();
        }

        public static SingleSystemProvidedEnrichedBlueprint build(@Nonnull String blueprintId, boolean lockedArtifacts, String singleDefaultBlueprintVersionId) {
            return new SingleSystemProvidedEnrichedBlueprint(blueprintId, lockedArtifacts, singleDefaultBlueprintVersionId);
        }
    }
}

