/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.ui.UIBlueprint;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIAdminBlueprintsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;
    @Autowired
    private IAdminBlueprintsService adminBlueprintsService;

    @AuditedCall(value={"msgType", "admin-blueprints-list"})
    @RequestMapping(value={"/publicapi/admin/blueprints"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIBlueprint> list(HttpServletRequest req) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.listBlueprints(authCtx);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprints"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_CREATE)
    @ResponseBody
    public UIBlueprint create(HttpServletRequest req, @RequestParam String newIdentifier) throws Exception {
        try {
            Blueprint b = (Blueprint)this.getRequestBodyAs(req, Blueprint.class);
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            UIBlueprint uiBlueprint = this.adminBlueprintsService.createBlueprint(authCtx, b, newIdentifier);
            this.auditTrailService.generic("admin-blueprint-create").with("blueprintId", uiBlueprint.blueprint.id).emit();
            return uiBlueprint;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-blueprint-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}"}, method={RequestMethod.GET})
    @ResponseBody
    public UIBlueprint get(HttpServletRequest req, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.getBlueprint(authCtx, blueprintId);
    }

    @AuditedCall(value={"msgType", "admin-blueprint-save", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_SAVE)
    @ResponseBody
    public UIBlueprint save(HttpServletRequest req, @PathVariable String blueprintId) throws Exception {
        Blueprint b = (Blueprint)this.getRequestBodyAs(req, Blueprint.class);
        if (!StringUtils.equals((CharSequence)blueprintId, (CharSequence)b.id)) {
            throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + b.id);
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminBlueprintsService.saveBlueprint(authCtx, b);
    }

    @AuditedCall(value={"msgType", "admin-blueprint-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint/{blueprintId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminBlueprintsService.deleteBlueprint(authCtx, blueprintId);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint/import-with-versions"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_IMPORT)
    @ResponseBody
    public UIBlueprint importWithVersions(HttpServletRequest req, @RequestParam(required=false) UsersContainersValidationConfig.ValidationBehavior signoffImportRoles, @RequestParam(required=false) BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws Exception {
        try {
            JsonObject blueprintWithVersionsJson = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
            BlueprintExport blueprintExport = this.importExportMigrationService.unwrapAndMigrateExportedEntity(blueprintWithVersionsJson, BlueprintExport.class);
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            UIBlueprint result = this.adminBlueprintsService.importBlueprintWithVersions(authCtx, blueprintExport, Optional.ofNullable(signoffImportRoles).orElse(UsersContainersValidationConfig.ValidationBehavior.ALL), Optional.ofNullable(migrationPathImportBehavior).orElse(BlueprintVersionExport.MigrationPathImportBehavior.FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION));
            this.auditTrailService.generic("admin-blueprint-with-versions-import").with("blueprintId", result.blueprint.id).emit();
            return result;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-with-versions-import", (Throwable)e).emit();
            throw e;
        }
    }
}

