/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV14100
extends Migration {
    private Long actionId;

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"dataiku_bundle", "blueprint_version_default.json"}), "bp.system.dataiku_bundle", "bv.system.default", actionId, migrationTS);
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrateBlueprintVersions(dbMigrationDAO);
    }

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    private void migrateBlueprintVersions(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions", "blueprint_version_blueprint_id=? AND blueprint_version_version_id=?", "blueprint_version_json", null, null, bpv -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null)), MigrationV14100::migrateBlueprintVersion);
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructureHistoryAtTimestamp(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions_history", "blueprint_version_json", null, this::migrateBlueprintVersionHistory);
    }

    public static JsonObject migrateBlueprintVersion(JsonObject blueprintVersion) {
        JsonObject views = MigrationJsonUtils.getObjectSubpath((JsonElement)blueprintVersion, "uiDefinition", "views").orElse(null);
        if (views == null) {
            return blueprintVersion;
        }
        JsonObject newViews = new JsonObject();
        views.entrySet().forEach(entry -> {
            if (entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonObject()) {
                newViews.add((String)entry.getKey(), (JsonElement)MigrationV14100.migrateView(((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        });
        blueprintVersion.getAsJsonObject("uiDefinition").add("views", (JsonElement)newViews);
        return blueprintVersion;
    }

    private JsonObject migrateBlueprintVersionHistory(MigrationEntitiesUtilsBetweenV13300AndBeyond.JSONObjectAtTimestamp blueprintVersionAtTimestamp) {
        JsonObject blueprintVersion = blueprintVersionAtTimestamp.jsonObject;
        return MigrationV14100.migrateBlueprintVersion(blueprintVersion);
    }

    private static JsonObject migrateView(JsonObject view) {
        JsonObject viewComponent = MigrationJsonUtils.getObjectSubpath((JsonElement)view, "viewComponent").orElse(null);
        if (viewComponent == null) {
            return view;
        }
        view.add("viewComponent", (JsonElement)MigrationV14100.migrateViewComponent(viewComponent));
        return view;
    }

    private static JsonObject migrateViewComponent(JsonObject viewComponent) {
        JsonObject visibilityCondition;
        if (MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse("").equals("container")) {
            JsonArray viewComponents = MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").orElse(null);
            if (viewComponents == null) {
                return viewComponent;
            }
            JsonArray newViewComponents = new JsonArray();
            for (JsonElement component : viewComponents) {
                if (!component.isJsonObject()) continue;
                newViewComponents.add((JsonElement)MigrationV14100.migrateViewComponent(component.getAsJsonObject()));
            }
            viewComponent.getAsJsonObject("layout").add("viewComponents", (JsonElement)newViewComponents);
        }
        if ((visibilityCondition = (JsonObject)MigrationJsonUtils.getObjectSubpath((JsonElement)viewComponent, "visibilityCondition").orElse(null)) == null) {
            return viewComponent;
        }
        if (MigrationJsonUtils.getStringSubpath((JsonElement)visibilityCondition, "type").orElse("").equals("field-value")) {
            String fieldId = MigrationJsonUtils.getStringSubpath((JsonElement)visibilityCondition, "fieldId").orElse(null);
            String conditionType = MigrationJsonUtils.getStringSubpath((JsonElement)visibilityCondition, "conditionType").orElse(null);
            if (fieldId == null || conditionType == null) {
                viewComponent.remove("visibilityCondition");
                return viewComponent;
            }
            JsonObject plainTextFilter = new JsonObject();
            plainTextFilter.addProperty("type", "field");
            plainTextFilter.addProperty("fieldId", fieldId);
            if (conditionType.equals("IS_EMPTY")) {
                plainTextFilter.addProperty("conditionType", "IS_NULL");
            } else {
                plainTextFilter.addProperty("conditionType", conditionType);
                MigrationJsonUtils.getStringSubpath((JsonElement)visibilityCondition, "condition").ifPresent(condition -> plainTextFilter.addProperty("condition", condition));
            }
            plainTextFilter.addProperty("caseSensitive", Boolean.valueOf(MigrationJsonUtils.getUnboxedBooleanSubpath((JsonElement)visibilityCondition, false, "caseSensitive")));
            plainTextFilter.addProperty("negateOperator", Boolean.valueOf(MigrationJsonUtils.getUnboxedBooleanSubpath((JsonElement)visibilityCondition, false, "negateCondition")));
            plainTextFilter.addProperty("negateCondition", Boolean.valueOf(false));
            plainTextFilter.addProperty("canBeReference", Boolean.valueOf(true));
            JsonObject typedFieldOrArtifactFilter = new JsonObject();
            typedFieldOrArtifactFilter.addProperty("type", "typed-field-or");
            typedFieldOrArtifactFilter.addProperty("fieldId", fieldId);
            typedFieldOrArtifactFilter.addProperty("negateCondition", Boolean.valueOf(false));
            typedFieldOrArtifactFilter.add("plaintextFilter", (JsonElement)plainTextFilter);
            JsonArray artifactFilters = new JsonArray();
            artifactFilters.add((JsonElement)typedFieldOrArtifactFilter);
            JsonObject andArtifactFilter = new JsonObject();
            andArtifactFilter.addProperty("type", "and");
            andArtifactFilter.addProperty("negateCondition", Boolean.valueOf(false));
            andArtifactFilter.add("artifactFilters", (JsonElement)artifactFilters);
            viewComponent.add("visibilityCondition", (JsonElement)andArtifactFilter);
        }
        return viewComponent;
    }
}

