/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.search_artifacts;

import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSAPIDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDatasetIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerDeploymentIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectDeployerInfraIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSRetrievableKnowledgeIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.dss_gh.api.visitors.IDSSItemIdentifierVisitor;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactFilterFieldConditionType;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.utils.ValidationUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DSSIntegrationArtifactsSearchQueryBuilder {
    public static List<ArtifactFilter> buildFilters(String nodeId, List<SystemProvidedEnrichedBlueprint> blueprints) {
        return DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(nodeId, blueprints, (List<ArtifactFilter>)Lists.newArrayList());
    }

    public static List<ArtifactFilter> buildFilters(String nodeId, List<SystemProvidedEnrichedBlueprint> blueprints, List<ArtifactFilter> additionalFilters) {
        ArrayList filters = Lists.newArrayList();
        filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(blueprints));
        filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("node_id", nodeId, false, false));
        filters.addAll(additionalFilters);
        return filters;
    }

    public static List<ArtifactFilter> buildFilters(DSSProjectIdentifier dssProjectIdentifier, List<SystemProvidedEnrichedBlueprint> blueprints, List<ArtifactFilter> additionalFilters) {
        ArrayList filters = Lists.newArrayList();
        filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(blueprints));
        filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("node_id", dssProjectIdentifier.nodeId, false, false));
        filters.add(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("project_key", dssProjectIdentifier.projectKey, false, false));
        filters.addAll(additionalFilters);
        return filters;
    }

    public static ArtifactFilter buildBlueprintFilter(SystemProvidedEnrichedBlueprint ... blueprints) {
        return DSSIntegrationArtifactsSearchQueryBuilder.buildBlueprintFilter(Arrays.asList(blueprints));
    }

    public static ArtifactFilter buildBlueprintFilter(List<SystemProvidedEnrichedBlueprint> blueprints) {
        List<String> blueprintIds = blueprints.stream().map(systemBlueprint -> systemBlueprint.blueprintId).collect(Collectors.toList());
        return ArtifactFilter.BlueprintsArtifactFilter.build(blueprintIds);
    }

    public static ArtifactFilter buildFieldValueArtifactFilter(String fieldId, String condition, boolean negateCondition, boolean canBeReference) {
        return ArtifactFilter.FieldValueArtifactFilter.build(ArtifactFilterFieldConditionType.EQUALS, condition, fieldId, negateCondition, true, canBeReference);
    }

    public static class DeployerItemQueryBuilder
    implements IDSSItemIdentifierVisitor {
        public List<ArtifactFilter> artifactFilters = new ArrayList<ArtifactFilter>();

        public void visit(DSSProjectIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSDatasetIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSBundleIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSSavedModelIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSRetrievableKnowledgeIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSSavedModelVersionIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForProjectIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSAPIDeployerInfraIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(identifier.nodeId, Collections.singletonList(SystemProvidedConstants.API_DEPLOYER_INFRA), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("infrastructure_id", identifier.infraId, false, false)));
        }

        public void visit(DSSAPIDeployerDeploymentIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(identifier.nodeId, Collections.singletonList(SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("deployment_id", identifier.deploymentId, false, false)));
        }

        public void visit(DSSProjectDeployerInfraIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(identifier.nodeId, Collections.singletonList(SystemProvidedConstants.PROJECT_DEPLOYER_INFRA), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("infrastructure_id", identifier.infraId, false, false)));
        }

        public void visit(DSSProjectDeployerDeploymentIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(identifier.nodeId, Collections.singletonList(SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("deployment_id", identifier.deploymentId, false, false)));
        }
    }

    public static class ProjectItemAndSubItemsQueryBuilder
    implements IDSSItemIdentifierVisitor {
        public List<ArtifactFilter> artifactFilters = new ArrayList<ArtifactFilter>();

        public void visit(DSSProjectIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(identifier, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList(SystemProvidedConstants.DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.values()), Collections.emptyList());
        }

        public void visit(DSSDatasetIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)identifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_DATASET), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("dataset_name", identifier.datasetName, false, false)));
        }

        public void visit(DSSBundleIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)identifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_BUNDLE), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("bundle_id", identifier.bundleId, false, false)));
        }

        public void visit(DSSSavedModelIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)identifier, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList((Object[])new SystemProvidedEnrichedBlueprint[]{SystemProvidedConstants.DATAIKU_SAVED_MODEL, SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION}), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("saved_model_id", identifier.savedModelId, false, false)));
        }

        public void visit(DSSRetrievableKnowledgeIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)identifier, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList((Object[])new SystemProvidedEnrichedBlueprint[]{SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE}), Collections.singletonList(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("retrievable_knowledge_id", identifier.retrievableKnowledgeId, false, false)));
        }

        public void visit(DSSSavedModelVersionIdentifier identifier) {
            this.artifactFilters = DSSIntegrationArtifactsSearchQueryBuilder.buildFilters((DSSProjectIdentifier)identifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{ArtifactFilter.BlueprintVersionsArtifactFilter.build(Lists.newArrayList((Object[])new BlueprintVersionId[]{SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.prediction"), SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.clustering"), SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.fine_tuning"), SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.findByVersionId("bv.system.agent")})), DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("saved_model_id", identifier.savedModelId, false, false), DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("full_model_version_id", identifier.fullModelVersionId, false, false)}));
        }

        public void visit(DSSAPIDeployerInfraIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForDeployerIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSAPIDeployerDeploymentIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForDeployerIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSProjectDeployerInfraIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForDeployerIdentifier((DSSItemIdentifier)identifier);
        }

        public void visit(DSSProjectDeployerDeploymentIdentifier identifier) {
            ValidationUtils.throwIllegalArgumentExceptionForDeployerIdentifier((DSSItemIdentifier)identifier);
        }
    }
}

