/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.uploaded_files;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.gh.core.models.ui.UploadedFileDescException;
import com.dataiku.gh.core.models.uploaded_files.UploadedFile;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.services.relationships.handlers.IUploadedFileRelationshipHandler;
import com.dataiku.gh.core.services.relationships.permissions.IUploadedFileRelationshipPermissionService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.storage.uploaded_files.IUploadedFileDAO;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.server.services.GeneralSettingsService;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UploadedFilesService
implements IUploadedFilesService {
    @Autowired
    private IUploadedFileDAO uploadedFilesDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private IUploadedFileRelationshipPermissionService uploadedFileRelationshipPermissionService;
    @Autowired
    private IUploadedFileRelationshipHandler uploadedFileRelationshipHandler;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;

    @Override
    @GHWriteTransaction
    public UploadedFileDesc getUploadedFileDesc(AuthCtx authCtx, String id) throws IOException, DKUSecurityException {
        UploadedFileDesc uploadedFileDesc = this.uploadedFilesDAO.getUploadedFileDesc(id);
        this.uploadedFileRelationshipPermissionService.checkRelationshipReadPermission(authCtx, uploadedFileDesc);
        return uploadedFileDesc;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @GHWriteTransaction
    public List<Either<UploadedFileDescException, UploadedFileDesc>> getUploadedFileDescsOrExceptions(AuthCtx authCtx, List<String> ids) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkReadGovernAllowed(authCtx);
        try (Stream<UploadedFileDesc> uploadFileDescStream = this.uploadedFilesDAO.listUploadedFileDescStream(ids);){
            UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();
            try {
                List<Either<UploadedFileDescException, UploadedFileDesc>> result = uploadFileDescStream.map(uploadedFileDesc -> this.mapToUploadedFileDescOrUploadedFileDescException_NoLicenseCheck_UncheckedIOException(authCtx, (UploadedFileDesc)uploadedFileDesc)).collect(Collectors.toList());
                HashSet<String> requestedIds = new HashSet<String>(ids);
                if (requestedIds.size() != result.size()) {
                    Set existingUploadedFileIds = result.stream().map(i -> i.isRight() ? ((UploadedFileDesc)i.getRight()).id : ((UploadedFileDescException)i.getLeft()).uploadedFileId).collect(Collectors.toSet());
                    for (String uploadedFileId : requestedIds) {
                        if (existingUploadedFileIds.contains(uploadedFileId)) continue;
                        result.add(Either.left(UploadedFileDescException.build(uploadedFileId, (Exception)((Object)new NotFoundException("Uploaded file does not exist: " + uploadedFileId)))));
                    }
                }
                List<Either<UploadedFileDescException, UploadedFileDesc>> list = result;
                if (rolesCache != null) {
                    rolesCache.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (rolesCache != null) {
                    try {
                        rolesCache.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Either<UploadedFileDescException, UploadedFileDesc> mapToUploadedFileDescOrUploadedFileDescException_NoLicenseCheck_UncheckedIOException(AuthCtx authCtx, UploadedFileDesc uploadedFileDesc) {
        try {
            this.uploadedFileRelationshipPermissionService.checkRelationshipReadPermission_NoLicenseCheck(authCtx, uploadedFileDesc);
            return Either.right(uploadedFileDesc);
        }
        catch (DKUSecurityException e) {
            return Either.left(UploadedFileDescException.build(uploadedFileDesc.id, (Exception)((Object)e)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @GHWriteTransaction
    public UploadedFile getUploadedFile(AuthCtx authCtx, String id) throws IOException, DKUSecurityException {
        UploadedFileDesc uploadedFileDesc = this.uploadedFilesDAO.getUploadedFileDesc(id);
        this.uploadedFileRelationshipPermissionService.checkRelationshipReadPermission(authCtx, uploadedFileDesc);
        return this.uploadedFilesDAO.getUploadedFile(id);
    }

    @Override
    @GHWriteTransaction
    public UploadedFileDesc uploadFile(AuthCtx authCtx, String filename, InputStream is, long size) throws IOException, DKUSecurityException {
        Long uploadedFilesMaxSize;
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        try (Transaction t = this.transactionService.beginRead();){
            uploadedFilesMaxSize = this.generalSettingsService.read().uploadedFilesMaxSize;
        }
        if (uploadedFilesMaxSize != null && size > uploadedFilesMaxSize) {
            throw ErrorContext.iae((String)("Uploaded file exceeds max file size (" + uploadedFilesMaxSize + ")"));
        }
        UploadedFileDesc uploadedFileDesc = new UploadedFileDesc();
        uploadedFileDesc.id = IdentifiersUtils.buildUploadedFileId(this.uploadedFilesDAO.newId());
        uploadedFileDesc.owner = authCtx.getIdentifier();
        uploadedFileDesc.name = filename;
        String ext = FilenameUtils.getExtension((String)filename);
        MimeTypeUtils.MimeType mt = MimeTypeUtils.fromExtension((String)ext);
        uploadedFileDesc.type = mt == null ? "application/octet-stream" : mt.mimeType;
        return this.uploadedFilesDAO.uploadFile(uploadedFileDesc, is, size);
    }

    @Override
    @GHWriteTransaction
    public void deleteUploadedFile(AuthCtx authCtx, String id) throws IOException, DKUSecurityException {
        UploadedFileDesc uploadedFileDesc = this.uploadedFilesDAO.getUploadedFileDesc(id);
        this.uploadedFileRelationshipPermissionService.checkRelationshipWritePermission(authCtx, uploadedFileDesc);
        this.uploadedFileRelationshipHandler.deleteRelationships(this.uploadedFileRelationshipHandler.getRelationshipsByEntityId(id));
        this.uploadedFilesDAO.deleteUploadedFile(id);
    }

    @Override
    @GHWriteTransaction
    public void deleteOwnersFromUploadedFiles(String owner) throws IOException {
        this.uploadedFilesDAO.deleteOwnersFromUploadedFiles(owner);
    }
}

