/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingFieldValueCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingStatusCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.BlueprintVersionIdCriterion;
import com.dataiku.gh.core.models.security.GlobalAPIKeyUsersContainer;
import com.dataiku.gh.core.models.security.GroupUsersContainer;
import com.dataiku.gh.core.models.security.RoleUsersContainer;
import com.dataiku.gh.core.models.security.UserUsersContainer;
import com.dataiku.gh.core.models.security.UsersContainersExtraction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.IRoleAssignmentsRulesVisitor;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RoleAssignmentsRulesValidator
implements IRoleAssignmentsRulesVisitor {
    protected final String parentId;
    private final Set<String> roles = new HashSet<String>();
    public final UsersContainersExtraction usersContainersExtraction = new UsersContainersExtraction();

    public RoleAssignmentsRulesValidator(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public void visit(String roleId, List<RoleAssignmentsRule> value) {
        this.roles.add(roleId);
    }

    @Override
    public void visit(UserUsersContainer userUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)userUsersContainer.login), "User login cannot be empty", new Object[0]);
        this.usersContainersExtraction.add(userUsersContainer);
    }

    @Override
    public void visit(GroupUsersContainer groupUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)groupUsersContainer.groupName), "Group name cannot be empty", new Object[0]);
        this.usersContainersExtraction.add(groupUsersContainer);
    }

    @Override
    public void visit(GlobalAPIKeyUsersContainer globalAPIKeyUsersContainer) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)globalAPIKeyUsersContainer.globalAPIKeyId), "API Key ID cannot be empty", new Object[0]);
        this.usersContainersExtraction.add(globalAPIKeyUsersContainer);
    }

    @Override
    public void visit(RoleUsersContainer roleUsersContainer) {
        throw new ValidationException("Usage of RoleUsersContainer is currently not possible inside RoleAssignmentsRule for " + this.parentId);
    }

    @Override
    public void visit(String roleId, BlueprintVersionIdCriterion blueprintVersionIdCriterion) {
        if (StringUtils.isBlank((CharSequence)blueprintVersionIdCriterion.versionId)) {
            throw new ValidationException("BlueprintVersionIdCriterion versionId cannot be blank in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
        }
    }

    @Override
    public void visit(String roleId, ArtifactExistingStatusCriterion artifactExistingStatusCriterion) {
        if (StringUtils.isBlank((CharSequence)artifactExistingStatusCriterion.stepId)) {
            throw new ValidationException("ArtifactExistingStatusCriterion stepId cannot be blank in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
        }
    }

    @Override
    public void visit(String roleId, ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion) {
        if (StringUtils.isBlank((CharSequence)artifactExistingFieldValueCriterion.fieldId)) {
            throw new ValidationException("ArtifactExistingFieldValueCriterion fieldId cannot be blank in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
        }
        switch (artifactExistingFieldValueCriterion.operator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case CONTAINS: 
            case NOT_CONTAINS: {
                break;
            }
            case IN: 
            case NOT_IN: {
                Object providedValue = JSON.parse((JsonElement)artifactExistingFieldValueCriterion.value, Object.class);
                if (providedValue instanceof List && !CollectionUtils.isEmpty((Collection)((List)providedValue))) break;
                throw new ValidationException("ArtifactExistingFieldValueCriterion value for operator " + String.valueOf((Object)artifactExistingFieldValueCriterion.operator) + " must be a non-empty list in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
            }
            case IS_EMPTY: 
            case IS_NOT_EMPTY: {
                if (artifactExistingFieldValueCriterion.value == null) break;
                throw new ValidationException("ArtifactExistingFieldValueCriterion value for operator " + String.valueOf((Object)artifactExistingFieldValueCriterion.operator) + " must not be set in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
            }
            default: {
                throw new ValidationException("ArtifactExistingFieldValueCriterion operator unknown " + String.valueOf((Object)artifactExistingFieldValueCriterion.operator) + " in a criterion of an assignment rule for " + this.parentId + " and role ID " + roleId);
            }
        }
    }

    public void validateRoles(IRoleDAO roleDAO) throws IOException {
        for (String roleId : this.roles) {
            if (roleDAO.exists(roleId)) continue;
            throw new NotFoundException("Role not found: " + roleId + " (assigned in a rule of " + this.parentId + ")");
        }
    }
}

